/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.slot;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import com.yomahub.liteflow.exception.NullParamException;
import com.yomahub.liteflow.flow.entity.CmpStep;
import java.util.Iterator;
import java.util.Queue;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slot<O> {
    private static final Logger LOG = LoggerFactory.getLogger(Slot.class);
    private static final String REQUEST = "_request";
    private static final String RESPONSE = "_response";
    private static final String CHAIN_NAME = "_chain_name";
    private static final String COND_NODE_PREFIX = "_cond_";
    private static final String NODE_INPUT_PREFIX = "_input_";
    private static final String NODE_OUTPUT_PREFIX = "_output_";
    private static final String CHAIN_REQ_PREFIX = "_chain_req_";
    private static final String REQUEST_ID = "_req_id";
    private static final String EXCEPTION = "_exception";
    private static final String PRIVATE_DELIVERY_PREFIX = "_private_d_";
    private final Queue<CmpStep> executeSteps = new ConcurrentLinkedQueue<CmpStep>();
    private String executeStepsStr;
    protected ConcurrentHashMap<String, Object> metaDataMap = new ConcurrentHashMap();
    private O contextBean;

    public Slot() {
    }

    public Slot(O contextBean) {
        this.contextBean = contextBean;
    }

    private boolean hasMetaData(String key) {
        return this.metaDataMap.containsKey(key);
    }

    private <T> void putMetaDataMap(String key, T t) {
        if (ObjectUtil.isNull(t)) {
            throw new NullParamException("data slot can't accept null param");
        }
        this.metaDataMap.put(key, t);
    }

    public <T> T getInput(String nodeId) {
        return (T)this.metaDataMap.get(NODE_INPUT_PREFIX + nodeId);
    }

    public <T> T getOutput(String nodeId) {
        return (T)this.metaDataMap.get(NODE_OUTPUT_PREFIX + nodeId);
    }

    public <T> void setInput(String nodeId, T t) {
        this.putMetaDataMap(NODE_INPUT_PREFIX + nodeId, t);
    }

    public <T> void setOutput(String nodeId, T t) {
        this.putMetaDataMap(NODE_OUTPUT_PREFIX + nodeId, t);
    }

    public <T> T getRequestData() {
        return (T)this.metaDataMap.get(REQUEST);
    }

    public <T> void setRequestData(T t) {
        this.putMetaDataMap(REQUEST, t);
    }

    public <T> T getResponseData() {
        return (T)this.metaDataMap.get(RESPONSE);
    }

    public <T> void setResponseData(T t) {
        this.putMetaDataMap(RESPONSE, t);
    }

    public <T> T getChainReqData(String chainId) {
        return (T)this.metaDataMap.get(CHAIN_REQ_PREFIX + chainId);
    }

    public <T> void setChainReqData(String chainId, T t) {
        this.putMetaDataMap(CHAIN_REQ_PREFIX + chainId, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setPrivateDeliveryData(String nodeId, T t) {
        String privateDKey = PRIVATE_DELIVERY_PREFIX + nodeId;
        Slot slot = this;
        synchronized (slot) {
            if (this.metaDataMap.containsKey(privateDKey)) {
                Queue queue = (Queue)this.metaDataMap.get(privateDKey);
                queue.add(t);
            } else {
                ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue<T>();
                queue.add(t);
                this.putMetaDataMap(privateDKey, queue);
            }
        }
    }

    public <T> Queue<T> getPrivateDeliveryQueue(String nodeId) {
        String privateDKey = PRIVATE_DELIVERY_PREFIX + nodeId;
        if (this.metaDataMap.containsKey(privateDKey)) {
            return (Queue)this.metaDataMap.get(privateDKey);
        }
        return null;
    }

    public <T> T getPrivateDeliveryData(String nodeId) {
        String privateDKey = PRIVATE_DELIVERY_PREFIX + nodeId;
        if (this.metaDataMap.containsKey(privateDKey)) {
            Queue queue = (Queue)this.metaDataMap.get(privateDKey);
            return (T)queue.poll();
        }
        return null;
    }

    public <T> void setCondResult(String key, T t) {
        this.putMetaDataMap(COND_NODE_PREFIX + key, t);
    }

    public <T> T getCondResult(String key) {
        return (T)this.metaDataMap.get(COND_NODE_PREFIX + key);
    }

    public void pushChainName(String chainName) {
        if (this.hasMetaData(CHAIN_NAME)) {
            Stack stack = (Stack)this.metaDataMap.get(CHAIN_NAME);
            stack.push(chainName);
        } else {
            Stack<String> stack = new Stack<String>();
            stack.push(chainName);
            this.putMetaDataMap(CHAIN_NAME, stack);
        }
    }

    public void popChainName() {
        Stack stack;
        if (this.hasMetaData(CHAIN_NAME) && (stack = (Stack)this.metaDataMap.get(CHAIN_NAME)).size() > 1) {
            stack.pop();
        }
    }

    public String getChainName() {
        try {
            Stack stack = (Stack)this.metaDataMap.get(CHAIN_NAME);
            return (String)stack.peek();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void addStep(CmpStep step) {
        this.executeSteps.add(step);
    }

    public String getExecuteStepStr(boolean withTimeSpent) {
        StringBuilder str = new StringBuilder();
        Iterator it = this.executeSteps.iterator();
        while (it.hasNext()) {
            CmpStep cmpStep = (CmpStep)it.next();
            if (withTimeSpent) {
                str.append(cmpStep.buildStringWithTime());
            } else {
                str.append(cmpStep.buildString());
            }
            if (!it.hasNext()) continue;
            str.append("==>");
        }
        this.executeStepsStr = str.toString();
        return this.executeStepsStr;
    }

    public String getExecuteStepStr() {
        return this.getExecuteStepStr(false);
    }

    public void printStep() {
        if (ObjectUtil.isNull((Object)this.executeStepsStr)) {
            this.executeStepsStr = this.getExecuteStepStr(true);
        }
        LOG.info("[{}]:CHAIN_NAME[{}]\n{}", new Object[]{this.getRequestId(), this.getChainName(), this.executeStepsStr});
    }

    public void generateRequestId() {
        this.metaDataMap.put(REQUEST_ID, IdUtil.fastSimpleUUID());
    }

    public String getRequestId() {
        return (String)this.metaDataMap.get(REQUEST_ID);
    }

    public Queue<CmpStep> getExecuteSteps() {
        return this.executeSteps;
    }

    public Exception getException() {
        return (Exception)this.metaDataMap.get(EXCEPTION);
    }

    public void setException(Exception e) {
        this.putMetaDataMap(EXCEPTION, e);
    }

    public O getContextBean() {
        return this.contextBean;
    }
}

