/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.util;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.annotation.LiteflowCmpDefine;
import com.yomahub.liteflow.annotation.LiteflowCondCmpDefine;
import com.yomahub.liteflow.annotation.LiteflowMethod;
import com.yomahub.liteflow.core.NodeComponent;
import com.yomahub.liteflow.core.NodeCondComponent;
import com.yomahub.liteflow.core.proxy.ComponentProxy;
import com.yomahub.liteflow.exception.ComponentProxyErrorException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteFlowProxyUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LiteFlowProxyUtil.class);

    public static boolean isMarkedCmp(Class<?> clazz) {
        boolean flag2;
        boolean flag1;
        boolean bl = flag1 = clazz.getAnnotation(LiteflowCmpDefine.class) != null || clazz.getAnnotation(LiteflowCondCmpDefine.class) != null;
        if (!flag1) {
            return false;
        }
        boolean bl2 = flag2 = !ListUtil.toList((Object[])new Class[]{NodeComponent.class, NodeCondComponent.class}).contains(clazz.getSuperclass());
        if (!flag2) {
            return false;
        }
        Class<?> targetClass = LiteFlowProxyUtil.isCglibProxyClass(clazz) ? LiteFlowProxyUtil.getUserClass(clazz) : clazz;
        boolean flag3 = Arrays.stream(targetClass.getMethods()).anyMatch(method -> method.getAnnotation(LiteflowMethod.class) != null);
        return flag3;
    }

    public static NodeComponent proxy2NodeComponent(Object bean, String nodeId) {
        try {
            LiteflowCmpDefine liteflowCmpDefine = bean.getClass().getAnnotation(LiteflowCmpDefine.class);
            LiteflowCondCmpDefine liteflowCondCmpDefine = bean.getClass().getAnnotation(LiteflowCondCmpDefine.class);
            if (ObjectUtil.isNotNull((Object)liteflowCmpDefine)) {
                ComponentProxy proxy = new ComponentProxy(nodeId, bean, NodeComponent.class);
                return (NodeComponent)proxy.getProxy();
            }
            if (ObjectUtil.isNotNull((Object)liteflowCondCmpDefine)) {
                ComponentProxy proxy = new ComponentProxy(nodeId, bean, NodeCondComponent.class);
                return (NodeCondComponent)proxy.getProxy();
            }
            throw new RuntimeException();
        }
        catch (Exception e) {
            String errMsg = StrUtil.format((CharSequence)"Error while proxying bean[{}]", (Object[])new Object[]{bean.getClass().getName()});
            LOG.error(errMsg, (Throwable)e);
            throw new ComponentProxyErrorException(errMsg);
        }
    }

    public static boolean isCglibProxyClass(Class<?> clazz) {
        return clazz != null && LiteFlowProxyUtil.isCglibProxyClassName(clazz.getName());
    }

    public static Class<?> getUserClass(Class<?> clazz) {
        Class<?> superclass;
        if (clazz.getName().contains("$$") && (superclass = clazz.getSuperclass()) != null && superclass != Object.class) {
            return superclass;
        }
        return clazz;
    }

    private static boolean isCglibProxyClassName(String className) {
        return className != null && className.contains("$$");
    }
}

