/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.springboot.config;

import com.yomahub.liteflow.core.FlowExecutor;
import com.yomahub.liteflow.monitor.MonitorBus;
import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.spi.spring.SpringAware;
import com.yomahub.liteflow.spring.ComponentScanner;
import com.yomahub.liteflow.springboot.LiteflowExecutorInit;
import com.yomahub.liteflow.springboot.config.LiteflowPropertyAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureAfter(value={LiteflowPropertyAutoConfiguration.class})
@ConditionalOnBean(value={LiteflowConfig.class})
@ConditionalOnProperty(prefix="liteflow", name={"enable"}, havingValue="true")
@Import(value={SpringAware.class})
public class LiteflowMainAutoConfiguration {
    @Bean
    public ComponentScanner componentScanner(LiteflowConfig liteflowConfig, SpringAware springAware) {
        return new ComponentScanner(liteflowConfig);
    }

    @Bean
    public FlowExecutor flowExecutor(LiteflowConfig liteflowConfig, SpringAware springAware) {
        FlowExecutor flowExecutor = new FlowExecutor();
        flowExecutor.setLiteflowConfig(liteflowConfig);
        return flowExecutor;
    }

    @Bean
    @ConditionalOnProperty(prefix="liteflow", name={"parse-on-start"}, havingValue="true")
    public LiteflowExecutorInit liteflowExecutorInit(FlowExecutor flowExecutor) {
        return new LiteflowExecutorInit(flowExecutor);
    }

    @Bean(value={"monitorBus"})
    @ConditionalOnProperty(prefix="liteflow", name={"monitor.enable-log"}, havingValue="true")
    public MonitorBus monitorBus(LiteflowConfig liteflowConfig, SpringAware springAware) {
        return new MonitorBus(liteflowConfig);
    }
}

