/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.springboot.config;

import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.springboot.LiteflowMonitorProperty;
import com.yomahub.liteflow.springboot.LiteflowProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@EnableConfigurationProperties(value={LiteflowProperty.class, LiteflowMonitorProperty.class})
@PropertySource(name="Liteflow Default Properties", value={"classpath:/META-INF/liteflow-default.properties"})
public class LiteflowPropertyAutoConfiguration {
    @Bean
    public LiteflowConfig liteflowConfig(LiteflowProperty property, LiteflowMonitorProperty liteflowMonitorProperty) {
        LiteflowConfig liteflowConfig = new LiteflowConfig();
        liteflowConfig.setRuleSource(property.getRuleSource());
        liteflowConfig.setRuleSourceExtData(property.getRuleSourceExtData());
        liteflowConfig.setRuleSourceExtDataMap(property.getRuleSourceExtDataMap());
        liteflowConfig.setSlotSize(Integer.valueOf(property.getSlotSize()));
        liteflowConfig.setThreadExecutorClass(property.getThreadExecutorClass());
        liteflowConfig.setWhenMaxWaitSeconds(Integer.valueOf(property.getWhenMaxWaitSeconds()));
        liteflowConfig.setWhenMaxWaitTime(Integer.valueOf(property.getWhenMaxWaitTime()));
        liteflowConfig.setWhenMaxWaitTimeUnit(property.getWhenMaxWaitTimeUnit());
        liteflowConfig.setWhenMaxWorkers(Integer.valueOf(property.getWhenMaxWorkers()));
        liteflowConfig.setWhenQueueLimit(Integer.valueOf(property.getWhenQueueLimit()));
        liteflowConfig.setWhenThreadPoolIsolate(Boolean.valueOf(property.isWhenThreadPoolIsolate()));
        liteflowConfig.setParseMode(property.getParseMode());
        liteflowConfig.setEnable(Boolean.valueOf(property.isEnable()));
        liteflowConfig.setSupportMultipleType(Boolean.valueOf(property.isSupportMultipleType()));
        liteflowConfig.setRetryCount(Integer.valueOf(property.getRetryCount()));
        liteflowConfig.setPrintBanner(Boolean.valueOf(property.isPrintBanner()));
        liteflowConfig.setNodeExecutorClass(property.getNodeExecutorClass());
        liteflowConfig.setRequestIdGeneratorClass(property.getRequestIdGeneratorClass());
        liteflowConfig.setMainExecutorWorks(Integer.valueOf(property.getMainExecutorWorks()));
        liteflowConfig.setMainExecutorClass(property.getMainExecutorClass());
        liteflowConfig.setPrintExecutionLog(Boolean.valueOf(property.isPrintExecutionLog()));
        liteflowConfig.setEnableMonitorFile(Boolean.valueOf(property.isEnableMonitorFile()));
        liteflowConfig.setParallelMaxWorkers(Integer.valueOf(property.getParallelMaxWorkers()));
        liteflowConfig.setParallelQueueLimit(Integer.valueOf(property.getParallelQueueLimit()));
        liteflowConfig.setParallelLoopExecutorClass(property.getParallelLoopExecutorClass());
        liteflowConfig.setFallbackCmpEnable(Boolean.valueOf(property.isFallbackCmpEnable()));
        liteflowConfig.setFastLoad(Boolean.valueOf(property.isFastLoad()));
        liteflowConfig.setEnableLog(Boolean.valueOf(liteflowMonitorProperty.isEnableLog()));
        liteflowConfig.setQueueLimit(Integer.valueOf(liteflowMonitorProperty.getQueueLimit()));
        liteflowConfig.setDelay(Long.valueOf(liteflowMonitorProperty.getDelay()));
        liteflowConfig.setPeriod(Long.valueOf(liteflowMonitorProperty.getPeriod()));
        return liteflowConfig;
    }
}

