package com.yomahub.liteflow.springboot.config;

import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.util.ExecutorHelper;
import com.yomahub.liteflow.util.LiteFlowExecutorPoolShutdown;
import com.yomahub.liteflow.util.SpringAware;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import java.util.concurrent.ExecutorService;

/**
 * 线程池装配类
 * 这个装配前置条件是需要LiteflowConfig，LiteflowPropertyAutoConfiguration以及SpringAware
 * @author justin.xu
 */
@Configuration
@AutoConfigureAfter({LiteflowPropertyAutoConfiguration.class})
@ConditionalOnProperty(prefix = "liteflow", name = "enable", havingValue = "true")
@ConditionalOnBean(LiteflowConfig.class)
@Import(SpringAware.class)
public class LiteflowExecutorAutoConfiguration {

    @Bean("whenExecutors")
    public ExecutorService executorService(LiteflowConfig liteflowConfig) {
        return ExecutorHelper.loadInstance().buildExecutor();
    }

    @Bean
    public LiteFlowExecutorPoolShutdown liteFlowExecutorPoolShutdown() {
        return new LiteFlowExecutorPoolShutdown();
    }
}
