/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.springboot.config;

import com.yomahub.liteflow.property.LiteflowConfig;
import com.yomahub.liteflow.springboot.LiteflowMonitorProperty;
import com.yomahub.liteflow.springboot.LiteflowProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@EnableConfigurationProperties(value={LiteflowProperty.class, LiteflowMonitorProperty.class})
@PropertySource(name="Liteflow Default Properties", value={"classpath:/META-INF/liteflow-default.properties"})
public class LiteflowPropertyAutoConfiguration {
    @Bean
    public LiteflowConfig liteflowConfig(LiteflowProperty property, LiteflowMonitorProperty liteflowMonitorProperty) {
        LiteflowConfig liteflowConfig = new LiteflowConfig();
        liteflowConfig.setRuleSource(property.getRuleSource());
        liteflowConfig.setSlotSize(Integer.valueOf(property.getSlotSize()));
        liteflowConfig.setWhenMaxWaitSeconds(Integer.valueOf(property.getWhenMaxWaitSeconds()));
        liteflowConfig.setEnableLog(Boolean.valueOf(liteflowMonitorProperty.isEnableLog()));
        liteflowConfig.setQueueLimit(Integer.valueOf(liteflowMonitorProperty.getQueueLimit()));
        liteflowConfig.setDelay(Long.valueOf(liteflowMonitorProperty.getDelay()));
        liteflowConfig.setPeriod(Long.valueOf(liteflowMonitorProperty.getPeriod()));
        liteflowConfig.setWhenMaxWorkers(Integer.valueOf(property.getWhenMaxWorkers()));
        liteflowConfig.setWhenQueueLimit(Integer.valueOf(property.getWhenQueueLimit()));
        liteflowConfig.setParseOnStart(Boolean.valueOf(property.isParseOnStart()));
        liteflowConfig.setEnable(Boolean.valueOf(property.isEnable()));
        liteflowConfig.setSupportMultipleType(Boolean.valueOf(property.isSupportMultipleType()));
        liteflowConfig.setRetryCount(property.getRetryCount());
        liteflowConfig.setZkNode(property.getZkNode());
        liteflowConfig.setPrintBanner(Boolean.valueOf(property.isPrintBanner()));
        return liteflowConfig;
    }
}

