/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.forest;

import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.interceptor.Interceptor;
import com.yomahub.tlog.context.SpanIdGenerator;
import com.yomahub.tlog.context.TLogContext;
import com.yomahub.tlog.spring.TLogSpringAware;
import com.yomahub.tlog.utils.LocalhostUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLogForestInterceptor
implements Interceptor<Object> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public boolean beforeExecute(ForestRequest request) {
        String traceId = TLogContext.getTraceId();
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            String appName = TLogSpringAware.getProperty((String)"spring.application.name");
            request.addHeader("tlogTraceId", (Object)traceId);
            request.addHeader("tlogSpanId", (Object)SpanIdGenerator.generateNextSpanId());
            request.addHeader("preIvkApp", (Object)appName);
            request.addHeader("preIvkHost", (Object)LocalhostUtil.getHostName());
            request.addHeader("preIp", (Object)LocalhostUtil.getHostIp());
        } else {
            this.log.debug("[TLOG]\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
        }
        return true;
    }
}

