/*
 * Decompiled with CFR 0.152.
 */
package com.yqjr.base.technicalclient.filenet.impl;

import com.filenet.api.collection.AccessPermissionList;
import com.filenet.api.collection.ContentElementList;
import com.filenet.api.collection.EngineCollection;
import com.filenet.api.collection.RepositoryRowSet;
import com.filenet.api.constants.AutoClassify;
import com.filenet.api.constants.AutoUniqueName;
import com.filenet.api.constants.CheckinType;
import com.filenet.api.constants.ComponentRelationshipType;
import com.filenet.api.constants.CompoundDocumentState;
import com.filenet.api.constants.DefineSecurityParentage;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.constants.ReservationType;
import com.filenet.api.constants.VersionBindType;
import com.filenet.api.core.ComponentRelationship;
import com.filenet.api.core.Containable;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.CustomObject;
import com.filenet.api.core.Document;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.ReferentialContainmentRelationship;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.filenet.api.query.RepositoryRow;
import com.filenet.api.query.SearchSQL;
import com.filenet.api.query.SearchScope;
import com.filenet.api.security.AccessPermission;
import com.filenet.api.util.Id;
import com.yqjr.base.technicalclient.filenet.impl.CEConnection;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEHelper {
    private String user;
    private String pass;
    private String stanza;
    private String uri;
    private String filenetos;
    private String folderpath;

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public String getStanza() {
        return this.stanza;
    }

    public void setStanza(String stanza) {
        this.stanza = stanza;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getFilenetos() {
        return this.filenetos;
    }

    public void setFilenetos(String filenetos) {
        this.filenetos = filenetos;
    }

    public String getFolderpath() {
        return this.folderpath;
    }

    public void setFolderpath(String folderpath) {
        this.folderpath = folderpath;
    }

    public static void writeDocContentToFile(Document doc, String path) {
        String fileName = doc.get_Name();
        File f = new File(path, fileName);
        InputStream is = doc.accessContentStream(0);
        int c = 0;
        try {
            FileOutputStream out = new FileOutputStream(f);
            c = is.read();
            while (c != -1) {
                out.write(c);
                c = is.read();
            }
            is.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static byte[] readDocContentFromFile(File f) {
        byte[] b = null;
        int fileLength = (int)f.length();
        if (fileLength != 0) {
            try {
                FileInputStream is = new FileInputStream(f);
                b = new byte[fileLength];
                is.read(b);
                is.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return b;
    }

    public static ContentTransfer createContentTransfer(File f) {
        ContentTransfer ctNew = null;
        if (CEHelper.readDocContentFromFile(f) != null) {
            ctNew = Factory.ContentTransfer.createInstance();
            ByteArrayInputStream is = new ByteArrayInputStream(CEHelper.readDocContentFromFile(f));
            ctNew.setCaptureSource((InputStream)is);
            ctNew.set_RetrievalName(f.getName());
        }
        return ctNew;
    }

    public static ContentElementList createContentElements(File f) {
        ContentElementList cel = null;
        if (CEHelper.createContentTransfer(f) != null) {
            cel = Factory.ContentElement.createList();
            ContentTransfer ctNew = CEHelper.createContentTransfer(f);
            cel.add((Object)ctNew);
        }
        return cel;
    }

    public static Document createDocWithContent(File f, String mimeType, ObjectStore os, String docName, String docClass) {
        Document doc = null;
        doc = docClass.equals("") ? Factory.Document.createInstance((ObjectStore)os, null) : Factory.Document.createInstance((ObjectStore)os, (String)docClass);
        doc.getProperties().putValue("DocumentTitle", docName);
        doc.set_MimeType(mimeType);
        ContentElementList cel = CEHelper.createContentElements(f);
        if (cel != null) {
            doc.set_ContentElements(cel);
        }
        return doc;
    }

    public static Document createDocWithContentAndBizzInfo(File f, String mimeType, ObjectStore os, String docName, Map<String, Object> ... objectValues) throws Exception {
        Document doc = null;
        if (objectValues == null || objectValues.length == 0) {
            doc = Factory.Document.createInstance((ObjectStore)os, null);
        } else {
            String classKey = "className";
            String docClass = (String)objectValues[0].get(classKey);
            doc = Factory.Document.createInstance((ObjectStore)os, (String)docClass);
            for (String key : objectValues[0].keySet()) {
                Object o = objectValues[0].get(key);
                if (o.equals(classKey)) continue;
                if (o instanceof Integer) {
                    doc.getProperties().putValue(key, (Integer)o);
                    continue;
                }
                if (o instanceof Long) {
                    doc.getProperties().putValue(key, (double)((Long)o).longValue());
                    continue;
                }
                if (o instanceof String) {
                    doc.getProperties().putValue(key, (String)o);
                    continue;
                }
                if (o instanceof Date) {
                    doc.getProperties().putValue(key, (Date)o);
                    continue;
                }
                if (o instanceof Double) {
                    doc.getProperties().putValue(key, (Double)o);
                    continue;
                }
                throw new Exception("filenet class not support data type!");
            }
        }
        doc.getProperties().putValue("DocumentTitle", docName);
        ContentElementList cel = CEHelper.createContentElements(f);
        if (cel != null) {
            doc.set_ContentElements(cel);
        }
        return doc;
    }

    public static Document createDocNoContent(String mimeType, ObjectStore os, String docName, String docClass) {
        Document doc = null;
        doc = docClass.equals("") ? Factory.Document.createInstance((ObjectStore)os, null) : Factory.Document.createInstance((ObjectStore)os, (String)docClass);
        doc.getProperties().putValue("DocumentTitle", docName);
        doc.set_MimeType(mimeType);
        return doc;
    }

    public static Document fetchDocByPath(ObjectStore os, String path) {
        Document doc = Factory.Document.fetchInstance((ObjectStore)os, (String)path, null);
        return doc;
    }

    public static Document fetchDocById(ObjectStore os, String id) {
        Id id1 = new Id(id);
        Document doc = Factory.Document.fetchInstance((ObjectStore)os, (Id)id1, null);
        return doc;
    }

    public static void checkinDoc(Document doc) {
        doc.checkin(AutoClassify.AUTO_CLASSIFY, CheckinType.MAJOR_VERSION);
        doc.save(RefreshMode.REFRESH);
        doc.refresh();
    }

    public static CustomObject createCustomObject(ObjectStore os, String className) {
        CustomObject co = null;
        co = className.equals("") ? Factory.CustomObject.createInstance((ObjectStore)os, null) : Factory.CustomObject.createInstance((ObjectStore)os, (String)className);
        return co;
    }

    public static CustomObject fetchCustomObjectByPath(ObjectStore os, String path) {
        CustomObject doc = Factory.CustomObject.fetchInstance((ObjectStore)os, (String)path, null);
        return doc;
    }

    public static CustomObject fetchCustomObjectById(ObjectStore os, String id) {
        Id id1 = new Id(id);
        CustomObject doc = Factory.CustomObject.fetchInstance((ObjectStore)os, (Id)id1, null);
        return doc;
    }

    public static ReferentialContainmentRelationship fileObject(ObjectStore os, Containable o, String folderPath) {
        Folder fo = Factory.Folder.fetchInstance((ObjectStore)os, (String)folderPath, null);
        ReferentialContainmentRelationship rcr = o instanceof Document ? fo.file((IndependentlyPersistableObject)((Document)o), AutoUniqueName.AUTO_UNIQUE, ((Document)o).get_Name(), DefineSecurityParentage.DO_NOT_DEFINE_SECURITY_PARENTAGE) : fo.file((IndependentlyPersistableObject)((CustomObject)o), AutoUniqueName.AUTO_UNIQUE, ((CustomObject)o).get_Name(), DefineSecurityParentage.DO_NOT_DEFINE_SECURITY_PARENTAGE);
        return rcr;
    }

    public static HashMap<String, Object> getContainableObjectProperties(Containable o) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("Id", o.get_Id().toString());
        hm.put("Name", o.get_Name());
        hm.put("Creator", o.get_Creator());
        hm.put("Owner", o.get_Owner());
        hm.put("Date Created", o.get_DateCreated().toString());
        hm.put("Date Last Modified", o.get_DateLastModified().toString());
        return hm;
    }

    public static void createFolder(ObjectStore os, String fPath, String fName, String className) {
        Folder f = Factory.Folder.fetchInstance((ObjectStore)os, (String)fPath, null);
        Folder nf = null;
        nf = className.equals("") ? Factory.Folder.createInstance((ObjectStore)os, null) : Factory.Folder.createInstance((ObjectStore)os, (String)className);
        nf.set_Parent(f);
        nf.set_FolderName(fName);
        nf.save(RefreshMode.REFRESH);
    }

    public static ComponentRelationship createComponentRelationship(ObjectStore os, String pTitle, String cTitle) {
        ComponentRelationship cr = null;
        Document parentDoc = null;
        Document childDoc = null;
        parentDoc = Factory.Document.createInstance((ObjectStore)os, null);
        parentDoc.getProperties().putValue("DocumentTitle", pTitle);
        parentDoc.set_CompoundDocumentState(CompoundDocumentState.COMPOUND_DOCUMENT);
        parentDoc.save(RefreshMode.REFRESH);
        parentDoc.checkin(AutoClassify.AUTO_CLASSIFY, CheckinType.MINOR_VERSION);
        parentDoc.save(RefreshMode.REFRESH);
        childDoc = Factory.Document.createInstance((ObjectStore)os, null);
        childDoc.getProperties().putValue("DocumentTitle", cTitle);
        childDoc.set_CompoundDocumentState(CompoundDocumentState.COMPOUND_DOCUMENT);
        childDoc.save(RefreshMode.REFRESH);
        childDoc.checkin(AutoClassify.AUTO_CLASSIFY, CheckinType.MINOR_VERSION);
        childDoc.save(RefreshMode.REFRESH);
        cr = Factory.ComponentRelationship.createInstance((ObjectStore)os, null);
        cr.set_ParentComponent(parentDoc);
        cr.set_ChildComponent(childDoc);
        cr.set_ComponentRelationshipType(ComponentRelationshipType.DYNAMIC_CR);
        cr.set_VersionBindType(VersionBindType.LATEST_VERSION);
        return cr;
    }

    public static ComponentRelationship fetchComponentRelationship(ObjectStore os, String id) {
        Id id1 = new Id(id);
        ComponentRelationship cr = Factory.ComponentRelationship.fetchInstance((ObjectStore)os, (Id)id1, null);
        return cr;
    }

    public static HashMap<String, Object> getComponentRelationshipObjectProperties(ComponentRelationship o) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("Id", o.get_Id().toString());
        hm.put("Creator", o.get_Creator());
        hm.put("Date Created", o.get_DateCreated().toString());
        hm.put("Date Last Modified", o.get_DateLastModified().toString());
        hm.put("Child Component", o.get_ChildComponent().get_Name());
        hm.put("Parent Component", o.get_ParentComponent().get_Name());
        return hm;
    }

    public static RepositoryRowSet fetchResultsRowSet(ObjectStore os, String select, String from, String where, int rows) {
        RepositoryRowSet rrs = null;
        SearchSQL q = new SearchSQL();
        SearchScope ss = new SearchScope(os);
        q.setSelectList(select);
        q.setFromClauseInitialValue(from, null, false);
        if (!where.equals("")) {
            q.setWhereClause(where);
        }
        if (rows != 0) {
            q.setMaxRecords(rows);
        }
        rrs = ss.fetchRows(q, null, null, null);
        return rrs;
    }

    public static Vector<String> getResultProperties(RepositoryRow rr) {
        Vector<String> column = new Vector<String>();
        Properties ps = rr.getProperties();
        for (Property pt : ps) {
            String name = pt.getPropertyName();
            column.add(name);
        }
        return column;
    }

    public static Vector<String> getResultRow(RepositoryRow rr) {
        Vector<String> row = new Vector<String>();
        Properties ps = rr.getProperties();
        for (Property pt : ps) {
            Object value = pt.getObjectValue();
            if (value == null) {
                row.add("null");
                continue;
            }
            if (value instanceof EngineCollection) {
                row.add("*");
                continue;
            }
            row.add(value.toString());
        }
        return row;
    }

    public static Vector<String> getPermissions(Containable co) {
        Vector<String> permissions = new Vector<String>();
        AccessPermissionList apl = co.get_Permissions();
        for (AccessPermission ap : apl) {
            permissions.add("GRANTEE_NAME: " + ap.get_GranteeName());
            permissions.add("ACCESS_MASK: " + ap.get_AccessMask().toString());
            permissions.add("ACCESS_TYPE: " + ap.get_AccessType().toString());
        }
        return permissions;
    }

    public CEConnection getCEConnection() {
        CEConnection ce = new CEConnection();
        ce.establishConnection(this.user, this.pass, this.stanza, this.uri);
        return ce;
    }

    public static void main(String[] args) {
        CEConnection ce = new CEConnection();
        ce.establishConnection("administrator", "Passw0rd", "FileNetP8WSI", "http://10.21.111.32:9080/wsi/FNCEWS40MTOM/");
        String x = "4411010010192129,75368744-1,'\u4e1c\u839e\u5e02\u5929\u4e0b\u884c\u4e30\u7530\u6c7d\u8f66\u9500\u552e\u670d\u52a1\u6709\u9650\u516c\u53f8',13,30540505.32,14293032.39,13,,,,,,,,,,,,,,,,,,,,,,,,,1,25000000.00,25000000.00,,,,,,,,,24106520006,2011-12-27";
        System.out.println(x.split(",").length);
    }

    public Document saveAFBizzDocument(File f, String mimeType, String folderpath, String fileName, Map<String, Object> ... classInfo) throws Exception {
        Document doc = null;
        ObjectStore os = this.getCEConnection().fetchOS(this.filenetos);
        if (this.getDocumentByPath(os, folderpath) == null) {
            CEHelper.createFolder(os, folderpath.substring(0, folderpath.lastIndexOf("\\")), folderpath.substring(folderpath.lastIndexOf("\\") + 1), "");
        }
        if ((doc = CEHelper.getDocument(os, folderpath + "\\" + fileName)) == null) {
            doc = null;
            doc = CEHelper.createDocWithContentAndBizzInfo(f, mimeType, os, fileName, classInfo);
            doc.save(RefreshMode.REFRESH);
            ReferentialContainmentRelationship rcr = CEHelper.fileObject(os, (Containable)doc, folderpath);
            rcr.save(RefreshMode.REFRESH);
            CEHelper.checkinDoc(doc);
        } else {
            doc.checkout(ReservationType.EXCLUSIVE, null, null, null);
            doc.save(RefreshMode.NO_REFRESH);
            Document reservation = (Document)doc.get_Reservation();
            ContentElementList cel = CEHelper.createContentElements(f);
            if (cel != null) {
                reservation.set_ContentElements(cel);
            }
            reservation.checkin(AutoClassify.DO_NOT_AUTO_CLASSIFY, CheckinType.MAJOR_VERSION);
            reservation.save(RefreshMode.REFRESH);
            doc.checkin(AutoClassify.DO_NOT_AUTO_CLASSIFY, CheckinType.MAJOR_VERSION);
        }
        return doc;
    }

    private static Document getDocument(ObjectStore os, String path) {
        Document doc = null;
        try {
            doc = Factory.Document.fetchInstance((ObjectStore)os, (String)path, null);
        }
        catch (EngineRuntimeException ex) {
            if (ex.getMessage().startsWith("The requested item was not found") || ex.getMessage().startsWith("Requested item not found") || ex.getMessage().indexOf("\u627e\u4e0d\u5230\u6240\u8bf7\u6c42\u9879") >= 0) {
                doc = null;
            }
            throw ex;
        }
        return doc;
    }

    public Document getDocumentByPath(String fullPath) {
        Document doc = null;
        ObjectStore os = this.getCEConnection().fetchOS(this.filenetos);
        try {
            doc = Factory.Document.fetchInstance((ObjectStore)os, (String)fullPath, null);
        }
        catch (EngineRuntimeException ex) {
            if (ex.getMessage().startsWith("The requested item was not found") || ex.getMessage().startsWith("Requested item not found") || ex.getMessage().indexOf("\u627e\u4e0d\u5230\u6240\u8bf7\u6c42\u9879") >= 0) {
                doc = null;
            }
            throw ex;
        }
        return doc;
    }

    private Folder getDocumentByPath(ObjectStore os, String fullPath) {
        Folder folder = null;
        try {
            folder = Factory.Folder.fetchInstance((ObjectStore)os, (String)fullPath, null);
        }
        catch (EngineRuntimeException ex) {
            if (ex.getMessage().startsWith("The requested item was not found") || ex.getMessage().startsWith("Requested item not found") || ex.getMessage().indexOf("\u627e\u4e0d\u5230\u6240\u8bf7\u6c42\u9879") >= 0) {
                folder = null;
            }
            throw ex;
        }
        return folder;
    }

    public boolean deleteDocumentByPath(String fullPath) {
        Document doc = null;
        ObjectStore os = this.getCEConnection().fetchOS(this.filenetos);
        doc = CEHelper.getDocument(os, fullPath);
        if (doc == null) {
            return false;
        }
        doc.delete();
        doc.save(RefreshMode.NO_REFRESH);
        return true;
    }
}

