/*
 * Decompiled with CFR 0.152.
 */
package com.yqjr.base.technicalclient.mail;

import com.yqjr.base.technicalclient.mail.TooManyAttachmentsException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class MailClient {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private JavaMailSender javaMailSender;
    private String addrSplitChar;
    private String defaultSignature;
    private String defalutSender;
    private int attachmentsLimit;

    public int getAttachmentsLimit() {
        return this.attachmentsLimit;
    }

    public void setAttachmentsLimit(int attachmentsLimit) {
        this.attachmentsLimit = attachmentsLimit;
    }

    public String getAddrSplitChar() {
        return this.addrSplitChar;
    }

    public void setAddrSplitChar(String addrSplitChar) {
        this.addrSplitChar = addrSplitChar;
    }

    public String getDefaultSignature() {
        return this.defaultSignature;
    }

    public void setDefaultSignature(String defaultSignature) {
        this.defaultSignature = defaultSignature;
    }

    public JavaMailSender getJavaMailSender() {
        return this.javaMailSender;
    }

    public void setJavaMailSender(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    public String getDefalutSender() {
        return this.defalutSender;
    }

    public void setDefalutSender(String defalutSender) {
        this.defalutSender = defalutSender;
    }

    public int sendMail(String[] to, String[] cc, String mailSubject, String mailBody, String signature, File ... attachmentFiles) throws UnsupportedEncodingException, MessagingException, TooManyAttachmentsException {
        InternetAddress[] ito = this.convertToAddress(to);
        InternetAddress[] icc = this.convertToAddress(cc);
        return this.doSendMail(ito, icc, mailSubject, mailBody, signature, attachmentFiles);
    }

    public int sendMail(String[] to, String[] cc, String mailSubject, String mailBody, File ... attachmentFiles) throws UnsupportedEncodingException, MessagingException, TooManyAttachmentsException {
        return this.sendMail(to, cc, mailSubject, mailBody, this.defaultSignature, attachmentFiles);
    }

    public int sendMail(String to, String[] cc, String mailSubject, String mailBody, File ... attachmentFiles) throws UnsupportedEncodingException, MessagingException, TooManyAttachmentsException {
        String[] tos = new String[]{to};
        return this.sendMail(tos, cc, mailSubject, mailBody, this.defaultSignature, attachmentFiles);
    }

    public int sendMail(String to, String mailSubject, String mailBody, File ... attachmentFiles) throws UnsupportedEncodingException, MessagingException, TooManyAttachmentsException {
        String[] tos = new String[]{to};
        return this.sendMail(tos, null, mailSubject, mailBody, this.defaultSignature, attachmentFiles);
    }

    private InternetAddress[] convertToAddress(String[] text) throws AddressException, UnsupportedEncodingException {
        ArrayList<InternetAddress> list = new ArrayList<InternetAddress>();
        if (text != null) {
            int length = text.length;
            for (int i = 0; i < length; ++i) {
                String[] address = text[i].split(this.addrSplitChar);
                if (address.length > 1) {
                    String toName = address[0];
                    String toAddress = address[1];
                    InternetAddress addr = new InternetAddress("\"" + MimeUtility.encodeText((String)toName) + "\" <" + toAddress + ">");
                    list.add(addr);
                    continue;
                }
                if (address.length != 1) continue;
                InternetAddress addr = new InternetAddress(address[0]);
                list.add(addr);
            }
        }
        InternetAddress[] a = new InternetAddress[]{};
        list.toArray(a);
        return list.toArray(a);
    }

    private int doSendMail(InternetAddress[] to, InternetAddress[] cc, String mailSubject, String mailBody, String signature, File ... attachmentFiles) throws MessagingException, TooManyAttachmentsException, UnsupportedEncodingException {
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
        String from = this.defalutSender;
        helper.setFrom(from);
        helper.setTo(to);
        helper.setSentDate(new Date());
        helper.setReplyTo(new InternetAddress(from));
        if (cc != null && cc.length > 0) {
            helper.setCc(cc);
        }
        helper.setSubject(mailSubject);
        if (signature != null) {
            mailBody = mailBody + signature;
        }
        helper.setText(mailBody, true);
        if (attachmentFiles != null && attachmentFiles.length > 0) {
            if (attachmentFiles.length > this.attachmentsLimit) {
                throw new TooManyAttachmentsException();
            }
            for (int i = 0; i < attachmentFiles.length; ++i) {
                helper.addAttachment(MimeUtility.encodeText((String)attachmentFiles[i].getName()), attachmentFiles[i]);
            }
        }
        this.javaMailSender.send(mimeMessage);
        this.logger.info("Sent a Mail Reslut: [{}] ", (Object)mailSubject);
        return 1;
    }
}

