/*
 * Decompiled with CFR 0.152.
 */
package com.yqjr.base.technicalclient.memcached;

import com.yqjr.base.technicalclient.memcached.MemCache;
import net.rubyeye.xmemcached.MemcachedClient;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

public class MemcachedCache
implements Cache {
    private final String name;
    private final MemcachedClient memcachedClient;
    private final MemCache memCache;

    public MemcachedCache(String name, int expire, MemcachedClient memcachedClient) {
        this.name = name;
        this.memcachedClient = memcachedClient;
        this.memCache = new MemCache(name, expire, memcachedClient);
    }

    public void clear() {
        this.memCache.clear();
    }

    public void evict(Object key) {
        this.memCache.delete(key.toString());
    }

    public Cache.ValueWrapper get(Object key) {
        SimpleValueWrapper wrapper = null;
        Object value = this.memCache.get(key.toString());
        if (value != null) {
            wrapper = new SimpleValueWrapper(value);
        }
        return wrapper;
    }

    public String getName() {
        return this.name;
    }

    public MemcachedClient getNativeCache() {
        return this.memcachedClient;
    }

    public void put(Object key, Object value) {
        this.memCache.put(key.toString(), value);
    }
}

