/*
 * Decompiled with CFR 0.152.
 */
package com.yqjr.base.technicalservice.http;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;

public class HttpClientPool {
    private static final int CONNECTION_TIMEOUT = 800000;
    private static final int SO_TIMEOUT = 3000000;
    private static final int CONN_MANAGER_TIMEOUT = 1000;
    private static final boolean STALE_CONNECTION_CHECK = true;
    private static final int MAX_POOL_SIZE = 80;
    private static final int MAX_ROUTE_SIZE = 30;
    private int connectionTimeOut;
    private int soTimeOut;
    private int connManagerTimeOut;
    private boolean staleConnectionCheck;
    private int maxPoolSize;
    private int maxRouteSize;
    private HttpParams httpParams;
    private PoolingClientConnectionManager pccm;
    private SchemeRegistry schemeRegistry;
    private SSLContext sslContext;
    private SSLSocketFactory sslSocketFactory;
    private X509TrustManager x509TrustManager;

    public HttpClientPool() {
        this.setHttpParams();
        this.setPoolingClientConnectionManager();
    }

    private void setHttpParams() {
        this.httpParams = new BasicHttpParams();
        if (this.connectionTimeOut == 0) {
            this.httpParams.setIntParameter("http.connection.timeout", 800000);
        } else {
            this.httpParams.setIntParameter("http.connection.timeout", this.connectionTimeOut);
        }
        if (this.soTimeOut == 0) {
            this.httpParams.setIntParameter("http.socket.timeout", 3000000);
        } else {
            this.httpParams.setIntParameter("http.socket.timeout", this.soTimeOut);
        }
        if (this.connManagerTimeOut == 0) {
            this.httpParams.setIntParameter("http.connection.timeout", 1000);
        } else {
            this.httpParams.setIntParameter("http.connection.timeout", this.connManagerTimeOut);
        }
        if (!this.staleConnectionCheck) {
            this.httpParams.setBooleanParameter("http.connection.stalecheck", true);
        } else {
            this.httpParams.setBooleanParameter("http.connection.stalecheck", this.staleConnectionCheck);
        }
        HttpProtocolParams.setVersion((HttpParams)this.httpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
    }

    private void setPoolingClientConnectionManager() {
        this.schemeRegistry = this.getSchemeRegistry();
        this.pccm = new PoolingClientConnectionManager(this.schemeRegistry, -1L, TimeUnit.MINUTES, (DnsResolver)new SystemDefaultDnsResolver());
        if (this.maxPoolSize == 0) {
            this.pccm.setMaxTotal(80);
        } else {
            this.pccm.setMaxTotal(this.maxPoolSize);
        }
        if (this.maxRouteSize == 0) {
            this.pccm.setDefaultMaxPerRoute(30);
        } else {
            this.pccm.setDefaultMaxPerRoute(this.maxRouteSize);
        }
    }

    public SSLSocketFactory getSSLSocketFactory() {
        try {
            this.x509TrustManager = this.getX509TrustManager();
            this.sslContext = SSLContext.getInstance("SSL");
            this.sslContext.init(null, new TrustManager[]{this.x509TrustManager}, null);
            this.sslSocketFactory = new SSLSocketFactory(this.sslContext);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return this.sslSocketFactory;
    }

    private X509TrustManager getX509TrustManager() {
        this.x509TrustManager = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }
        };
        return this.x509TrustManager;
    }

    private SchemeRegistry getSchemeRegistry() {
        this.sslSocketFactory = this.getSSLSocketFactory();
        SchemeRegistry sr = new SchemeRegistry();
        sr.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        sr.register(new Scheme("https", 443, (SchemeSocketFactory)this.sslSocketFactory));
        return sr;
    }

    public HttpClient getHttpClient() {
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)this.pccm, this.httpParams);
        return httpClient;
    }

    public void releaseHttpClient(HttpResponse httpResponse) {
        if (httpResponse != null) {
            try {
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void shutdown() {
        this.pccm.shutdown();
    }

    public int getConnectionTimeOut() {
        return this.connectionTimeOut;
    }

    public int getSoTimeOut() {
        return this.soTimeOut;
    }

    public int getConnManagerTimeOut() {
        return this.connManagerTimeOut;
    }

    public boolean isStaleConnectionCheck() {
        return this.staleConnectionCheck;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getMaxRouteSize() {
        return this.maxRouteSize;
    }

    public void setConnectionTimeOut(int connectionTimeOut) {
        this.connectionTimeOut = connectionTimeOut;
    }

    public void setSoTimeOut(int soTimeOut) {
        this.soTimeOut = soTimeOut;
    }

    public void setConnManagerTimeOut(int connManagerTimeOut) {
        this.connManagerTimeOut = connManagerTimeOut;
    }

    public void setStaleConnectionCheck(boolean staleConnectionCheck) {
        this.staleConnectionCheck = staleConnectionCheck;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setMaxRouteSize(int maxRouteSize) {
        this.maxRouteSize = maxRouteSize;
    }
}

