/*
 * Decompiled with CFR 0.152.
 */
package com.yqjr.base.technicalservice.http;

import com.yqjr.base.technicalservice.http.HttpClientPool;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    public static HttpClient getHttpClient(HttpClientPool httpClientPool) {
        return httpClientPool.getHttpClient();
    }

    public void releaseHttpClient(HttpClientPool httpClientPool, HttpResponse httpResponse) {
        httpClientPool.releaseHttpClient(httpResponse);
    }

    public static HttpPost getHttpPost() {
        return new HttpPost();
    }

    public static HttpPost getHttpPost(String url) {
        return new HttpPost(url);
    }

    public static HttpGet getHttpGet() {
        return new HttpGet();
    }

    public static HttpGet getHttpGet(String url) {
        return new HttpGet(url);
    }

    public static URI getURI(String str) {
        URI uri = null;
        try {
            uri = new URI(str);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return uri;
    }

    public static void setHttpHead(HttpRequestBase httpRequestBase, Map<String, String> httpHeadParams) {
        for (Map.Entry<String, String> entry : httpHeadParams.entrySet()) {
            httpRequestBase.addHeader(entry.getKey(), entry.getValue());
        }
    }

    public static void setHttpPostParams(HttpPost httpPost, Map<String, String> params, String encode) {
        UrlEncodedFormEntity httpEntity = null;
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        try {
            httpEntity = new UrlEncodedFormEntity(list, encode);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        httpPost.setEntity((HttpEntity)httpEntity);
    }

    public static void setHttpPostString(HttpPost httpPost, String str, String encode) {
        StringEntity stringEntity = null;
        try {
            stringEntity = new StringEntity(str, encode);
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static HttpResponse getHttpResponse(HttpClient httpClient, HttpRequestBase httpRequestBase) {
        HttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpRequestBase);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return httpResponse;
    }

    public static String getHttpBody(HttpEntity httpEntity) {
        String httpBody = null;
        try {
            httpBody = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return httpBody;
    }

    public static HttpResponse post(HttpClientPool httpClientPool, String url, Map<String, String> params, String charset) throws ClientProtocolException, IOException {
        HttpClient httpclient = HttpClientUtil.getHttpClient(httpClientPool);
        HttpPost httpPost = HttpClientUtil.buildHttpPost(url, params, charset);
        return httpclient.execute((HttpUriRequest)httpPost);
    }

    public static HttpResponse post(HttpClientPool httpClientPool, String url, Map<String, Object> params, Map<String, File> paramsFile, String charset) throws ClientProtocolException, IOException {
        HttpClient httpclient = HttpClientUtil.getHttpClient(httpClientPool);
        HttpPost httpPost = HttpClientUtil.buildHttpPostMime(url, params, paramsFile, charset);
        return httpclient.execute((HttpUriRequest)httpPost);
    }

    private static HttpPost buildHttpPost(String url, Map<String, String> params, String charset) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=" + charset);
        if (params == null || params.isEmpty()) {
            return httpPost;
        }
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        String value = "";
        for (String key : params.keySet()) {
            value = params.get(key) == null ? "" : params.get(key);
            nvps.add(new BasicNameValuePair(key, value));
        }
        if (charset != null) {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, charset));
        } else {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
        }
        return httpPost;
    }

    private static HttpPost buildHttpPostMime(String url, Map<String, Object> params, Map<String, File> paramsFile, String charset) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(url);
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        if (null != params) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                entity.addPart(entry.getKey(), (ContentBody)new StringBody(null == entry.getValue() ? "" : entry.getValue().toString(), Charset.forName(charset)));
            }
        }
        if (null != paramsFile) {
            for (Map.Entry<String, Object> entry : paramsFile.entrySet()) {
                entity.addPart(entry.getKey(), (ContentBody)new FileBody((File)entry.getValue()));
            }
        }
        httpPost.setEntity((HttpEntity)entity);
        return httpPost;
    }
}

