/*
 * Decompiled with CFR 0.152.
 */
package com.yqjr.base.technicalservice.invokclient;

import com.yqjr.base.technicalservice.base.BasRequestMsg;
import com.yqjr.base.technicalservice.base.InterfaceContent;
import com.yqjr.base.technicalservice.exception.RequestServiceFailureException;
import com.yqjr.base.technicalservice.exception.XmlReceiveException;
import com.yqjr.base.technicalservice.http.HttpClientPool;
import com.yqjr.base.technicalservice.http.HttpClientUtil;
import com.yqjr.base.technicalservice.log.InterfaceLogManager;
import com.yqjr.base.technicalservice.log.LogFactory;
import com.yqjr.base.technicalservice.util.BaseUtil;
import com.yqjr.base.technicalservice.util.EncUtil;
import com.yqjr.base.technicalservice.util.MacUtil;
import com.yqjr.base.technicalservice.util.XMLUtil;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class InterfaceRequest {
    private String encKey;
    private String macKey;
    private String url;
    private Class<?> cls;

    public InterfaceRequest(String url, Class<?> cls, String encKey, String macKey) {
        this.encKey = encKey;
        this.macKey = macKey;
        this.url = url;
        this.cls = cls;
    }

    public String getEncKey() {
        return this.encKey;
    }

    public void setEncKey(String encKey) {
        this.encKey = encKey;
    }

    public String getMacKey() {
        return this.macKey;
    }

    public void setMacKey(String macKey) {
        this.macKey = macKey;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public InterfaceContent genaralXMLInterfaceContent(String targetCode, BasRequestMsg msg, Map<String, String> files) throws UnsupportedEncodingException, Exception {
        msg.getMessageHeader().setTargetCode(targetCode);
        InterfaceContent content = new InterfaceContent();
        content.setMsgType("X");
        content.setTargetCode(targetCode);
        String xml = XMLUtil.beanToXml(msg);
        String xmlMac = MacUtil.encodeMac(xml, this.macKey);
        String encXml = null;
        if (this.encKey != null && this.encKey.length() > 0) {
            content.setEncFlag("1");
            encXml = EncUtil.getEncrypt(xml, this.encKey, "UTF-8");
        } else {
            content.setEncFlag("0");
            encXml = xml;
        }
        content.setMsgMac(xmlMac);
        content.setMsg(encXml);
        content.setBizzCode(msg.getMessageHeader().getInstructionCode());
        if (files != null && !files.isEmpty()) {
            content.setFiles(files);
        }
        return content;
    }

    public Object performService(String targetCode, BasRequestMsg msg, Map<String, String> files) throws Exception, XmlReceiveException, RequestServiceFailureException {
        InterfaceLogManager interfaceLogManager;
        InterfaceContent content = this.genaralXMLInterfaceContent(targetCode, msg, files);
        HttpClientPool httpClientPool = new HttpClientPool();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("msgType", content.getMsgType());
        params.put("targetCode", content.getTargetCode());
        params.put("encFlag", content.getEncFlag());
        params.put("msgMac", content.getMsgMac());
        params.put("msg", content.getMsg());
        params.put("bizzCode", content.getBizzCode());
        if (files != null) {
            for (String key : files.keySet()) {
                String fileValue = content.getFiles().get(key);
                params.put("yqjrFile" + key, fileValue);
            }
        }
        if ((interfaceLogManager = LogFactory.getLog()) != null) {
            interfaceLogManager.writeLog(this.url, content, "\u8bf7\u6c42", this.encKey);
        }
        HttpResponse httpResponse = HttpClientUtil.post(httpClientPool, this.url, params, null, "UTF-8");
        int state = httpResponse.getStatusLine().getStatusCode();
        HttpEntity httpEntity = httpResponse.getEntity();
        String httpBody = EntityUtils.toString((HttpEntity)httpEntity);
        new HttpClientUtil().releaseHttpClient(httpClientPool, httpResponse);
        if (200 == state) {
            String resultEncFlag = BaseUtil.getResponseDataByName(httpBody, "flag");
            String resultMsgMac = BaseUtil.getResponseDataByName(httpBody, "mac");
            String resultMsgXml = BaseUtil.getResponseDataByName(httpBody, "xml");
            if (interfaceLogManager != null) {
                content.setEncFlag(resultEncFlag);
                content.setMsg(resultMsgXml);
                interfaceLogManager.writeLog(this.url, content, "\u63a5\u6536", this.encKey);
            }
            if ("0".equals(resultEncFlag)) {
                return XMLUtil.toBean(resultMsgXml, this.cls, null);
            }
            String msgXml = EncUtil.getDecrypt(resultMsgXml, this.encKey, "UTF-8");
            if (resultMsgMac.equals(MacUtil.encodeMac(msgXml, this.macKey))) {
                return XMLUtil.toBean(msgXml, this.cls, null);
            }
            throw new XmlReceiveException();
        }
        throw new RequestServiceFailureException();
    }
}

