/*
 * Decompiled with CFR 0.152.
 */
package com.yqjr.base.technicalservice.log;

import com.yqjr.base.technicalservice.base.InterfaceContent;
import com.yqjr.base.technicalservice.log.InterfaceLogManager;
import com.yqjr.base.technicalservice.util.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLog
implements InterfaceLogManager {
    private String loggerName;
    private String contentType;

    public DefaultLog(String loggerName, String contentType) {
        this.loggerName = loggerName;
        this.contentType = contentType;
    }

    @Override
    public void writeLog(String url, InterfaceContent content, String direct, String encKey) {
        if ("" != this.loggerName) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            InterfaceContent resultContent = LogUtil.getLogContent(content, encKey, this.contentType);
            logger.info(LogUtil.wirteFormatLog(url, resultContent.getBizzCode(), resultContent.getTargetCode(), resultContent.getMsg(), direct));
        }
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

