/*
 * Decompiled with CFR 0.152.
 */
package com.yqjr.base.technicalservice.util;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class EncUtil {
    private static final String algorithm = "AES";

    private static String asHex(byte[] buf) {
        StringBuffer strbuf = new StringBuffer(buf.length * 2);
        for (int i = 0; i < buf.length; ++i) {
            if ((buf[i] & 0xFF) < 16) {
                strbuf.append("0");
            }
            strbuf.append(Long.toString(buf[i] & 0xFF, 16));
        }
        return strbuf.toString();
    }

    private static byte[] asBin(String src) {
        if (src.length() < 1) {
            return null;
        }
        byte[] encrypted = new byte[src.length() / 2];
        for (int i = 0; i < src.length() / 2; ++i) {
            int high = Integer.parseInt(src.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(src.substring(i * 2 + 1, i * 2 + 2), 16);
            encrypted[i] = (byte)(high * 16 + low);
        }
        return encrypted;
    }

    public static String getRawKey() {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(algorithm);
            kgen.init(128);
            SecretKey skey = kgen.generateKey();
            byte[] raw = skey.getEncoded();
            return EncUtil.asHex(raw).toUpperCase();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getEncrypt(String message, String rawKey, String charset) {
        byte[] key = EncUtil.asBin(rawKey);
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(key, algorithm);
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(1, skeySpec);
            byte[] encrypted = cipher.doFinal(message.getBytes(charset));
            return EncUtil.asHex(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getDecrypt(String encrypted, String rawKey, String charset) {
        byte[] tmp = EncUtil.asBin(encrypted);
        byte[] key = EncUtil.asBin(rawKey);
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(key, algorithm);
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(2, skeySpec);
            byte[] decrypted = cipher.doFinal(tmp);
            return new String(decrypted, charset);
        }
        catch (Exception e) {
            return "";
        }
    }
}

