/*
 * Decompiled with CFR 0.152.
 */
package com.yqjr.base.technicalservice.util;

import com.yqjr.base.technicalservice.util.HexUtil;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;

public class MacUtil {
    private static byte[] initHmacMD5Key() throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance("HmacMD5");
        SecretKey secretKey = generator.generateKey();
        byte[] key = secretKey.getEncoded();
        return key;
    }

    private static String encodeHmacMD5(byte[] data, byte[] key) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key, "HmacMD5");
        Mac mac = Mac.getInstance(secretKey.getAlgorithm());
        mac.init(secretKey);
        byte[] digest = mac.doFinal(data);
        return new HexBinaryAdapter().marshal(digest);
    }

    private static byte[] initHmacSHAKey() throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance("HmacSHA1");
        SecretKey secretKey = generator.generateKey();
        byte[] key = secretKey.getEncoded();
        return key;
    }

    private static String encodeHmacSHA(byte[] data, byte[] key) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key, "HmacSHA1");
        Mac mac = Mac.getInstance(secretKey.getAlgorithm());
        mac.init(secretKey);
        byte[] digest = mac.doFinal(data);
        return new HexBinaryAdapter().marshal(digest);
    }

    private static byte[] initHmacSHA256Key() throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance("HmacSHA256");
        SecretKey secretKey = generator.generateKey();
        byte[] key = secretKey.getEncoded();
        return key;
    }

    private static String encodeHmacSHA256(byte[] data, byte[] key) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key, "HmacSHA256");
        Mac mac = Mac.getInstance(secretKey.getAlgorithm());
        mac.init(secretKey);
        byte[] digest = mac.doFinal(data);
        return new HexBinaryAdapter().marshal(digest);
    }

    private static byte[] initHmacSHA384Key() throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance("HmacSHA384");
        SecretKey secretKey = generator.generateKey();
        byte[] key = secretKey.getEncoded();
        return key;
    }

    private static String encodeHmacSHA384(byte[] data, byte[] key) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key, "HmacSHA384");
        Mac mac = Mac.getInstance(secretKey.getAlgorithm());
        mac.init(secretKey);
        byte[] digest = mac.doFinal(data);
        return new HexBinaryAdapter().marshal(digest);
    }

    private static byte[] initHmacSHA512Key() throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance("HmacSHA512");
        SecretKey secretKey = generator.generateKey();
        byte[] key = secretKey.getEncoded();
        return key;
    }

    private static String encodeHmacSHA512(byte[] data, byte[] key) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key, "HmacSHA512");
        Mac mac = Mac.getInstance(secretKey.getAlgorithm());
        mac.init(secretKey);
        byte[] digest = mac.doFinal(data);
        return new HexBinaryAdapter().marshal(digest);
    }

    public static String getMacKey() throws NoSuchAlgorithmException {
        byte[] keyHmacMD5 = MacUtil.initHmacMD5Key();
        return new HexBinaryAdapter().marshal(keyHmacMD5);
    }

    public static String encodeMac(String src, String code, String key) throws UnsupportedEncodingException, Exception {
        return MacUtil.encodeHmacMD5(src.getBytes(code), new HexBinaryAdapter().unmarshal(key));
    }

    public static String encodeMac(String src, String key) throws UnsupportedEncodingException, Exception {
        return MacUtil.encodeMac(src, "UTF-8", key);
    }

    public static void main(String[] args) throws Exception {
        String testString = "asdasd23233323223";
        byte[] keyHmacMD5 = MacUtil.initHmacMD5Key();
        System.out.println("key::1" + HexUtil.bytesToHexString(keyHmacMD5));
        System.out.println("key::2" + new HexBinaryAdapter().marshal(keyHmacMD5));
        System.out.println(MacUtil.encodeHmacMD5(testString.getBytes(), keyHmacMD5));
        byte[] keyHmacSHA1 = MacUtil.initHmacSHAKey();
        System.out.println("key::2" + new HexBinaryAdapter().marshal(keyHmacSHA1));
        System.out.println(MacUtil.encodeHmacSHA(testString.getBytes(), keyHmacSHA1));
        byte[] keyHmacSHA256 = MacUtil.initHmacSHA256Key();
        System.out.println(MacUtil.encodeHmacSHA256(testString.getBytes(), keyHmacSHA256));
        byte[] keyHmacSHA384 = MacUtil.initHmacSHA384Key();
        System.out.println(MacUtil.encodeHmacSHA384(testString.getBytes(), keyHmacSHA384));
        byte[] keyHmacSHA512 = MacUtil.initHmacSHA512Key();
        System.out.println(MacUtil.encodeHmacSHA512(testString.getBytes(), keyHmacSHA512));
    }
}

