/*
 * Decompiled with CFR 0.152.
 */
package com.yqjr.base.technicalclient.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TimeZone;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;

public class FtpClientUtil {
    private FTPClient ftpClient = new FTPClient();
    private String host;
    private int port;
    private String username;
    private String password;
    private int bufferSize;
    private String encoding;
    private static Logger logger = Logger.getLogger((String)FtpClientUtil.class.getName());

    public String getEncoding() {
        return this.encoding;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public FtpClientUtil() {
    }

    public FtpClientUtil(String strIp, int intPort, String user, String Password, String encoding, int bufferSize) {
        this();
        this.host = strIp;
        this.port = intPort;
        this.username = user;
        this.password = Password;
        this.encoding = encoding;
    }

    public boolean ftpLogin() {
        boolean isLogin = false;
        FTPClientConfig ftpClientConfig = new FTPClientConfig();
        ftpClientConfig.setServerTimeZoneId(TimeZone.getDefault().getID());
        this.ftpClient.configure(ftpClientConfig);
        this.ftpClient.setControlEncoding(this.encoding);
        logger.debug((Object)this.host);
        logger.debug((Object)this.port);
        logger.debug((Object)this.encoding);
        logger.debug((Object)this.username);
        logger.debug((Object)this.password);
        try {
            if (this.port > 0) {
                this.ftpClient.connect(this.host, this.port);
            } else {
                this.ftpClient.connect(this.host);
            }
            int reply = this.ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.ftpClient.disconnect();
                logger.error((Object)"\u767b\u5f55FTP\u670d\u52a1\u5931\u8d25\uff01");
                return isLogin;
            }
            this.ftpClient.login(this.username, this.password);
            this.ftpClient.enterLocalPassiveMode();
            this.ftpClient.setFileType(2);
            logger.info((Object)("\u606d\u559c" + this.username + "\u6210\u529f\u767b\u9646FTP\u670d\u52a1\u5668"));
            isLogin = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(this.username + "\u767b\u5f55FTP\u670d\u52a1\u5931\u8d25\uff01" + e.getMessage()));
        }
        this.ftpClient.setBufferSize(this.bufferSize);
        this.ftpClient.setDataTimeout(30000);
        return isLogin;
    }

    public void ftpLogOut() {
        if (null != this.ftpClient && this.ftpClient.isConnected()) {
            try {
                boolean reuslt = this.ftpClient.logout();
                if (reuslt) {
                    logger.info((Object)"\u6210\u529f\u9000\u51fa\u670d\u52a1\u5668");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.warn((Object)("\u9000\u51faFTP\u670d\u52a1\u5668\u5f02\u5e38\uff01" + e.getMessage()));
            }
            finally {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    logger.warn((Object)"\u5173\u95edFTP\u670d\u52a1\u5668\u7684\u8fde\u63a5\u5f02\u5e38\uff01");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(File localFile, String remoteUpLoadePath) {
        BufferedInputStream inStream = null;
        boolean success = false;
        try {
            this.ftpClient.changeWorkingDirectory(remoteUpLoadePath);
            inStream = new BufferedInputStream(new FileInputStream(localFile));
            logger.info((Object)(localFile.getName() + "\u5f00\u59cb\u4e0a\u4f20....."));
            this.ftpClient.setBufferSize(this.bufferSize);
            success = this.ftpClient.storeFile(localFile.getName(), (InputStream)inStream);
            logger.info((Object)("success::" + success));
            if (success) {
                logger.info((Object)(localFile.getName() + "\u4e0a\u4f20\u6210\u529f"));
                boolean bl = success;
                return bl;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            logger.error((Object)(localFile + "\u672a\u627e\u5230"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String remoteFileName, String localDires, String remoteDownLoadPath) {
        String strFilePath = localDires + remoteFileName;
        BufferedOutputStream outStream = null;
        boolean success = false;
        try {
            this.ftpClient.changeWorkingDirectory(remoteDownLoadPath);
            outStream = new BufferedOutputStream(new FileOutputStream(strFilePath));
            logger.info((Object)(remoteFileName + "\u5f00\u59cb\u4e0b\u8f7d...."));
            success = this.ftpClient.retrieveFile(remoteFileName, (OutputStream)outStream);
            if (success) {
                logger.info((Object)(remoteFileName + "\u6210\u529f\u4e0b\u8f7d\u5230" + strFilePath));
                boolean bl = success;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)(remoteFileName + "\u4e0b\u8f7d\u5931\u8d25"));
        }
        finally {
            if (null != outStream) {
                try {
                    outStream.flush();
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!success) {
            logger.error((Object)(remoteFileName + "\u4e0b\u8f7d\u5931\u8d25!!!"));
        }
        return success;
    }

    public boolean uploadDirectory(String localDirectory, String remoteDirectoryPath) {
        int currentFile;
        File src = new File(localDirectory);
        try {
            remoteDirectoryPath = remoteDirectoryPath + src.getName() + "/";
            this.ftpClient.makeDirectory(remoteDirectoryPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.info((Object)(remoteDirectoryPath + "\u76ee\u5f55\u521b\u5efa\u5931\u8d25"));
        }
        File[] allFile = src.listFiles();
        for (currentFile = 0; currentFile < allFile.length; ++currentFile) {
            if (allFile[currentFile].isDirectory()) continue;
            String srcName = allFile[currentFile].getPath().toString();
            this.uploadFile(new File(srcName), remoteDirectoryPath);
        }
        for (currentFile = 0; currentFile < allFile.length; ++currentFile) {
            if (!allFile[currentFile].isDirectory()) continue;
            this.uploadDirectory(allFile[currentFile].getPath().toString(), remoteDirectoryPath);
        }
        return true;
    }

    public boolean downLoadDirectory(String localDirectoryPath, String remoteDirectory) {
        try {
            int currentFile;
            String fileName = new File(remoteDirectory).getName();
            localDirectoryPath = localDirectoryPath + fileName + "//";
            new File(localDirectoryPath).mkdirs();
            FTPFile[] allFile = this.ftpClient.listFiles(remoteDirectory);
            for (currentFile = 0; currentFile < allFile.length; ++currentFile) {
                if (allFile[currentFile].isDirectory()) continue;
                this.downloadFile(allFile[currentFile].getName(), localDirectoryPath, remoteDirectory);
            }
            for (currentFile = 0; currentFile < allFile.length; ++currentFile) {
                if (!allFile[currentFile].isDirectory()) continue;
                String strremoteDirectoryPath = remoteDirectory + "/" + allFile[currentFile].getName();
                this.downLoadDirectory(localDirectoryPath, strremoteDirectoryPath);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.info((Object)"\u4e0b\u8f7d\u6587\u4ef6\u5939\u5931\u8d25");
            return false;
        }
        return true;
    }

    public FTPClient getFtpClient() {
        return this.ftpClient;
    }

    public void setFtpClient(FTPClient ftpClient) {
        this.ftpClient = ftpClient;
    }

    public static void main(String[] args) throws IOException {
    }
}

