/*
 * Decompiled with CFR 0.152.
 */
package com.yqjr.base.technicalclient.memcached;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.exception.MemcachedException;

public class MemCache {
    private Set<String> keySet = new HashSet<String>();
    private final String name;
    private final int expire;
    private final MemcachedClient memcachedClient;

    public MemCache(String name, int expire, MemcachedClient memcachedClient) {
        this.name = name;
        this.expire = expire;
        this.memcachedClient = memcachedClient;
    }

    public Object get(String key) {
        Object value = null;
        try {
            key = this.getKey(key);
            value = this.memcachedClient.get(key);
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (MemcachedException e) {
            e.printStackTrace();
        }
        return value;
    }

    public void put(String key, Object value) {
        if (value == null) {
            return;
        }
        try {
            key = this.getKey(key);
            this.memcachedClient.setWithNoReply(key, this.expire, value);
            this.keySet.add(key);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (MemcachedException e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        for (String key : this.keySet) {
            try {
                this.memcachedClient.deleteWithNoReply(this.getKey(key));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (MemcachedException e) {
                e.printStackTrace();
            }
        }
    }

    public void delete(String key) {
        try {
            key = this.getKey(key);
            this.memcachedClient.deleteWithNoReply(key);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (MemcachedException e) {
            e.printStackTrace();
        }
    }

    private String getKey(String key) {
        return this.name + "_" + key;
    }
}

