/*
 * Decompiled with CFR 0.152.
 */
package com.yqjr.base.technicalclient.memcached;

import com.yqjr.base.technicalclient.memcached.MemcachedCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.rubyeye.xmemcached.MemcachedClient;
import org.springframework.cache.Cache;
import org.springframework.cache.transaction.AbstractTransactionSupportingCacheManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemcachedCacheManager
extends AbstractTransactionSupportingCacheManager {
    private ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>();
    private Map<String, Integer> expireMap = new HashMap<String, Integer>();
    private MemcachedClient memcachedClient;

    protected Collection<? extends Cache> loadCaches() {
        Collection values = this.cacheMap.values();
        return values;
    }

    public Cache getCache(String name) {
        Cache cache = (Cache)this.cacheMap.get(name);
        if (cache == null) {
            Integer expire = this.expireMap.get(name);
            if (expire == null) {
                expire = 0;
                this.expireMap.put(name, expire);
            }
            cache = new MemcachedCache(name, expire, this.memcachedClient);
            this.cacheMap.put(name, cache);
        }
        return cache;
    }

    public void setMemcachedClient(MemcachedClient memcachedClient) {
        this.memcachedClient = memcachedClient;
    }

    public void setConfigMap(Map<String, Integer> configMap) {
        this.expireMap = configMap;
    }
}

