/*
 * Decompiled with CFR 0.152.
 */
package com.yqjr.base.technicalclient.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SFtpClientUtil {
    private static Logger logger = Logger.getLogger((String)SFtpClientUtil.class.getName());
    private ChannelSftp chSftpClient;
    private String host;
    private int port;
    private String username;
    private int timeout;
    private String password;
    private Session session = null;
    private Channel channel = null;

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public ChannelSftp getChSftpClient() {
        return this.chSftpClient;
    }

    public void setChSftpClient(ChannelSftp chSftpClient) {
        this.chSftpClient = chSftpClient;
    }

    public SFtpClientUtil() {
    }

    public SFtpClientUtil(String strIp, int intPort, String user, String password, int timeout) {
        this();
        this.host = strIp;
        this.port = intPort;
        this.username = user;
        this.password = password;
        this.timeout = timeout;
    }

    public boolean sFtpLogin() {
        boolean isLogin = false;
        if (this.chSftpClient == null) {
            this.chSftpClient = this.getChannel();
            logger.info((Object)"sftp \u767b\u5f55\u6210\u529f");
        }
        return isLogin;
    }

    public void sftpLogOut() {
        if (null != this.chSftpClient && this.chSftpClient.isConnected()) {
            try {
                this.chSftpClient.quit();
                boolean reuslt = this.closeChannel();
                if (reuslt) {
                    logger.info((Object)"\u6210\u529f\u9000\u51fa\u670d\u52a1\u5668");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.warn((Object)("\u9000\u51faFTP\u670d\u52a1\u5668\u5f02\u5e38\uff01" + e.getMessage()));
            }
            finally {
                try {
                    this.closeChannel();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.warn((Object)"\u5173\u95edFTP\u670d\u52a1\u5668\u7684\u8fde\u63a5\u5f02\u5e38\uff01");
                }
            }
        }
    }

    public boolean uploadFile(String filePath, String remoteUpLoadePath) {
        boolean success = true;
        try {
            logger.info((Object)(filePath + "\u5f00\u59cb\u4e0a\u4f20....."));
            this.chSftpClient.put(filePath, remoteUpLoadePath, 0);
            logger.info((Object)("success::" + success));
            if (success) {
                logger.info((Object)(filePath + "\u4e0a\u4f20\u6210\u529f"));
                return success;
            }
        }
        catch (Exception e) {
            success = false;
            e.printStackTrace();
        }
        return success;
    }

    public boolean downloadFile(String remoteFileName, String localDires, String remoteDownLoadPath) {
        String strFilePath = localDires + remoteFileName;
        boolean success = true;
        try {
            logger.info((Object)(remoteFileName + "\u5f00\u59cb\u4e0b\u8f7d...."));
            this.chSftpClient.get(strFilePath, remoteDownLoadPath);
            if (success) {
                logger.info((Object)(remoteFileName + "\u6210\u529f\u4e0b\u8f7d\u5230" + strFilePath));
                return success;
            }
        }
        catch (Exception e) {
            success = false;
            e.printStackTrace();
            logger.error((Object)(remoteFileName + "\u4e0b\u8f7d\u5931\u8d25"));
        }
        if (!success) {
            logger.error((Object)(remoteFileName + "\u4e0b\u8f7d\u5931\u8d25!!!"));
        }
        return success;
    }

    public boolean uploadDirectory(String localDirectory, String remoteDirectoryPath) {
        int currentFile;
        File src = new File(localDirectory);
        try {
            remoteDirectoryPath = remoteDirectoryPath + src.getName() + "/";
            this.chSftpClient.mkdir(remoteDirectoryPath);
        }
        catch (SftpException e) {
            logger.info((Object)(remoteDirectoryPath + "\u76ee\u5f55\u521b\u5efa\u5931\u8d25"));
            e.printStackTrace();
        }
        File[] allFile = src.listFiles();
        for (currentFile = 0; currentFile < allFile.length; ++currentFile) {
            if (allFile[currentFile].isDirectory()) continue;
            String srcName = allFile[currentFile].getPath().toString();
            this.uploadFile(srcName, remoteDirectoryPath);
        }
        for (currentFile = 0; currentFile < allFile.length; ++currentFile) {
            if (!allFile[currentFile].isDirectory()) continue;
            this.uploadDirectory(allFile[currentFile].getPath().toString(), remoteDirectoryPath);
        }
        return true;
    }

    private ChannelSftp getChannel() {
        JSch jsch = new JSch();
        try {
            this.session = jsch.getSession(this.username, this.host, this.port);
            logger.debug((Object)"Session created.");
            if (this.password != null) {
                this.session.setPassword(this.password);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.session.setConfig(config);
            this.session.setTimeout(this.timeout);
            this.session.connect();
            logger.debug((Object)"Session connected.");
            logger.debug((Object)"Opening Channel.");
            this.channel = this.session.openChannel("sftp");
            this.channel.connect();
            logger.debug((Object)("Connected successfully to sftpHost = " + this.host + ",as sftpUserName = " + this.username + ", returning: " + this.channel));
        }
        catch (JSchException e) {
            logger.error((Object)"\u521d\u59cb\u5316\u5931\u8d25");
            e.printStackTrace();
        }
        return (ChannelSftp)this.channel;
    }

    private boolean closeChannel() {
        boolean flag = true;
        try {
            if (this.channel != null) {
                this.channel.disconnect();
            }
            if (this.session != null) {
                this.session.disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            flag = false;
        }
        return flag;
    }
}

