/*
 * Decompiled with CFR 0.152.
 */
package com.yqjr.base.technicalclient.sms;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMSClient {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String serverUrl;
    private String comCode;
    private String spNumber;
    private String operatorCode;
    private String bizUser;

    public String getSpNumber() {
        return this.spNumber;
    }

    public void setSpNumber(String spNumber) {
        this.spNumber = spNumber;
    }

    public String getOperatorCode() {
        return this.operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }

    public String getBizUser() {
        return this.bizUser;
    }

    public void setBizUser(String bizUser) {
        this.bizUser = bizUser;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getComCode() {
        return this.comCode;
    }

    public void setComCode(String comCode) {
        this.comCode = comCode;
    }

    public long massSend(String phoneNo, String content, String businessType, String bizNo) throws Exception {
        return this.massSend(phoneNo, content, businessType, bizNo, this.bizUser, this.operatorCode, this.spNumber, this.comCode);
    }

    public long massSend(String phoneNo, String content, String businessType, String bizNo, String bizUser) throws Exception {
        return this.massSend(phoneNo, content, businessType, bizNo, bizUser, this.operatorCode, this.spNumber, this.comCode);
    }

    public long massSend(String phoneNo, String content, String businessType, String bizNo, String bizUser, String operatorCode) throws Exception {
        return this.massSend(phoneNo, content, businessType, bizNo, bizUser, operatorCode, this.spNumber, this.comCode);
    }

    public long massSend(String phoneNo, String content, String businessType, String bizNo, String bizUser, String operatorCode, String spNumber, String comCode) throws Exception {
        String sUrl = null;
        String ret = "";
        if (!this.isPhoneNumber(phoneNo)) {
            throw new IllegalArgumentException(bizNo + " :phoneNo is not a valid number!");
        }
        this.logger.info("Send a message Content: [{}][{}][{}][{}] ", new Object[]{bizNo, phoneNo, content});
        sUrl = this.serverUrl + "/smserver/submitMessage?phoneNo=" + phoneNo + "&content=" + URLEncoder.encode(content, "GB2312") + "&comCode=" + comCode + "&businessType=" + businessType + "&spNumber=" + spNumber + "&operatorCode=" + operatorCode + "&bizUser=" + bizUser + "&bizNo=" + bizNo;
        ret = this.getUrl(sUrl);
        this.logger.info("Send a message Reslut: [{}] ", (Object)ret);
        return this.parseResult(ret);
    }

    private String getUrl(String urlString) throws Exception {
        StringBuffer sb = new StringBuffer();
        URL url = new URL(urlString);
        URLConnection conn = url.openConnection();
        InputStream in = conn.getInputStream();
        int all = in.available();
        byte[] b = new byte[all];
        in.read(b);
        String webpage = new String(b, "GB2312");
        in.close();
        sb.append(webpage);
        return sb.toString();
    }

    private long parseResult(String result) {
        long recep = -1L;
        recep = Long.parseLong(result.substring(result.indexOf("&result=") + 8, result.indexOf("&result=") + 9));
        return recep;
    }

    public boolean isPhoneNumber(String str) {
        String p = "^1[0-9][0-9]\\d{8}$";
        if (str != null) {
            return str.matches(p);
        }
        return false;
    }
}

