/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.encrypt.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArrayUtil {
    public static final String HUNDSUN_VERSION = "@system \u4e09\u5ce1\u4ed8 @version V2.0.1.1 @lastModiDate 20140616 @describe \u6700\u8fd1\u4fee\u6539\u8bb0\u5f55";
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    private static final int INITIAL_NON_ZERO_ODD_NUMBER = 17;
    private static final int MULTIPLIER_NON_ZERO_ODD_NUMBER = 37;

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(short[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(double[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(float[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(boolean[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(char[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(Object[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isNotEmpty(long[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isNotEmpty(int[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isNotEmpty(short[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isNotEmpty(byte[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isNotEmpty(double[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isNotEmpty(float[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isNotEmpty(boolean[] array) {
        return array != null && array.length > 0;
    }

    public static boolean isNotEmpty(char[] array) {
        return array != null && array.length > 0;
    }

    public static Object[] defaultIfNull(Object[] array) {
        return array == null ? EMPTY_OBJECT_ARRAY : array;
    }

    public static long[] defaultIfNull(long[] array) {
        return array == null ? EMPTY_LONG_ARRAY : array;
    }

    public static int[] defaultIfNull(int[] array) {
        return array == null ? EMPTY_INT_ARRAY : array;
    }

    public static short[] defaultIfNull(short[] array) {
        return array == null ? EMPTY_SHORT_ARRAY : array;
    }

    public static byte[] defaultIfNull(byte[] array) {
        return array == null ? EMPTY_BYTE_ARRAY : array;
    }

    public static double[] defaultIfNull(double[] array) {
        return array == null ? EMPTY_DOUBLE_ARRAY : array;
    }

    public static float[] defaultIfNull(float[] array) {
        return array == null ? EMPTY_FLOAT_ARRAY : array;
    }

    public static boolean[] defaultIfNull(boolean[] array) {
        return array == null ? EMPTY_BOOLEAN_ARRAY : array;
    }

    public static char[] defaultIfNull(char[] array) {
        return array == null ? EMPTY_CHAR_ARRAY : array;
    }

    public static Object[] defaultIfNull(Object[] array, Object[] defaultArray) {
        return array == null ? defaultArray : array;
    }

    public static long[] defaultIfNull(long[] array, long[] defaultArray) {
        return array == null ? defaultArray : array;
    }

    public static int[] defaultIfNull(int[] array, int[] defaultArray) {
        return array == null ? defaultArray : array;
    }

    public static short[] defaultIfNull(short[] array, short[] defaultArray) {
        return array == null ? defaultArray : array;
    }

    public static byte[] defaultIfNull(byte[] array, byte[] defaultArray) {
        return array == null ? defaultArray : array;
    }

    public static double[] defaultIfNull(double[] array, double[] defaultArray) {
        return array == null ? defaultArray : array;
    }

    public static float[] defaultIfNull(float[] array, float[] defaultArray) {
        return array == null ? defaultArray : array;
    }

    public static boolean[] defaultIfNull(boolean[] array, boolean[] defaultArray) {
        return array == null ? defaultArray : array;
    }

    public static char[] defaultIfNull(char[] array, char[] defaultArray) {
        return array == null ? defaultArray : array;
    }

    public static Object[] defaultIfEmpty(Object[] array) {
        return array == null ? EMPTY_OBJECT_ARRAY : array;
    }

    public static long[] defaultIfEmpty(long[] array) {
        return array == null ? EMPTY_LONG_ARRAY : array;
    }

    public static int[] defaultIfEmpty(int[] array) {
        return array == null ? EMPTY_INT_ARRAY : array;
    }

    public static short[] defaultIfEmpty(short[] array) {
        return array == null ? EMPTY_SHORT_ARRAY : array;
    }

    public static byte[] defaultIfEmpty(byte[] array) {
        return array == null ? EMPTY_BYTE_ARRAY : array;
    }

    public static double[] defaultIfEmpty(double[] array) {
        return array == null ? EMPTY_DOUBLE_ARRAY : array;
    }

    public static float[] defaultIfEmpty(float[] array) {
        return array == null ? EMPTY_FLOAT_ARRAY : array;
    }

    public static boolean[] defaultIfEmpty(boolean[] array) {
        return array == null ? EMPTY_BOOLEAN_ARRAY : array;
    }

    public static char[] defaultIfEmpty(char[] array) {
        return array == null ? EMPTY_CHAR_ARRAY : array;
    }

    public static Object[] defaultIfEmpty(Object[] array, Object[] defaultArray) {
        return array == null || array.length == 0 ? defaultArray : array;
    }

    public static long[] defaultIfEmpty(long[] array, long[] defaultArray) {
        return array == null || array.length == 0 ? defaultArray : array;
    }

    public static int[] defaultIfEmpty(int[] array, int[] defaultArray) {
        return array == null || array.length == 0 ? defaultArray : array;
    }

    public static short[] defaultIfEmpty(short[] array, short[] defaultArray) {
        return array == null || array.length == 0 ? defaultArray : array;
    }

    public static byte[] defaultIfEmpty(byte[] array, byte[] defaultArray) {
        return array == null || array.length == 0 ? defaultArray : array;
    }

    public static double[] defaultIfEmpty(double[] array, double[] defaultArray) {
        return array == null || array.length == 0 ? defaultArray : array;
    }

    public static float[] defaultIfEmpty(float[] array, float[] defaultArray) {
        return array == null || array.length == 0 ? defaultArray : array;
    }

    public static boolean[] defaultIfEmpty(boolean[] array, boolean[] defaultArray) {
        return array == null || array.length == 0 ? defaultArray : array;
    }

    public static char[] defaultIfEmpty(char[] array, char[] defaultArray) {
        return array == null || array.length == 0 ? defaultArray : array;
    }

    public static boolean equals(Object array1, Object array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        Class<?> clazz = array1.getClass();
        if (!clazz.equals(array2.getClass())) {
            return false;
        }
        if (!clazz.isArray()) {
            return array1.equals(array2);
        }
        if (array1 instanceof long[]) {
            long[] longArray1 = (long[])array1;
            long[] longArray2 = (long[])array2;
            if (longArray1.length != longArray2.length) {
                return false;
            }
            int i = 0;
            while (i < longArray1.length) {
                if (longArray1[i] != longArray2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (array1 instanceof int[]) {
            int[] intArray1 = (int[])array1;
            int[] intArray2 = (int[])array2;
            if (intArray1.length != intArray2.length) {
                return false;
            }
            int i = 0;
            while (i < intArray1.length) {
                if (intArray1[i] != intArray2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (array1 instanceof short[]) {
            short[] shortArray1 = (short[])array1;
            short[] shortArray2 = (short[])array2;
            if (shortArray1.length != shortArray2.length) {
                return false;
            }
            int i = 0;
            while (i < shortArray1.length) {
                if (shortArray1[i] != shortArray2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (array1 instanceof byte[]) {
            byte[] byteArray1 = (byte[])array1;
            byte[] byteArray2 = (byte[])array2;
            if (byteArray1.length != byteArray2.length) {
                return false;
            }
            int i = 0;
            while (i < byteArray1.length) {
                if (byteArray1[i] != byteArray2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (array1 instanceof double[]) {
            double[] doubleArray1 = (double[])array1;
            double[] doubleArray2 = (double[])array2;
            if (doubleArray1.length != doubleArray2.length) {
                return false;
            }
            int i = 0;
            while (i < doubleArray1.length) {
                if (Double.doubleToLongBits(doubleArray1[i]) != Double.doubleToLongBits(doubleArray2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (array1 instanceof float[]) {
            float[] floatArray1 = (float[])array1;
            float[] floatArray2 = (float[])array2;
            if (floatArray1.length != floatArray2.length) {
                return false;
            }
            int i = 0;
            while (i < floatArray1.length) {
                if (Float.floatToIntBits(floatArray1[i]) != Float.floatToIntBits(floatArray2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (array1 instanceof boolean[]) {
            boolean[] booleanArray1 = (boolean[])array1;
            boolean[] booleanArray2 = (boolean[])array2;
            if (booleanArray1.length != booleanArray2.length) {
                return false;
            }
            int i = 0;
            while (i < booleanArray1.length) {
                if (booleanArray1[i] != booleanArray2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (array1 instanceof char[]) {
            char[] charArray1 = (char[])array1;
            char[] charArray2 = (char[])array2;
            if (charArray1.length != charArray2.length) {
                return false;
            }
            int i = 0;
            while (i < charArray1.length) {
                if (charArray1[i] != charArray2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        Object[] objectArray1 = (Object[])array1;
        Object[] objectArray2 = (Object[])array2;
        if (objectArray1.length != objectArray2.length) {
            return false;
        }
        int i = 0;
        while (i < objectArray1.length) {
            if (!ArrayUtil.equals(objectArray1[i], objectArray2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int hashCode(Object array) {
        if (array == null) {
            return 0;
        }
        if (!array.getClass().isArray()) {
            return array.hashCode();
        }
        int hashCode = 17;
        if (array instanceof long[]) {
            long[] longArray = (long[])array;
            int i = 0;
            while (i < longArray.length) {
                hashCode = hashCode * 37 + (int)(longArray[i] ^ longArray[i] >> 32);
                ++i;
            }
        } else if (array instanceof int[]) {
            int[] intArray = (int[])array;
            int i = 0;
            while (i < intArray.length) {
                hashCode = hashCode * 37 + intArray[i];
                ++i;
            }
        } else if (array instanceof short[]) {
            short[] shortArray = (short[])array;
            int i = 0;
            while (i < shortArray.length) {
                hashCode = hashCode * 37 + shortArray[i];
                ++i;
            }
        } else if (array instanceof byte[]) {
            byte[] byteArray = (byte[])array;
            int i = 0;
            while (i < byteArray.length) {
                hashCode = hashCode * 37 + byteArray[i];
                ++i;
            }
        } else if (array instanceof double[]) {
            double[] doubleArray = (double[])array;
            int i = 0;
            while (i < doubleArray.length) {
                long longBits = Double.doubleToLongBits(doubleArray[i]);
                hashCode = hashCode * 37 + (int)(longBits ^ longBits >> 32);
                ++i;
            }
        } else if (array instanceof float[]) {
            float[] floatArray = (float[])array;
            int i = 0;
            while (i < floatArray.length) {
                hashCode = hashCode * 37 + Float.floatToIntBits(floatArray[i]);
                ++i;
            }
        } else if (array instanceof boolean[]) {
            boolean[] booleanArray = (boolean[])array;
            int i = 0;
            while (i < booleanArray.length) {
                hashCode = hashCode * 37 + (booleanArray[i] ? 1 : 0);
                ++i;
            }
        } else if (array instanceof char[]) {
            char[] charArray = (char[])array;
            int i = 0;
            while (i < charArray.length) {
                hashCode = hashCode * 37 + charArray[i];
                ++i;
            }
        } else {
            Object[] objectArray = (Object[])array;
            int i = 0;
            while (i < objectArray.length) {
                hashCode = hashCode * 37 + ArrayUtil.hashCode(objectArray[i]);
                ++i;
            }
        }
        return hashCode;
    }

    public static List toFixedList(Object[] array) {
        if (array == null) {
            return null;
        }
        return Arrays.asList(array);
    }

    public static List toList(Object array) {
        return ArrayUtil.toList(array, null);
    }

    public static List toList(Object array, List list) {
        if (array == null) {
            return list;
        }
        if (!array.getClass().isArray()) {
            if (list == null) {
                list = new ArrayList<Object>(1);
            }
            list.add(array);
        } else if (array instanceof long[]) {
            long[] longArray = (long[])array;
            if (list == null) {
                list = new ArrayList(longArray.length);
            }
            int i = 0;
            while (i < longArray.length) {
                list.add(new Long(longArray[i]));
                ++i;
            }
        } else if (array instanceof int[]) {
            int[] intArray = (int[])array;
            if (list == null) {
                list = new ArrayList(intArray.length);
            }
            int i = 0;
            while (i < intArray.length) {
                list.add(new Integer(intArray[i]));
                ++i;
            }
        } else if (array instanceof short[]) {
            short[] shortArray = (short[])array;
            if (list == null) {
                list = new ArrayList(shortArray.length);
            }
            int i = 0;
            while (i < shortArray.length) {
                list.add(new Short(shortArray[i]));
                ++i;
            }
        } else if (array instanceof byte[]) {
            byte[] byteArray = (byte[])array;
            if (list == null) {
                list = new ArrayList(byteArray.length);
            }
            int i = 0;
            while (i < byteArray.length) {
                list.add(new Byte(byteArray[i]));
                ++i;
            }
        } else if (array instanceof double[]) {
            double[] doubleArray = (double[])array;
            if (list == null) {
                list = new ArrayList(doubleArray.length);
            }
            int i = 0;
            while (i < doubleArray.length) {
                list.add(new Double(doubleArray[i]));
                ++i;
            }
        } else if (array instanceof float[]) {
            float[] floatArray = (float[])array;
            if (list == null) {
                list = new ArrayList(floatArray.length);
            }
            int i = 0;
            while (i < floatArray.length) {
                list.add(new Float(floatArray[i]));
                ++i;
            }
        } else if (array instanceof boolean[]) {
            boolean[] booleanArray = (boolean[])array;
            if (list == null) {
                list = new ArrayList(booleanArray.length);
            }
            int i = 0;
            while (i < booleanArray.length) {
                list.add(booleanArray[i] ? Boolean.TRUE : Boolean.FALSE);
                ++i;
            }
        } else if (array instanceof char[]) {
            char[] charArray = (char[])array;
            if (list == null) {
                list = new ArrayList(charArray.length);
            }
            int i = 0;
            while (i < charArray.length) {
                list.add(new Character(charArray[i]));
                ++i;
            }
        } else {
            Object[] objectArray = (Object[])array;
            if (list == null) {
                list = new ArrayList(objectArray.length);
            }
            int i = 0;
            while (i < objectArray.length) {
                list.add(objectArray[i]);
                ++i;
            }
        }
        return list;
    }

    public static Map toMap(Object[] array) {
        return ArrayUtil.toMap(array, null);
    }

    public static Map toMap(Object[] array, Map map) {
        if (array == null) {
            return map;
        }
        if (map == null) {
            map = new HashMap<Object, Object>((int)((double)array.length * 1.5));
        }
        int i = 0;
        while (i < array.length) {
            Object[] entry;
            Object object = array[i];
            if (object instanceof Map.Entry) {
                entry = (Object[])object;
                map.put(entry.getKey(), entry.getValue());
            } else if (object instanceof Object[]) {
                entry = (Object[])object;
                if (entry.length < 2) {
                    throw new IllegalArgumentException("Array element " + i + ", '" + object + "', has a length less than 2");
                }
                map.put(entry[0], entry[1]);
            } else {
                throw new IllegalArgumentException("Array element " + i + ", '" + object + "', is neither of type Map.Entry nor an Array");
            }
            ++i;
        }
        return map;
    }

    public static Object[] clone(Object[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static long[] clone(long[] array) {
        if (array == null) {
            return null;
        }
        return (long[])array.clone();
    }

    public static int[] clone(int[] array) {
        if (array == null) {
            return null;
        }
        return (int[])array.clone();
    }

    public static short[] clone(short[] array) {
        if (array == null) {
            return null;
        }
        return (short[])array.clone();
    }

    public static byte[] clone(byte[] array) {
        if (array == null) {
            return null;
        }
        return (byte[])array.clone();
    }

    public static double[] clone(double[] array) {
        if (array == null) {
            return null;
        }
        return (double[])array.clone();
    }

    public static float[] clone(float[] array) {
        if (array == null) {
            return null;
        }
        return (float[])array.clone();
    }

    public static boolean[] clone(boolean[] array) {
        if (array == null) {
            return null;
        }
        return (boolean[])array.clone();
    }

    public static char[] clone(char[] array) {
        if (array == null) {
            return null;
        }
        return (char[])array.clone();
    }

    public static boolean isSameLength(Object[] array1, Object[] array2) {
        int length2;
        int length1 = array1 == null ? 0 : array1.length;
        int n = length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isSameLength(long[] array1, long[] array2) {
        int length2;
        int length1 = array1 == null ? 0 : array1.length;
        int n = length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isSameLength(int[] array1, int[] array2) {
        int length2;
        int length1 = array1 == null ? 0 : array1.length;
        int n = length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isSameLength(short[] array1, short[] array2) {
        int length2;
        int length1 = array1 == null ? 0 : array1.length;
        int n = length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isSameLength(byte[] array1, byte[] array2) {
        int length2;
        int length1 = array1 == null ? 0 : array1.length;
        int n = length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isSameLength(double[] array1, double[] array2) {
        int length2;
        int length1 = array1 == null ? 0 : array1.length;
        int n = length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isSameLength(float[] array1, float[] array2) {
        int length2;
        int length1 = array1 == null ? 0 : array1.length;
        int n = length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isSameLength(boolean[] array1, boolean[] array2) {
        int length2;
        int length1 = array1 == null ? 0 : array1.length;
        int n = length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isSameLength(char[] array1, char[] array2) {
        int length2;
        int length1 = array1 == null ? 0 : array1.length;
        int n = length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static void reverse(Object[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            Object tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            ++i;
            --j;
        }
    }

    public static void reverse(long[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            long tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            ++i;
            --j;
        }
    }

    public static void reverse(int[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            int tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            ++i;
            --j;
        }
    }

    public static void reverse(short[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            short tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            ++i;
            --j;
        }
    }

    public static void reverse(byte[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            ++i;
            --j;
        }
    }

    public static void reverse(double[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            double tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            ++i;
            --j;
        }
    }

    public static void reverse(float[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            float tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            ++i;
            --j;
        }
    }

    public static void reverse(boolean[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            boolean tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            ++i;
            --j;
        }
    }

    public static void reverse(char[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            char tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            ++i;
            --j;
        }
    }

    public static int indexOf(Object[] array, Object objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind, 0);
    }

    public static int indexOf(Object[] array, Object[] arrayToFind) {
        return ArrayUtil.indexOf(array, arrayToFind, 0);
    }

    public static int indexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (objectToFind == null) {
            int i = startIndex;
            while (i < array.length) {
                if (array[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = startIndex;
            while (i < array.length) {
                if (objectToFind.equals(array[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(Object[] array, Object objectToFind) {
        return ArrayUtil.lastIndexOf(array, objectToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(Object[] array, Object[] arrayToFind) {
        return ArrayUtil.lastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (objectToFind == null) {
            int i = startIndex;
            while (i >= 0) {
                if (array[i] == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i = startIndex;
            while (i >= 0) {
                if (objectToFind.equals(array[i])) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public static boolean contains(Object[] array, Object objectToFind) {
        return ArrayUtil.indexOf(array, objectToFind) != -1;
    }

    public static boolean contains(Object[] array, Object[] arrayToFind) {
        return ArrayUtil.indexOf(array, arrayToFind) != -1;
    }

    public static int indexOf(long[] array, long longToFind) {
        return ArrayUtil.indexOf(array, longToFind, 0);
    }

    public static int indexOf(long[] array, long[] arrayToFind) {
        return ArrayUtil.indexOf(array, arrayToFind, 0);
    }

    public static int indexOf(long[] array, long longToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        int i = startIndex;
        while (i < array.length) {
            if (longToFind == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(long[] array, long[] arrayToFind, int startIndex) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        long first = arrayToFind[0];
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && array[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                if (array[j++] == arrayToFind[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int lastIndexOf(long[] array, long longToFind) {
        return ArrayUtil.lastIndexOf(array, longToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(long[] array, long[] arrayToFind) {
        return ArrayUtil.lastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(long[] array, long longToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        int i = startIndex;
        while (i >= 0) {
            if (longToFind == array[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int lastIndexOf(long[] array, long[] arrayToFind, int startIndex) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        long last = arrayToFind[lastIndex];
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && array[i] != last) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                if (array[j--] == arrayToFind[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean contains(long[] array, long longToFind) {
        return ArrayUtil.indexOf(array, longToFind) != -1;
    }

    public static boolean contains(long[] array, long[] arrayToFind) {
        return ArrayUtil.indexOf(array, arrayToFind) != -1;
    }

    public static int indexOf(int[] array, int intToFind) {
        return ArrayUtil.indexOf(array, intToFind, 0);
    }

    public static int indexOf(int[] array, int[] arrayToFind) {
        return ArrayUtil.indexOf(array, arrayToFind, 0);
    }

    public static int indexOf(int[] array, int intToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        int i = startIndex;
        while (i < array.length) {
            if (intToFind == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int[] arrayToFind, int startIndex) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int first = arrayToFind[0];
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && array[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                if (array[j++] == arrayToFind[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int lastIndexOf(int[] array, int intToFind) {
        return ArrayUtil.lastIndexOf(array, intToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(int[] array, int[] arrayToFind) {
        return ArrayUtil.lastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(int[] array, int intToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        int i = startIndex;
        while (i >= 0) {
            if (intToFind == array[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int[] arrayToFind, int startIndex) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        int last = arrayToFind[lastIndex];
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && array[i] != last) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                if (array[j--] == arrayToFind[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean contains(int[] array, int intToFind) {
        return ArrayUtil.indexOf(array, intToFind) != -1;
    }

    public static boolean contains(int[] array, int[] arrayToFind) {
        return ArrayUtil.indexOf(array, arrayToFind) != -1;
    }

    public static int indexOf(short[] array, short shortToFind) {
        return ArrayUtil.indexOf(array, shortToFind, 0);
    }

    public static int indexOf(short[] array, short[] arrayToFind) {
        return ArrayUtil.indexOf(array, arrayToFind, 0);
    }

    public static int indexOf(short[] array, short shortToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        int i = startIndex;
        while (i < array.length) {
            if (shortToFind == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(short[] array, short[] arrayToFind, int startIndex) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        short first = arrayToFind[0];
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && array[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                if (array[j++] == arrayToFind[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int lastIndexOf(short[] array, short shortToFind) {
        return ArrayUtil.lastIndexOf(array, shortToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(short[] array, short[] arrayToFind) {
        return ArrayUtil.lastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(short[] array, short shortToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        int i = startIndex;
        while (i >= 0) {
            if (shortToFind == array[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int lastIndexOf(short[] array, short[] arrayToFind, int startIndex) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        short last = arrayToFind[lastIndex];
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && array[i] != last) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                if (array[j--] == arrayToFind[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean contains(short[] array, short shortToFind) {
        return ArrayUtil.indexOf(array, shortToFind) != -1;
    }

    public static boolean contains(short[] array, short[] arrayToFind) {
        return ArrayUtil.indexOf(array, arrayToFind) != -1;
    }

    public static int indexOf(byte[] array, byte byteToFind) {
        return ArrayUtil.indexOf(array, byteToFind, 0);
    }

    public static int indexOf(byte[] array, byte[] arrayToFind) {
        return ArrayUtil.indexOf(array, arrayToFind, 0);
    }

    public static int indexOf(byte[] array, byte byteToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        int i = startIndex;
        while (i < array.length) {
            if (byteToFind == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte[] arrayToFind, int startIndex) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        byte first = arrayToFind[0];
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && array[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                if (array[j++] == arrayToFind[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int lastIndexOf(byte[] array, byte byteToFind) {
        return ArrayUtil.lastIndexOf(array, byteToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(byte[] array, byte[] arrayToFind) {
        return ArrayUtil.lastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(byte[] array, byte byteToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        int i = startIndex;
        while (i >= 0) {
            if (byteToFind == array[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] array, byte[] arrayToFind, int startIndex) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        byte last = arrayToFind[lastIndex];
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && array[i] != last) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                if (array[j--] == arrayToFind[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean contains(byte[] array, byte byteToFind) {
        return ArrayUtil.indexOf(array, byteToFind) != -1;
    }

    public static boolean contains(byte[] array, byte[] arrayToFind) {
        return ArrayUtil.indexOf(array, arrayToFind) != -1;
    }

    public static int indexOf(double[] array, double doubleToFind) {
        return ArrayUtil.indexOf(array, doubleToFind, 0, 0.0);
    }

    public static int indexOf(double[] array, double doubleToFind, double tolerance) {
        return ArrayUtil.indexOf(array, doubleToFind, 0, tolerance);
    }

    public static int indexOf(double[] array, double[] arrayToFind) {
        return ArrayUtil.indexOf(array, arrayToFind, 0, 0.0);
    }

    public static int indexOf(double[] array, double[] arrayToFind, double tolerance) {
        return ArrayUtil.indexOf(array, arrayToFind, 0, tolerance);
    }

    public static int indexOf(double[] array, double doubleToFind, int startIndex) {
        return ArrayUtil.indexOf(array, doubleToFind, startIndex, 0.0);
    }

    public static int indexOf(double[] array, double doubleToFind, int startIndex, double tolerance) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        double min = doubleToFind - tolerance;
        double max = doubleToFind + tolerance;
        int i = startIndex;
        while (i < array.length) {
            if (array[i] >= min && array[i] <= max) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double[] arrayToFind, int startIndex) {
        return ArrayUtil.indexOf(array, arrayToFind, startIndex, 0.0);
    }

    public static int indexOf(double[] array, double[] arrayToFind, int startIndex, double tolerance) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        double firstMin = arrayToFind[0] - tolerance;
        double firstMax = arrayToFind[0] + tolerance;
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && (array[i] < firstMin || array[i] > firstMax)) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                int n = j++;
                int n2 = k++;
                if (!(Math.abs(array[n] - arrayToFind[n2]) > tolerance)) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int lastIndexOf(double[] array, double doubleToFind) {
        return ArrayUtil.lastIndexOf(array, doubleToFind, Integer.MAX_VALUE, 0.0);
    }

    public static int lastIndexOf(double[] array, double doubleToFind, double tolerance) {
        return ArrayUtil.lastIndexOf(array, doubleToFind, Integer.MAX_VALUE, tolerance);
    }

    public static int lastIndexOf(double[] array, double[] arrayToFind) {
        return ArrayUtil.lastIndexOf(array, arrayToFind, Integer.MAX_VALUE, 0.0);
    }

    public static int lastIndexOf(double[] array, double[] arrayToFind, double tolerance) {
        return ArrayUtil.lastIndexOf(array, arrayToFind, Integer.MAX_VALUE, tolerance);
    }

    public static int lastIndexOf(double[] array, double doubleToFind, int startIndex) {
        return ArrayUtil.lastIndexOf(array, doubleToFind, startIndex, 0.0);
    }

    public static int lastIndexOf(double[] array, double doubleToFind, int startIndex, double tolerance) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        double min = doubleToFind - tolerance;
        double max = doubleToFind + tolerance;
        int i = startIndex;
        while (i >= 0) {
            if (array[i] >= min && array[i] <= max) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double[] arrayToFind, int startIndex) {
        return ArrayUtil.lastIndexOf(array, arrayToFind, startIndex, 0.0);
    }

    public static int lastIndexOf(double[] array, double[] arrayToFind, int startIndex, double tolerance) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        double lastMin = arrayToFind[lastIndex] - tolerance;
        double lastMax = arrayToFind[lastIndex] + tolerance;
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && (array[i] < lastMin || array[i] > lastMax)) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                int n = j--;
                int n2 = k--;
                if (!(Math.abs(array[n] - arrayToFind[n2]) > tolerance)) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean contains(double[] array, double doubleToFind) {
        return ArrayUtil.indexOf(array, doubleToFind) != -1;
    }

    public static boolean contains(double[] array, double doubleToFind, double tolerance) {
        return ArrayUtil.indexOf(array, doubleToFind, tolerance) != -1;
    }

    public static boolean contains(double[] array, double[] arrayToFind) {
        return ArrayUtil.indexOf(array, arrayToFind) != -1;
    }

    public static boolean contains(double[] array, double[] arrayToFind, double tolerance) {
        return ArrayUtil.indexOf(array, arrayToFind, tolerance) != -1;
    }

    public static int indexOf(float[] array, float floatToFind) {
        return ArrayUtil.indexOf(array, floatToFind, 0, 0.0f);
    }

    public static int indexOf(float[] array, float floatToFind, float tolerance) {
        return ArrayUtil.indexOf(array, floatToFind, 0, tolerance);
    }

    public static int indexOf(float[] array, float[] arrayToFind) {
        return ArrayUtil.indexOf(array, arrayToFind, 0, 0.0f);
    }

    public static int indexOf(float[] array, float[] arrayToFind, float tolerance) {
        return ArrayUtil.indexOf(array, arrayToFind, 0, tolerance);
    }

    public static int indexOf(float[] array, float floatToFind, int startIndex) {
        return ArrayUtil.indexOf(array, floatToFind, startIndex, 0.0f);
    }

    public static int indexOf(float[] array, float floatToFind, int startIndex, float tolerance) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        float min = floatToFind - tolerance;
        float max = floatToFind + tolerance;
        int i = startIndex;
        while (i < array.length) {
            if (array[i] >= min && array[i] <= max) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(float[] array, float[] arrayToFind, int startIndex) {
        return ArrayUtil.indexOf(array, arrayToFind, startIndex, 0.0f);
    }

    public static int indexOf(float[] array, float[] arrayToFind, int startIndex, float tolerance) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        float firstMin = arrayToFind[0] - tolerance;
        float firstMax = arrayToFind[0] + tolerance;
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && (array[i] < firstMin || array[i] > firstMax)) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                int n = j++;
                int n2 = k++;
                if (!(Math.abs(array[n] - arrayToFind[n2]) > tolerance)) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int lastIndexOf(float[] array, float floatToFind) {
        return ArrayUtil.lastIndexOf(array, floatToFind, Integer.MAX_VALUE, 0.0f);
    }

    public static int lastIndexOf(float[] array, float floatToFind, float tolerance) {
        return ArrayUtil.lastIndexOf(array, floatToFind, Integer.MAX_VALUE, tolerance);
    }

    public static int lastIndexOf(float[] array, float[] arrayToFind) {
        return ArrayUtil.lastIndexOf(array, arrayToFind, Integer.MAX_VALUE, 0.0f);
    }

    public static int lastIndexOf(float[] array, float[] arrayToFind, float tolerance) {
        return ArrayUtil.lastIndexOf(array, arrayToFind, Integer.MAX_VALUE, tolerance);
    }

    public static int lastIndexOf(float[] array, float floatToFind, int startIndex) {
        return ArrayUtil.lastIndexOf(array, floatToFind, startIndex, 0.0f);
    }

    public static int lastIndexOf(float[] array, float floatToFind, int startIndex, float tolerance) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        float min = floatToFind - tolerance;
        float max = floatToFind + tolerance;
        int i = startIndex;
        while (i >= 0) {
            if (array[i] >= min && array[i] <= max) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int lastIndexOf(float[] array, float[] arrayToFind, int startIndex) {
        return ArrayUtil.lastIndexOf(array, arrayToFind, startIndex, 0.0f);
    }

    public static int lastIndexOf(float[] array, float[] arrayToFind, int startIndex, float tolerance) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        float lastMin = arrayToFind[lastIndex] - tolerance;
        float lastMax = arrayToFind[lastIndex] + tolerance;
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && (array[i] < lastMin || array[i] > lastMax)) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                int n = j--;
                int n2 = k--;
                if (!(Math.abs(array[n] - arrayToFind[n2]) > tolerance)) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean contains(float[] array, float floatToFind) {
        return ArrayUtil.indexOf(array, floatToFind) != -1;
    }

    public static boolean contains(float[] array, float floatToFind, float tolerance) {
        return ArrayUtil.indexOf(array, floatToFind, tolerance) != -1;
    }

    public static boolean contains(float[] array, float[] arrayToFind) {
        return ArrayUtil.indexOf(array, arrayToFind) != -1;
    }

    public static boolean contains(float[] array, float[] arrayToFind, float tolerance) {
        return ArrayUtil.indexOf(array, arrayToFind, tolerance) != -1;
    }

    public static int indexOf(boolean[] array, boolean booleanToFind) {
        return ArrayUtil.indexOf(array, booleanToFind, 0);
    }

    public static int indexOf(boolean[] array, boolean[] arrayToFind) {
        return ArrayUtil.indexOf(array, arrayToFind, 0);
    }

    public static int indexOf(boolean[] array, boolean booleanToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        int i = startIndex;
        while (i < array.length) {
            if (booleanToFind == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(boolean[] array, boolean[] arrayToFind, int startIndex) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        boolean first = arrayToFind[0];
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && array[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                if (array[j++] == arrayToFind[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int lastIndexOf(boolean[] array, boolean booleanToFind) {
        return ArrayUtil.lastIndexOf(array, booleanToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(boolean[] array, boolean[] arrayToFind) {
        return ArrayUtil.lastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(boolean[] array, boolean booleanToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        int i = startIndex;
        while (i >= 0) {
            if (booleanToFind == array[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] array, boolean[] arrayToFind, int startIndex) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        boolean last = arrayToFind[lastIndex];
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && array[i] != last) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                if (array[j--] == arrayToFind[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean contains(boolean[] array, boolean booleanToFind) {
        return ArrayUtil.indexOf(array, booleanToFind) != -1;
    }

    public static boolean contains(boolean[] array, boolean[] arrayToFind) {
        return ArrayUtil.indexOf(array, arrayToFind) != -1;
    }

    public static int indexOf(char[] array, char charToFind) {
        return ArrayUtil.indexOf(array, charToFind, 0);
    }

    public static int indexOf(char[] array, char[] arrayToFind) {
        return ArrayUtil.indexOf(array, arrayToFind, 0);
    }

    public static int indexOf(char[] array, char charToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        int i = startIndex;
        while (i < array.length) {
            if (charToFind == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(char[] array, char[] arrayToFind, int startIndex) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        char first = arrayToFind[0];
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && array[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                if (array[j++] == arrayToFind[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int lastIndexOf(char[] array, char charToFind) {
        return ArrayUtil.lastIndexOf(array, charToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(char[] array, char[] arrayToFind) {
        return ArrayUtil.lastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(char[] array, char charToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        int i = startIndex;
        while (i >= 0) {
            if (charToFind == array[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char[] arrayToFind, int startIndex) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        char last = arrayToFind[lastIndex];
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && array[i] != last) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                if (array[j--] == arrayToFind[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean contains(char[] array, char charToFind) {
        return ArrayUtil.indexOf(array, charToFind) != -1;
    }

    public static boolean contains(char[] array, char[] arrayToFind) {
        return ArrayUtil.indexOf(array, arrayToFind) != -1;
    }
}

