/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.encrypt.util;

import com.hundsun.encrypt.util.Base64;
import com.hundsun.encrypt.util.RSA;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Random;

public class KeyManage {
    public void createKey(String rsaPubKeyFile, String rsaPrvKeyFile) throws Exception {
        byte[] priKey = null;
        byte[] pubKey = null;
        SecureRandom sr = new SecureRandom();
        KeyPairGenerator kg = KeyPairGenerator.getInstance("RSA");
        kg.initialize(1024, sr);
        KeyPair keys = kg.generateKeyPair();
        PublicKey pubkey = keys.getPublic();
        PrivateKey prikey = keys.getPrivate();
        pubKey = Base64.encodeToByte(pubkey.getEncoded());
        priKey = Base64.encodeToByte(prikey.getEncoded());
        FileOutputStream fos = new FileOutputStream(rsaPrvKeyFile);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(prikey);
        oos.close();
        fos.close();
        FileOutputStream fos2 = new FileOutputStream(rsaPubKeyFile);
        ObjectOutputStream oos2 = new ObjectOutputStream(fos2);
        oos2.writeObject(pubkey);
        oos2.close();
        fos2.close();
    }

    public byte[] encode3Des(byte[] encryptText, String rsaPubKeyFile) throws Exception {
        RSA encrypt = new RSA();
        byte[] e = encrypt.encrypt(rsaPubKeyFile, encryptText);
        return e;
    }

    public byte[] decode3Des(byte[] pass, String rsaPrvKeyFile) throws Exception {
        RSA encrypt = new RSA();
        byte[] de = encrypt.decrypt(rsaPrvKeyFile, pass);
        return de;
    }

    public String signatrue(String filePath) throws Exception {
        FileInputStream fin = new FileInputStream(filePath);
        int length = fin.available();
        byte[] bt = new byte[length];
        fin.read(bt);
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(bt);
        String str = new String(Base64.encodeToByte(messageDigest.digest())).toUpperCase();
        return str;
    }

    public String random(int length) {
        String randstr = "";
        Random sr = new Random();
        byte[] b = new byte[length + 10];
        sr.nextBytes(b);
        randstr = Base64.encodeToString(b);
        randstr = randstr.substring(0, length);
        return randstr;
    }

    public static void main(String[] args) {
        KeyManage ke = new KeyManage();
        try {
            System.out.println("/************\u63d0\u53d6\u6458\u8981\u901a\u8fc7RSA\u52a0\u5bc6*******************/");
            String keystr = ke.signatrue("D:/abc/20080922_key.zip");
            System.out.println("\u63d0\u6458\ufffd?===" + keystr);
            RSA rsa = new RSA();
            byte[] sha = rsa.encrypt("d:/abc/pub.dat", keystr.getBytes());
            System.out.println("\u52a0\u5bc6sha====" + new String(sha));
            byte[] sha_f = rsa.decrypt("d:/abc/priv.dat", sha);
            System.out.println("\u89e3\u5bc6sha====" + new String(sha_f));
            String s = "123456" + ke.random(18);
            byte[] bt = ke.encode3Des(s.getBytes(), "d:/abc/pub.dat");
            System.out.println("\u8f93\u524ddes:====" + new String(bt));
            String strtemp = Base64.encodeToString(bt);
            System.out.println("\u8f93\u5165des:====" + strtemp);
            System.out.println("\u8f93\u51fades:====" + new String(Base64.decode(strtemp.getBytes())));
            byte[] aa = ke.decode3Des(bt, "d:/abc/priv.dat");
            System.out.println(new String(aa));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

