/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.encrypt.util;

import com.hundsun.encrypt.util.Base64;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;

public class RSA {
    public String bytesToString(byte[] encrytpByte) {
        String result = "";
        int i = 0;
        while (i < encrytpByte.length) {
            Byte bytes = new Byte(encrytpByte[i]);
            result = String.valueOf(result) + (char)bytes.intValue();
            ++i;
        }
        return result;
    }

    public byte[] encrypt(RSAPublicKey publicKey, byte[] obj) {
        if (publicKey != null) {
            try {
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(1, publicKey);
                return cipher.doFinal(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public byte[] encrypt(String publicPath, byte[] obj) {
        try {
            FileInputStream fin2 = new FileInputStream(publicPath);
            ObjectInputStream oin2 = new ObjectInputStream(fin2);
            RSAPublicKey publicKey = (RSAPublicKey)oin2.readObject();
            fin2.close();
            oin2.close();
            if (publicKey != null) {
                try {
                    Cipher cipher = Cipher.getInstance("RSA");
                    cipher.init(1, publicKey);
                    return cipher.doFinal(obj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public byte[] decrypt(RSAPrivateKey privateKey, byte[] obj) {
        if (privateKey != null) {
            try {
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(2, privateKey);
                return cipher.doFinal(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public byte[] decrypt(String privatePath, byte[] obj) {
        try {
            FileInputStream fin = new FileInputStream(privatePath);
            ObjectInputStream oin = new ObjectInputStream(fin);
            RSAPrivateKey privateKey = (RSAPrivateKey)oin.readObject();
            fin.close();
            oin.close();
            if (privateKey != null) {
                try {
                    Cipher cipher = Cipher.getInstance("RSA");
                    cipher.init(2, privateKey);
                    return cipher.doFinal(obj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void createKey(String pubKeyFile, String privKeyFile) {
        try {
            SecureRandom sr = new SecureRandom();
            KeyPairGenerator kg = KeyPairGenerator.getInstance("RSA");
            kg.initialize(1024, sr);
            KeyPair keys = kg.generateKeyPair();
            PublicKey pubkey = keys.getPublic();
            PrivateKey prikey = keys.getPrivate();
            byte[] pubKey = Base64.encodeToByte(pubkey.getEncoded());
            byte[] priKey = Base64.encodeToByte(prikey.getEncoded());
            FileOutputStream fos = new FileOutputStream(privKeyFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(prikey);
            oos.close();
            fos.close();
            FileOutputStream fos2 = new FileOutputStream(pubKeyFile);
            ObjectOutputStream oos2 = new ObjectOutputStream(fos2);
            oos2.writeObject(pubkey);
            oos2.close();
            fos2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            RSA encrypt = new RSA();
            String encryptText = "12345678-765432112345678";
            FileInputStream fin = new FileInputStream("D:/file/batch_key_rsa/00000010/priv.bat");
            ObjectInputStream oin = new ObjectInputStream(fin);
            RSAPrivateKey privateKey = (RSAPrivateKey)oin.readObject();
            fin.close();
            FileInputStream fin2 = new FileInputStream("D:/file/batch_key_rsa/00000010/pub.bat");
            ObjectInputStream oin2 = new ObjectInputStream(fin2);
            RSAPublicKey publicKey = (RSAPublicKey)oin2.readObject();
            fin2.close();
            byte[] e = encrypt.encrypt(publicKey, encryptText.getBytes());
            byte[] de = encrypt.decrypt(privateKey, e);
            System.out.println(encrypt.bytesToString(e));
            System.out.println(encrypt.bytesToString(de));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

