/*
 * Decompiled with CFR 0.152.
 */
package com.cunnar;

import com.cunnar.exception.CunnarConfigException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class CunnarConfig {
    public static final String APP_KEY = "app.id";
    public static final String APP_SECRET = "app.secret";
    public static final String URL = "url";
    private static final String IDLE_CONNECT_MANAGER = "idle.manager";
    private static Properties props = new Properties();

    public static String getValue(String key) {
        String property = props.getProperty(key);
        if (property == null) {
            throw new CunnarConfigException();
        }
        return property;
    }

    public static boolean isIdleConnectManager() {
        String property = props.getProperty(IDLE_CONNECT_MANAGER);
        if (property == null) {
            return true;
        }
        try {
            return Boolean.valueOf(property);
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void updateProperties(String key, String value) {
        props.setProperty(key, value);
    }

    static {
        try {
            props.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("cunnar.properties"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

