/*
 * Decompiled with CFR 0.152.
 */
package com.cunnar.module;

import com.cunnar.CunnarConfig;
import com.cunnar.domain.AccessToken;
import com.cunnar.domain.AccountExist;
import com.cunnar.domain.CommonProperties;
import com.cunnar.domain.UserAuthResult;
import com.cunnar.domain.UserInfo;
import com.cunnar.exception.AccessTokenExpiredException;
import com.cunnar.exception.ErrorResult;
import com.cunnar.exception.ErrorResultException;
import com.cunnar.util.HttpResponseCallBack;
import com.cunnar.util.HttpUtil;
import com.cunnar.util.JsonUtil;
import com.cunnar.util.OpenCloudUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;

public class Account {
    private static final Log log = LogFactory.getLog(Account.class);

    public static AccountExist isAccountExistByPhone(String phone) throws ErrorResultException {
        return Account.isAccountExist(phone, true, false, false);
    }

    public static AccountExist isAccountExistByEmail(String email) throws ErrorResultException {
        return Account.isAccountExist(email, false, true, false);
    }

    public static AccountExist isAccountExistById(String id) throws ErrorResultException {
        return Account.isAccountExist(id, false, false, true);
    }

    private static AccountExist isAccountExist(String args, boolean isPhone, boolean isEmail, boolean isOutId) throws ErrorResultException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (isPhone) {
            params.put("phone", args);
        }
        if (isEmail) {
            params.put("email", args);
        }
        if (isOutId) {
            params.put("out_id", args);
        }
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        params.put("sign_type", "MD5");
        return HttpUtil.get(url + "/opencloud/api/account/exist.json", params, null, new HttpResponseCallBack<AccountExist>(){

            @Override
            public AccountExist doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                return JsonUtil.toObject(inputStream, AccountExist.class);
            }
        });
    }

    public static String createAccountByPhone(String phone) throws ErrorResultException {
        return Account.createAccount(phone, null, null);
    }

    public static String createAccountByEmail(String email) throws ErrorResultException {
        return Account.createAccount(null, email, null);
    }

    public static String createAccountById(String id) throws ErrorResultException {
        return Account.createAccount(null, null, id);
    }

    public static String getUserIdByPhone(String phone) throws ErrorResultException {
        return Account.getUserId(phone, null, null);
    }

    public static String getUserIdByEmail(String email) throws ErrorResultException {
        return Account.getUserId(null, email, null);
    }

    public static String getUserIdById(String id) throws ErrorResultException {
        return Account.getUserId(null, null, id);
    }

    private static String getUserId(String phone, String email, String id) throws ErrorResultException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("phone", phone);
        params.put("email", email);
        params.put("out_id", id);
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        params.put("sign_type", "MD5");
        return HttpUtil.get(url + "/opencloud/api/account/get_key.json", params, null, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                return JsonUtil.toObject(inputStream, CommonProperties.class).getUserId();
            }
        });
    }

    private static String createAccount(String phone, String email, String id) throws ErrorResultException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("phone", phone);
        params.put("email", email);
        params.put("out_id", id);
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        params.put("sign_type", "MD5");
        return HttpUtil.post(url + "/opencloud/api/account/create.json", params, null, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                return properties.getUserId();
            }
        });
    }

    public static boolean userVerify(AccessToken accessToken, UserInfo userInfo) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("real_name", userInfo.getRealName());
        params.put("card", userInfo.getCard());
        params.put("bank", userInfo.getBank());
        params.put("phone", userInfo.getPhone());
        params.put("type", userInfo.getAuthType());
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        params.put("sign_type", "MD5");
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/verify.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    return false;
                }
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                return properties.isVerify();
            }
        });
    }

    public static UserAuthResult userBankVerify(AccessToken accessToken, UserInfo userInfo) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("real_name", userInfo.getRealName());
        params.put("card", userInfo.getCard());
        params.put("bank", userInfo.getBank());
        params.put("phone", userInfo.getPhone());
        params.put("type", userInfo.getAuthType());
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        params.put("sign_type", "MD5");
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/verify.json", params, token, new HttpResponseCallBack<UserAuthResult>(){

            @Override
            public UserAuthResult doResponse(HttpResponse response) throws IOException, ErrorResultException {
                UserAuthResult authResult = new UserAuthResult();
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    authResult.setResult(false);
                    return authResult;
                }
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                authResult.setResult(properties.isVerify());
                authResult.setMsg(properties.getVerifyMsg());
                authResult.setStatcode(properties.getVerifyStatecode());
                return authResult;
            }
        });
    }

    public static boolean enterpriseVerifyCode(AccessToken accessToken, UserInfo userInfo) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("real_name", userInfo.getRealName());
        params.put("code", userInfo.getCode());
        params.put("account_name", userInfo.getAccountName());
        params.put("account_no", userInfo.getAccountNo());
        params.put("bank", userInfo.getBank());
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        params.put("sign_type", "MD5");
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/enterprise_verify_code.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    return false;
                }
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                return properties.isVerifyInfo();
            }
        });
    }

    public static UserAuthResult enterpriseBankVerifyCode(AccessToken accessToken, UserInfo userInfo) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("real_name", userInfo.getRealName());
        params.put("code", userInfo.getCode());
        params.put("account_name", userInfo.getAccountName());
        params.put("account_no", userInfo.getAccountNo());
        params.put("bank", userInfo.getBank());
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        params.put("sign_type", "MD5");
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/enterprise_verify_code.json", params, token, new HttpResponseCallBack<UserAuthResult>(){

            @Override
            public UserAuthResult doResponse(HttpResponse response) throws IOException, ErrorResultException {
                UserAuthResult authResult = new UserAuthResult();
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    authResult.setResult(false);
                    return authResult;
                }
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                authResult.setResult(properties.isVerifyInfo());
                authResult.setMsg(properties.getVerifyMsg());
                authResult.setStatcode(properties.getVerifyStatecode());
                return authResult;
            }
        });
    }

    public static boolean enterpriseVerify(AccessToken accessToken, UserInfo userInfo) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("account_name", userInfo.getAccountName());
        params.put("account_no", userInfo.getAccountNo());
        params.put("money", userInfo.getMoney());
        params.put("verify_code", userInfo.getVerifyCode());
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        params.put("sign_type", "MD5");
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/enterprise_verify.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    return false;
                }
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                return properties.isVerify();
            }
        });
    }

    public static boolean isVerifyPass(AccessToken accessToken) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.get(url + "/opencloud/api/account/verify.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    return false;
                }
                return JsonUtil.toObject(inputStream, CommonProperties.class).isVerify();
            }
        });
    }

    public static boolean userCardVerify(AccessToken accessToken, UserInfo userInfo) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("real_name", userInfo.getRealName());
        params.put("card", userInfo.getCard());
        params.put("type", userInfo.getAuthType());
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        params.put("sign_type", "MD5");
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/card_verify.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    return false;
                }
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                return properties.isVerify();
            }
        });
    }

    public static UserAuthResult userCardAuth(AccessToken accessToken, UserInfo userInfo) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("real_name", userInfo.getRealName());
        params.put("card", userInfo.getCard());
        params.put("type", userInfo.getAuthType());
        String url = CunnarConfig.getValue("url");
        String clientId = CunnarConfig.getValue("app.id");
        String clientSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", clientId);
        params.put("sign", OpenCloudUtil.buildSign(params, clientSecret));
        params.put("sign_type", "MD5");
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/card_verify.json", params, token, new HttpResponseCallBack<UserAuthResult>(){

            @Override
            public UserAuthResult doResponse(HttpResponse response) throws IOException, ErrorResultException {
                UserAuthResult authResult = new UserAuthResult();
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    authResult.setResult(false);
                    return authResult;
                }
                CommonProperties properties = JsonUtil.toObject(inputStream, CommonProperties.class);
                authResult.setResult(properties.isVerify());
                authResult.setMsg(properties.getVerifyMsg());
                authResult.setStatcode(properties.getVerifyStatecode());
                return authResult;
            }
        });
    }
}

