/*
 * Decompiled with CFR 0.152.
 */
package com.cunnar.module;

import com.cunnar.CunnarConfig;
import com.cunnar.domain.AccessToken;
import com.cunnar.domain.CommonProperties;
import com.cunnar.domain.FileInfo;
import com.cunnar.domain.FileQueryParam;
import com.cunnar.domain.FileStream;
import com.cunnar.domain.InputStreamCallBack;
import com.cunnar.exception.AccessTokenExpiredException;
import com.cunnar.exception.ErrorResult;
import com.cunnar.exception.ErrorResultException;
import com.cunnar.util.HttpResponseCallBack;
import com.cunnar.util.HttpUtil;
import com.cunnar.util.JsonUtil;
import com.cunnar.util.OpenCloudUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

public class File {
    private static final Log log = LogFactory.getLog(File.class);

    public static String create(AccessToken accessToken, FileInfo fileInfo) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        File.populateParams(fileInfo, params);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/file/create.json", params, token, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                return JsonUtil.toObject(inputStream, CommonProperties.class).getFileId();
            }
        });
    }

    private static void populateParams(FileInfo fileInfo, HashMap<String, String> params) {
        long timeLength;
        long endTime;
        long startTime;
        long loadTime;
        params.put("id", fileInfo.getId());
        params.put("name", fileInfo.getName());
        params.put("length", String.valueOf(fileInfo.getLength()));
        params.put("hash", fileInfo.getShaHex());
        params.put("label", fileInfo.getLabel());
        long fileCreateTime = fileInfo.getFileCreateTime();
        if (fileCreateTime != 0L) {
            params.put("file_create_time", String.valueOf(fileCreateTime));
        }
        if (fileInfo.getComment() != null) {
            params.put("comment", fileInfo.getComment());
        }
        if ((loadTime = fileInfo.getLoadTime()) != 0L) {
            params.put("load_time", String.valueOf(loadTime));
        }
        if (fileInfo.getUrl() != null) {
            params.put("url", fileInfo.getUrl());
        }
        if (fileInfo.getDestIp() != null) {
            params.put("dest_ip", fileInfo.getDestIp());
        }
        if (fileInfo.getSrcIp() != null) {
            params.put("src_ip", fileInfo.getSrcIp());
        }
        if (fileInfo.getTracert() != null) {
            params.put("tracert", fileInfo.getTracert());
        }
        if (fileInfo.getHosts() != null) {
            params.put("hosts", fileInfo.getHosts());
        }
        if (fileInfo.getCaller() != null) {
            params.put("caller", fileInfo.getCaller());
        }
        if (fileInfo.getCalled() != null) {
            params.put("called", fileInfo.getCalled());
        }
        if ((startTime = fileInfo.getStartTime()) != 0L) {
            params.put("start_time", String.valueOf(startTime));
        }
        if ((endTime = fileInfo.getEndTime()) != 0L) {
            params.put("end_time", String.valueOf(endTime));
        }
        if ((timeLength = fileInfo.getTimeLength()) != 0L) {
            params.put("time_length", String.valueOf(timeLength));
        }
        if (fileInfo.getHashType() != 0L) {
            params.put("hash_type", String.valueOf(fileInfo.getHashType()));
        }
        if (fileInfo.getUserName() != null) {
            params.put("user_name", fileInfo.getUserName());
        }
    }

    public static String createHash(AccessToken accessToken, FileInfo fileInfo) throws ErrorResultException {
        long fileCreateTime;
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", fileInfo.getName());
        params.put("length", String.valueOf(fileInfo.getLength()));
        params.put("hash", fileInfo.getShaHex());
        if (fileInfo.getUserName() != null) {
            params.put("user_name", fileInfo.getUserName());
        }
        if ((fileCreateTime = fileInfo.getFileCreateTime()) != 0L) {
            params.put("file_create_time", String.valueOf(fileCreateTime));
        }
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/filehash/create.json", params, token, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                return JsonUtil.toObject(inputStream, CommonProperties.class).getFileHashId();
            }
        });
    }

    public static Boolean existHash(AccessToken accessToken, String hash) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("hash", hash);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.get(url + "/opencloud/api/account/filehash/exist.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                return JsonUtil.toObject(inputStream, CommonProperties.class).isHashExist();
            }
        });
    }

    public static String create(FileInfo fileInfo) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appKey);
        params.put("sign_type", "MD5");
        File.populateParams(fileInfo, params);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.post(url + "/opencloud/api/file/create.json", params, null, new HttpResponseCallBack<String>(){

            @Override
            public String doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                return JsonUtil.toObject(inputStream, CommonProperties.class).getFileId();
            }
        });
    }

    public static long uploadStream(AccessToken accessToken, String fileId, long index, InputStream inputStream) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("file_id", fileId);
        params.put("index", String.valueOf(index));
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.postStream(url + "/opencloud/api/account/file/upload.json", inputStream, params, token, new HttpResponseCallBack<Long>(){

            @Override
            public Long doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                return JsonUtil.toObject(inputStream, CommonProperties.class).getUploadLength();
            }
        });
    }

    public static long uploadStream(String fileId, long index, InputStream inputStream) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", "MD5");
        params.put("file_id", fileId);
        params.put("index", String.valueOf(index));
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.postStream(url + "/opencloud/api/file/upload.json", inputStream, params, null, new HttpResponseCallBack<Long>(){

            @Override
            public Long doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                return JsonUtil.toObject(inputStream, CommonProperties.class).getUploadLength();
            }
        });
    }

    public static long getFileUploadLength(AccessToken accessToken, String fileId) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("file_id", fileId);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.get(url + "/opencloud/api/account/file/length.json", params, token, new HttpResponseCallBack<Long>(){

            @Override
            public Long doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                return JsonUtil.toObject(inputStream, CommonProperties.class).getUploadLength();
            }
        });
    }

    public static long getFileUploadLength(String fileId) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", "MD5");
        params.put("file_id", fileId);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.get(url + "/opencloud/api/file/length.json", params, null, new HttpResponseCallBack<Long>(){

            @Override
            public Long doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                return JsonUtil.toObject(inputStream, CommonProperties.class).getUploadLength();
            }
        });
    }

    public static FileInfo getFileInfo(AccessToken accessToken, String fileId) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("file_id", fileId);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.get(url + "/opencloud/api/account/file/info.json", params, token, new HttpResponseCallBack<FileInfo>(){

            @Override
            public FileInfo doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                return JsonUtil.toObject(inputStream, FileInfo.class);
            }
        });
    }

    public static FileInfo getFileInfo(String fileId) throws ErrorResultException {
        HashMap<String, String> params = new HashMap<String, String>();
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", "MD5");
        params.put("file_id", fileId);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.get(url + "/opencloud/api/file/info.json", params, null, new HttpResponseCallBack<FileInfo>(){

            @Override
            public FileInfo doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                return JsonUtil.toObject(inputStream, FileInfo.class);
            }
        });
    }

    public static List<FileInfo> queryFile(AccessToken accessToken, FileQueryParam param) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("since_id", param.getSinceId());
        params.put("max_id", param.getMaxId());
        params.put("count", String.valueOf(param.getCount()));
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.get(url + "/opencloud/api/account/file/query.json", params, token, new HttpResponseCallBack<List<FileInfo>>(){

            @Override
            public List<FileInfo> doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                return JsonUtil.toObject(inputStream, CommonProperties.class).getFiles();
            }
        });
    }

    public static List<FileInfo> queryFile(FileQueryParam param) throws ErrorResultException {
        HashMap<String, String> params = new HashMap<String, String>();
        String url = CunnarConfig.getValue("url");
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", "MD5");
        params.put("since_id", param.getSinceId());
        params.put("max_id", param.getMaxId());
        params.put("count", String.valueOf(param.getCount()));
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        return HttpUtil.get(url + "/opencloud/api/file/query.json", params, null, new HttpResponseCallBack<List<FileInfo>>(){

            @Override
            public List<FileInfo> doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                return JsonUtil.toObject(inputStream, CommonProperties.class).getFiles();
            }
        });
    }

    public static void downloadFile(AccessToken accessToken, final String fileId, final InputStreamCallBack inputStreamCallBack) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("file_id", fileId);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        HttpUtil.get(url + "/opencloud/api/account/file/download.json", params, token, new HttpResponseCallBack<Object>(){

            @Override
            public Object doResponse(HttpResponse response) throws IOException, ErrorResultException {
                HttpEntity entity = response.getEntity();
                InputStream inputStream = entity.getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                FileStream fileStream = new FileStream();
                fileStream.setFileId(fileId);
                String name = response.getLastHeader("Content-Disposition").getValue();
                fileStream.setName(OpenCloudUtil.translateFileName(name));
                fileStream.setContentLength(entity.getContentLength());
                fileStream.setContentRange(response.getLastHeader("Content-Range").getValue());
                fileStream.setInputStream(inputStream);
                inputStreamCallBack.doInputStream(fileStream);
                return null;
            }
        });
    }

    public static void downloadFile(final String fileId, final InputStreamCallBack inputStreamCallBack) throws ErrorResultException {
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        params.put("app_key", appKey);
        params.put("sign_type", "MD5");
        params.put("file_id", fileId);
        params.put("sign", OpenCloudUtil.buildSign(params, appSecret));
        HttpUtil.get(url + "/opencloud/api/file/download.json", params, null, new HttpResponseCallBack<Object>(){

            @Override
            public Object doResponse(HttpResponse response) throws IOException, ErrorResultException {
                HttpEntity entity = response.getEntity();
                InputStream inputStream = entity.getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                FileStream fileStream = new FileStream();
                fileStream.setFileId(fileId);
                String name = response.getLastHeader("Content-Disposition").getValue();
                fileStream.setName(name.replaceAll("attachment;filename=", ""));
                fileStream.setContentLength(entity.getContentLength());
                fileStream.setContentRange(response.getLastHeader("Content-Range").getValue());
                fileStream.setInputStream(inputStream);
                inputStreamCallBack.doInputStream(fileStream);
                return null;
            }
        });
    }

    public static String getFileCertify(AccessToken accessToken) {
        return File.getFileCertify(accessToken, null, -1);
    }

    public static String getFileCertify(AccessToken accessToken, String fileIds, int certifyType) {
        return File.getFileCertify(accessToken, fileIds, certifyType, 1);
    }

    public static String getFileCertify(AccessToken accessToken, String fileIds, int certifyType, int accountType) {
        return File.getFileCertify(accessToken, fileIds, certifyType, accountType, null, null);
    }

    public static String getFileCertify(AccessToken accessToken, String fileIds, int type, int accountType, String notifyUrl, String extraParam) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (fileIds != null && type != -1) {
            map.put("file_ids", fileIds);
            map.put("type", type);
            if (notifyUrl != null) {
                map.put("notify_url", notifyUrl);
                map.put("extra_param", extraParam);
            }
        }
        if (accountType != 1) {
            map.put("account_type", accountType);
        }
        return File.populateViewUrl(accessToken, map, "/opencloud/api/account/hcertify");
    }

    public static String getPdfView(AccessToken accessToken, String fileId) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("file_id", fileId);
        return File.populateViewUrl(accessToken, map, "/opencloud/api/account/hpdf");
    }

    public static String getReceiptView(AccessToken accessToken, String fileId) {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("file_id", fileId);
        return File.populateViewUrl(accessToken, map, "/opencloud/api/account/hreceipt");
    }

    private static String populateViewUrl(AccessToken accessToken, Map<String, Object> param, String prefix) {
        String appKey = CunnarConfig.getValue("app.id");
        String appSecret = CunnarConfig.getValue("app.secret");
        StringBuilder builder = new StringBuilder(CunnarConfig.getValue("url"));
        String token = accessToken.getAccessToken();
        builder.append(prefix).append("?access_token=").append(token);
        long time = System.currentTimeMillis();
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            builder.append("&").append(key).append("=").append(value);
            params.put(key, value.toString());
        }
        builder.append("&t=").append(time);
        builder.append("&app_key=").append(appKey);
        String md5 = "MD5";
        builder.append("&sign_type=").append(md5);
        params.put("t", String.valueOf(time));
        params.put("access_token", token);
        params.put("app_key", appKey);
        params.put("sign_type", md5);
        builder.append("&sign=").append(OpenCloudUtil.buildSign(params, appSecret));
        return builder.toString();
    }

    public static void downloadFileReceipt(AccessToken accessToken, final String fileId, final InputStreamCallBack inputStreamCallBack) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("file_id", fileId);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        HttpUtil.get(url + "/opencloud/api/account/receipt/download.json", params, token, new HttpResponseCallBack<Object>(){

            @Override
            public Object doResponse(HttpResponse response) throws IOException, ErrorResultException {
                HttpEntity entity = response.getEntity();
                InputStream inputStream = entity.getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                FileStream fileStream = new FileStream();
                fileStream.setFileId(fileId);
                String name = response.getLastHeader("Content-Disposition").getValue();
                fileStream.setName(OpenCloudUtil.translateFileName(name));
                fileStream.setContentLength(entity.getContentLength());
                fileStream.setContentRange(response.getLastHeader("Content-Range").getValue());
                fileStream.setInputStream(inputStream);
                inputStreamCallBack.doInputStream(fileStream);
                return null;
            }
        });
    }
}

