/*
 * Decompiled with CFR 0.152.
 */
package com.cunnar.module;

import com.cunnar.CunnarConfig;
import com.cunnar.domain.AccessToken;
import com.cunnar.domain.CommonProperties;
import com.cunnar.domain.VoiceInfo;
import com.cunnar.domain.VoiceQueryParam;
import com.cunnar.exception.AccessTokenExpiredException;
import com.cunnar.exception.ErrorResult;
import com.cunnar.exception.ErrorResultException;
import com.cunnar.util.HttpResponseCallBack;
import com.cunnar.util.HttpUtil;
import com.cunnar.util.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

public class Voice {
    private static final Log log = LogFactory.getLog(Voice.class);

    public static Boolean voiceCall(AccessToken accessToken, String caller, String called) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("caller", caller);
        params.put("called", called);
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.post(url + "/opencloud/api/account/voice/call.json", params, token, new HttpResponseCallBack<Boolean>(){

            @Override
            public Boolean doResponse(HttpResponse response) throws IOException, ErrorResultException {
                HttpEntity entity = response.getEntity();
                InputStream inputStream = entity.getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                return JsonUtil.toObject(inputStream, CommonProperties.class).isVoiceCall();
            }
        });
    }

    public static List<VoiceInfo> queryVoice(AccessToken accessToken, VoiceQueryParam param) throws ErrorResultException {
        if (accessToken.isExpired()) {
            throw new AccessTokenExpiredException();
        }
        String url = CunnarConfig.getValue("url");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("since_id", param.getSinceId());
        params.put("max_id", param.getMaxId());
        params.put("count", String.valueOf(param.getCount()));
        HashMap<String, String> token = new HashMap<String, String>();
        token.put("Authorization", accessToken.getAuthorization());
        return HttpUtil.get(url + "/opencloud/api/account/voice/history.json", params, token, new HttpResponseCallBack<List<VoiceInfo>>(){

            @Override
            public List<VoiceInfo> doResponse(HttpResponse response) throws IOException, ErrorResultException {
                InputStream inputStream = response.getEntity().getContent();
                if (response.getStatusLine().getStatusCode() != 200) {
                    ErrorResult result = JsonUtil.toObject(inputStream, ErrorResult.class);
                    if (log.isErrorEnabled()) {
                        log.error((Object)result);
                    }
                    throw new ErrorResultException(result);
                }
                return JsonUtil.toObject(inputStream, CommonProperties.class).getVoices();
            }
        });
    }
}

