/*
 * Decompiled with CFR 0.152.
 */
package com.cunnar.util;

import com.cunnar.CunnarConfig;
import com.cunnar.util.HttpResponseCallBack;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static final Log log = LogFactory.getLog(HttpUtil.class);
    private static final HttpClient CLIENT;
    private static SSLSocketFactory FACTORY;

    public static <T> T post(String url, Map<String, String> params, HttpResponseCallBack<T> httpResponseCallBack) {
        return HttpUtil.post(url, params, null, httpResponseCallBack);
    }

    public static <T> T post(String url, Map<String, String> params, Map<String, String> headers, HttpResponseCallBack<T> httpResponseCallBack) {
        return HttpUtil.post(url, params, headers, null, httpResponseCallBack);
    }

    public static <T> T post(String url, Map<String, String> params, Map<String, String> headers, InputStream inputStream, HttpResponseCallBack<T> httpResponseCallBack) {
        Object entity;
        HttpUtil.registerHttps(url);
        HttpPost post = new HttpPost(url);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                post.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (inputStream != null) {
            if (params != null) {
                URIBuilder builder = null;
                try {
                    builder = new URIBuilder(url);
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        builder.addParameter(entry.getKey(), entry.getValue());
                    }
                    URI uri = builder.build();
                    post.setURI(uri);
                }
                catch (URISyntaxException e) {
                    log.error((Object)"http post url error", (Throwable)e);
                    return null;
                }
            }
            MultipartEntity entity2 = new MultipartEntity();
            entity2.addPart(new FormBodyPart("inputStream", (ContentBody)new InputStreamBody(inputStream, "inputStream")));
            post.setEntity((HttpEntity)entity2);
        } else if (params != null) {
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue());
                list.add(pair);
            }
            entity = new UrlEncodedFormEntity(list, Charset.forName("UTF-8"));
            post.setEntity(entity);
        }
        HttpResponse httpResponse = null;
        try {
            httpResponse = CLIENT.execute((HttpUriRequest)post);
            if (httpResponse != null) {
                entity = httpResponseCallBack.doResponse(httpResponse);
                return entity;
            }
        }
        catch (IOException e) {
            log.error((Object)"http post error", (Throwable)e);
            post.releaseConnection();
            throw new RuntimeException(e);
        }
        finally {
            if (httpResponse != null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            }
        }
        return null;
    }

    public static <T> T postStream(String url, InputStream inputStream, Map<String, String> params, Map<String, String> headers, HttpResponseCallBack<T> httpResponseCallBack) {
        block23: {
            HttpUtil.registerHttps(url);
            HttpPost post = new HttpPost(url);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    post.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (inputStream == null) {
                if (params != null) {
                    ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue());
                        list.add(pair);
                    }
                    UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list, Charset.forName("UTF-8"));
                    post.setEntity((HttpEntity)entity);
                }
            } else {
                if (params != null) {
                    URIBuilder builder = null;
                    try {
                        builder = new URIBuilder(url);
                        for (Map.Entry<String, String> entry : params.entrySet()) {
                            builder.addParameter(entry.getKey(), entry.getValue());
                        }
                        URI uri = builder.build();
                        post.setURI(uri);
                    }
                    catch (URISyntaxException e) {
                        log.error((Object)"http post url error", (Throwable)e);
                        return null;
                    }
                }
                post.setEntity((HttpEntity)new InputStreamEntity(inputStream, -1L));
            }
            HttpResponse httpResponse = null;
            try {
                httpResponse = CLIENT.execute((HttpUriRequest)post);
                if (httpResponse == null) break block23;
                T e = httpResponseCallBack.doResponse(httpResponse);
            }
            catch (IOException e) {
                log.error((Object)"http post error", (Throwable)e);
                post.releaseConnection();
                throw new RuntimeException(e);
            }
            finally {
                if (httpResponse != null) {
                    EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
            return e;
        }
        return null;
    }

    public static <T> T get(String url, HttpResponseCallBack<T> httpResponseCallBack) {
        return HttpUtil.get(url, null, null, httpResponseCallBack);
    }

    public static <T> T get(String url, Map<String, String> params, Map<String, String> headers, HttpResponseCallBack<T> httpResponseCallBack) {
        HttpUtil.registerHttps(url);
        HttpGet get = null;
        HttpResponse response = null;
        try {
            URIBuilder builder = new URIBuilder(url);
            if (params != null) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    builder.addParameter(entry.getKey(), entry.getValue());
                }
            }
            URI uri = builder.build();
            get = new HttpGet(uri);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    get.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((response = CLIENT.execute((HttpUriRequest)get)) != null) {
                T t = httpResponseCallBack.doResponse(response);
                return t;
            }
        }
        catch (URISyntaxException e) {
            log.error((Object)"http get url error", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"http get error", (Throwable)e);
            get.releaseConnection();
            throw new RuntimeException(e);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
        return null;
    }

    private static void registerHttps(String url) {
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            if ("https".equals(scheme)) {
                int port = uri.getPort();
                if (port == -1) {
                    port = 443;
                }
                CLIENT.getConnectionManager().getSchemeRegistry().register(new Scheme(scheme, port, (SchemeSocketFactory)FACTORY));
            }
        }
        catch (URISyntaxException e) {
            log.error((Object)("url:" + url), (Throwable)e);
        }
    }

    public static SSLSocketFactory getSSLSocketFactory() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }}, null);
        return new SSLSocketFactory(sslContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
    }

    static {
        try {
            FACTORY = HttpUtil.getSSLSocketFactory();
        }
        catch (Exception e) {
            FACTORY = null;
        }
        PoolingClientConnectionManager manager = new PoolingClientConnectionManager();
        manager.setMaxTotal(20000);
        manager.setDefaultMaxPerRoute(2000);
        BasicHttpParams params = new BasicHttpParams();
        params.setIntParameter("http.socket.timeout", 60000);
        params.setIntParameter("http.connection.timeout", 60000);
        CLIENT = new DefaultHttpClient((ClientConnectionManager)manager, (HttpParams)params);
        if (CunnarConfig.isIdleConnectManager()) {
            IdleConnectionMonitorThread thread = new IdleConnectionMonitorThread((ClientConnectionManager)manager);
            thread.setDaemon(true);
            thread.start();
        }
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final ClientConnectionManager connMgr;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(ClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(5000L);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

