/*
 * Decompiled with CFR 0.152.
 */
package com.cunnar.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;

public class JsonUtil {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String fromObject(Object object) {
        if (null == object) {
            return "";
        }
        StringWriter w = new StringWriter();
        try {
            OBJECT_MAPPER.writeValue((Writer)w, object);
        }
        catch (IOException e) {
            return null;
        }
        return w.toString();
    }

    public static <T> T toObject(InputStream inputStream, Class<T> tClass) {
        if (inputStream == null) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(inputStream, tClass);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static <T> List<T> toList(InputStream inputStream, Class<T> tClass) {
        if (inputStream == null) {
            return null;
        }
        try {
            TypeFactory factory = OBJECT_MAPPER.getTypeFactory();
            CollectionType type = factory.constructCollectionType(List.class, tClass);
            List list = (List)OBJECT_MAPPER.readValue(inputStream, (JavaType)type);
            return list == null ? Collections.emptyList() : list;
        }
        catch (IOException e) {
            return null;
        }
    }

    static {
        OBJECT_MAPPER.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

