/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.impl.client;

import ytx.org.apache.http.HeaderElement;
import ytx.org.apache.http.HttpResponse;
import ytx.org.apache.http.annotation.Immutable;
import ytx.org.apache.http.conn.ConnectionKeepAliveStrategy;
import ytx.org.apache.http.message.BasicHeaderElementIterator;
import ytx.org.apache.http.protocol.HttpContext;

@Immutable
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }
}

