/*
 * Decompiled with CFR 0.152.
 */
package com.zenjava.javafx.maven.plugin;

import com.sun.javafx.tools.packager.CreateJarParams;
import com.sun.javafx.tools.packager.PackagerException;
import com.zenjava.javafx.maven.plugin.AbstractJfxToolsMojo;
import com.zenjava.javafx.maven.plugin.JavaDetectionTools;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class JarMojo
extends AbstractJfxToolsMojo {
    protected boolean css2bin;
    protected String preLoader;
    protected boolean updateExistingJar;
    protected boolean allPermissions;
    protected boolean jfxCallFromCLI;
    protected Map<String, String> manifestAttributes;
    protected boolean addPackagerJar;
    protected List<Dependency> classpathExcludes = new ArrayList<Dependency>();
    protected boolean classpathExcludesTransient;
    protected File additionalAppResources;
    protected boolean copyAdditionalAppResourcesToJar = false;
    protected boolean skipCopyingDependencies = false;
    protected boolean useLibFolderContentForManifestClasspath = false;
    protected String fixedManifestClasspath = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.jfxCallFromCLI) {
            this.getLog().info((CharSequence)"call from CLI - skipping creation of JavaFX JAR for application");
            return;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution of JarMojo MOJO.");
            return;
        }
        this.getLog().info((CharSequence)"Building JavaFX JAR for application");
        Build build = this.project.getBuild();
        CreateJarParams createJarParams = new CreateJarParams();
        createJarParams.setOutdir(this.jfxAppOutputDir);
        if (!this.jfxMainAppJarName.toLowerCase().endsWith(".jar")) {
            this.getLog().error((CharSequence)"Please provide a proper value for <jfxMainAppJarName>! It has to end with \".jar\".");
            return;
        }
        createJarParams.setOutfile(this.jfxMainAppJarName);
        createJarParams.setApplicationClass(this.mainClass);
        createJarParams.setCss2bin(this.css2bin);
        createJarParams.setPreloader(this.preLoader);
        if (this.manifestAttributes == null) {
            this.manifestAttributes = new HashMap<String, String>();
        }
        createJarParams.setManifestAttrs(this.manifestAttributes);
        StringBuilder classpath = new StringBuilder();
        final File libDir = new File(this.jfxAppOutputDir, this.libFolderName);
        if (!libDir.exists() && !libDir.mkdirs()) {
            throw new MojoExecutionException("Unable to create app lib dir: " + libDir);
        }
        if (this.updateExistingJar) {
            File potentialExistingFile = new File(build.getDirectory() + File.separator + build.getFinalName() + ".jar");
            if (!potentialExistingFile.exists()) {
                throw new MojoExecutionException("Could not update existing jar-file, because it does not exist. Please make sure this file gets created or exists, or set updateExistingJar to false.");
            }
            createJarParams.addResource(null, potentialExistingFile);
        } else {
            File potentialExistingGeneratedClasses = new File(build.getOutputDirectory());
            if (!potentialExistingGeneratedClasses.exists()) {
                this.getLog().warn((CharSequence)"There were no classes build, this might be a problem of your project, if its not, just ignore this message. Continuing creating JavaFX JAR...");
                potentialExistingGeneratedClasses.mkdirs();
            }
            createJarParams.addResource(potentialExistingGeneratedClasses, "");
        }
        try {
            if (this.checkIfJavaIsHavingPackagerJar()) {
                this.getLog().debug((CharSequence)"Check if packager.jar needs to be added");
                if (this.addPackagerJar && !this.skipCopyingDependencies) {
                    this.getLog().debug((CharSequence)"Searching for packager.jar ...");
                    String targetPackagerJarPath = this.libFolderName + File.separator + "packager.jar";
                    for (Dependency dependency : this.project.getDependencies()) {
                        if (!"system".equalsIgnoreCase(dependency.getScope())) continue;
                        File packagerJarFile = new File(dependency.getSystemPath());
                        String packagerJarFilePathString = packagerJarFile.toPath().normalize().toString();
                        if (!packagerJarFile.exists() || !packagerJarFilePathString.endsWith(targetPackagerJarPath)) continue;
                        this.getLog().debug((CharSequence)String.format("Including packager.jar from system-scope: %s", packagerJarFilePathString));
                        File dest = new File(libDir, packagerJarFile.getName());
                        if (!dest.exists()) {
                            Files.copy(packagerJarFile.toPath(), dest.toPath(), new CopyOption[0]);
                        }
                        classpath.append(this.libFolderName).append("/").append(packagerJarFile.getName()).append(" ");
                    }
                } else {
                    this.getLog().debug((CharSequence)"No packager.jar will be added");
                }
            } else if (this.addPackagerJar) {
                this.getLog().warn((CharSequence)"Skipped checking for packager.jar. Please install at least Java 1.8u40 for using this feature.");
            }
            ArrayList brokenArtifacts = new ArrayList();
            this.project.getArtifacts().stream().filter(artifact -> {
                File artifactFile = artifact.getFile();
                return artifactFile.isFile() && artifactFile.canRead();
            }).filter(artifact -> {
                if (this.classpathExcludes.isEmpty()) {
                    return true;
                }
                boolean isListedInList = this.isListedInExclusionList((Artifact)artifact);
                return !isListedInList;
            }).forEach(artifact -> {
                File artifactFile = artifact.getFile();
                this.getLog().debug((CharSequence)String.format("Including classpath element: %s", artifactFile.getAbsolutePath()));
                File dest = new File(libDir, artifactFile.getName());
                if (!dest.exists()) {
                    try {
                        if (!this.skipCopyingDependencies) {
                            Files.copy(artifactFile.toPath(), dest.toPath(), new CopyOption[0]);
                        } else {
                            this.getLog().info((CharSequence)String.format("Skipped copying classpath element: %s", artifactFile.getAbsolutePath()));
                        }
                    }
                    catch (IOException ex) {
                        this.getLog().warn((CharSequence)String.format("Couldn't read from file %s", artifactFile.getAbsolutePath()));
                        this.getLog().debug((Throwable)ex);
                        brokenArtifacts.add(artifactFile.getAbsolutePath());
                    }
                }
                classpath.append(this.libFolderName).append("/").append(artifactFile.getName()).append(" ");
            });
            if (!brokenArtifacts.isEmpty()) {
                throw new MojoExecutionException("Error copying dependencies for application");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying dependency for application", (Exception)e);
        }
        if (this.useLibFolderContentForManifestClasspath) {
            final StringBuilder scannedClasspath = new StringBuilder();
            try {
                Files.walkFileTree(libDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        scannedClasspath.append(JarMojo.this.libFolderName.replace("\\", "/")).append("/").append(libDir.toPath().relativize(file).toString().replace("\\", "/")).append(" ");
                        return super.visitFile(file, attrs);
                    }
                });
            }
            catch (IOException ioex) {
                this.getLog().warn((CharSequence)"Got problem while scanning lib-folder", (Throwable)ioex);
            }
            createJarParams.setClasspath(scannedClasspath.toString());
        } else {
            createJarParams.setClasspath(classpath.toString());
        }
        Optional.ofNullable(this.fixedManifestClasspath).ifPresent(manifestClasspath -> {
            if (manifestClasspath.trim().isEmpty()) {
                return;
            }
            createJarParams.setClasspath(manifestClasspath);
            if (this.useLibFolderContentForManifestClasspath) {
                this.getLog().warn((CharSequence)"You specified to use the content of the lib-folder AND specified a fixed classpath. The fixed classpath will get taken.");
            }
        });
        if (this.allPermissions) {
            this.manifestAttributes.put("Permissions", "all-permissions");
        }
        try {
            this.getPackagerLib().packageAsJar(createJarParams);
        }
        catch (PackagerException e) {
            throw new MojoExecutionException("Unable to build JFX JAR for application", (Exception)((Object)e));
        }
        if (this.copyAdditionalAppResourcesToJar) {
            Optional.ofNullable(this.additionalAppResources).filter(File::exists).ifPresent(appResources -> {
                this.getLog().info((CharSequence)"Copying additional app ressources...");
                try {
                    Path targetFolder = this.jfxAppOutputDir.toPath();
                    Path sourceFolder = appResources.toPath();
                    this.copyRecursive(sourceFolder, targetFolder);
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)"Couldn't copy additional application resource-file(s).", (Throwable)e);
                }
            });
        }
        if (libDir.list().length == 0) {
            libDir.delete();
        }
    }

    private boolean checkIfJavaIsHavingPackagerJar() {
        if (JavaDetectionTools.IS_JAVA_8 && JavaDetectionTools.isAtLeastOracleJavaUpdateVersion(40)) {
            return true;
        }
        return JavaDetectionTools.IS_JAVA_9;
    }

    private boolean isListedInExclusionList(Artifact artifact) {
        return this.classpathExcludes.stream().filter(dependency -> {
            String dependencyTrailIdentifier = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":";
            if (!this.classpathExcludesTransient) {
                return dependencyTrailIdentifier.startsWith(artifact.getGroupId() + ":" + artifact.getArtifactId() + ":");
            }
            return artifact.getDependencyTrail().stream().anyMatch(dependencyTrail -> dependencyTrail.startsWith(dependencyTrailIdentifier));
        }).count() > 0L;
    }
}

