package ctscore.api.dto.cart;

import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * Created by Roney on 2017-08-28.
 *
 * 记录商品比较信息
 */
public class OrderParityDto extends BaseDomainDto implements Serializable {

    protected String id;

    private OrderItemDto orderItem;

    /**
     * 店铺
     */
    private String storeId;
    private String productId;
    private String goodsId;
    private String productName;    //包括规格
    private String productFashId;

    /**
     * 供应商货物编码，如京东、苏宁的skuId
     */
    private String sku;

    /**
     * 商品的名称
     */
    private String name;

    /**
     * 协议价
     */
    private BigDecimal costPrice;

    /**
     * 太平净价
     */
    private BigDecimal salePrice;

    private BigDecimal rate;

    /**
     * 下单时商品销售价格浮动比例
     */
    private BigDecimal salePriceRate;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(String goodsId) {
        this.goodsId = goodsId;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductFashId() {
        return productFashId;
    }

    public void setProductFashId(String productFashId) {
        this.productFashId = productFashId;
    }

    public String getSku() {
        return sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public BigDecimal getSalePriceRate() {
        return salePriceRate;
    }

    public void setSalePriceRate(BigDecimal salePriceRate) {
        this.salePriceRate = salePriceRate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OrderParityDto that = (OrderParityDto) o;

        return id != null ? id.equals(that.id) : that.id == null;

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    public OrderItemDto getOrderItem() {
        return orderItem;
    }

    public void setOrderItem(OrderItemDto orderItem) {
        this.orderItem = orderItem;
    }

    public BigDecimal getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public BigDecimal getRate() {
        return rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }
}
