package ctscore.api.myScore;


import ctscore.api.vo.AddGiftsVo;
import ctscore.api.vo.JfVipGiftCountVo;
import ctscore.api.vo.ReduceGiftsVo;

/**
 * Created by KyLeChao on 2017-04-01.
 */
public interface ScoreApi {
    /**
     * 获取总积分
     * (总收入,总支出,可用,冻结)
     * */
    JfVipGiftCountVo jfDetail(String memberId)throws Exception;

    /**
     * 获取失效积分
     * (总收入,总支出,可用,冻结)
     * */
    String invalidScore(String memberId)throws Exception;
    /**
     * 获取支出明细
     *
     * */
    String queryMemberGiftPayment(String memberId, String currentPage)throws Exception;
    /**
     * 获取收入明细
     *
     * */
    String queryMemberGiftIncome(String memberId, String currentPage) throws Exception;

    /**
     * 积分扣减接口
     *
     * */
    String reduceGiftsForCash(ReduceGiftsVo reduceGiftsVo)throws  Exception;
    /**
     * 积分扣减接口for兑换商品
     *
     * */
//    String reduceGiftsForTpScore(String need,String memberId,String requestId,String remark)throws Exception;
    /**
     * 积分返还接口
     * 已废弃
     * */
//    String refundmentGifts(String orderNo,String reason,String memberId,String channel,String ruleType,String childType,String companySource)throws Exception;
    /**
     * 积分返还接口
     * */
    String addGifts(AddGiftsVo addGiftsVo)throws Exception;
}
