package ctscore.service.apiImpl;

import cart.api.OrderMainApi;
import cart.api.PaymentApi;
import cart.api.dto.order.OrderMainDto;
import cart.api.dto.payment.PaymentDto;
import cms.api.OrganizationApi;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import ctscore.api.CtScoreApi;
import member.api.MemberApi;
import member.api.dto.core.CoreUserDto;
import member.api.vo.MemberVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import score.api.ScoreApi;
import score.api.definition.ScoreBusinessType;
import score.api.dto.entitydto.ScoreAccountDTO;
import score.api.dto.requestdto.ScoreAccountRequestDTO;
import score.api.dto.requestdto.ScoreIncomeDetailRequestDTO;
import score.api.dto.responsedto.TransactionResponseDTO;
import sinomall.config.api.base.BaseResponse;
import utils.GlobalContants;
import utils.data.BeanMapper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@MotanService
public class CtScoreApiImpl implements CtScoreApi {
    Logger logger = LoggerFactory.getLogger(getClass());
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    PaymentApi paymentApi;
    @MotanReferer
    MemberApi memberApi;

    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    ScoreApi scoreApi;

    @Override
    public BaseResponse refundScore(String orderNo) {
        BaseResponse baseResponse = new BaseResponse(GlobalContants.ResponseStatus.SUCCESS, "积分返还成功");
        OrderMainDto orderMain = orderMainApi.findOrderByOrderNo(orderNo);
        PaymentDto payment = paymentApi.findPaymentById(orderMain.getPaymentId());
        if (payment.getScore() != null && payment.getScore().compareTo(BigDecimal.ZERO) > 0) {
            try {
                ScoreAccountRequestDTO scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                MemberVo memberVo = memberApi.getMemberInfo(orderMain.getMemberId());
                CoreUserDto coreUser = memberVo.getUser();
                scoreAccountRequestDTO.setOrganizationCode(organizationApi.findOrganizationById(coreUser.getOrganizationId()).getOrgCode());
                scoreAccountRequestDTO.setUserId(coreUser.getId());
                scoreAccountRequestDTO.setPhone(coreUser.getPhone());
                scoreAccountRequestDTO.setEmail(coreUser.getEmail());
                ScoreAccountDTO scoreAccountDTO = scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                ScoreIncomeDetailRequestDTO scoreIncomeDetailRequestDTO = new ScoreIncomeDetailRequestDTO();
                scoreIncomeDetailRequestDTO.setScoreAccountId(scoreAccountDTO.getId());
                scoreIncomeDetailRequestDTO.setTransactionNo(orderMain.getOrderNo());
                scoreIncomeDetailRequestDTO.setScoreVal(payment.getScore());
                scoreIncomeDetailRequestDTO.setTransaTime(new Date());
                scoreIncomeDetailRequestDTO.setBusiCode(ScoreBusinessType.BUSI_INCOME_REFUND.getBusinessCode());
                scoreIncomeDetailRequestDTO.setBusiSource(ScoreBusinessType.BUSI_INCOME_REFUND.getBusinessSource());
                scoreIncomeDetailRequestDTO.setMemo("订单" + orderNo + "返还积分" + payment.getScore());
                TransactionResponseDTO transactionResponseDTO = scoreApi.addScore(scoreIncomeDetailRequestDTO);
                if (!GlobalContants.ResponseStatus.SUCCESS.equals(transactionResponseDTO.getStatus())) {
                    logger.error("积分返还错误，transactionResponseDTO={}，orderNo=" + orderNo, JSON.toJSONString(transactionResponseDTO), new RuntimeException("积分返还错误"));
                    baseResponse.setStatus(GlobalContants.ResponseStatus.ERROR);
                    baseResponse.setResponseMsg("积分返还失败");
                    return baseResponse;
                }
            } catch (Exception e) {
                baseResponse.setStatus(GlobalContants.ResponseStatus.ERROR);
                baseResponse.setResponseMsg("积分返还异常");
                logger.debug("积分返还异常", e);
            }
        } else {
            baseResponse.setResponseMsg("无需返还积分");
        }
        return baseResponse;
    }


}
