package ctscore.service.apiImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import ctscore.api.IntegratCashApi;
import ctscore.service.service.IntegratCashService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import utils.Lang;
import utils.sql.PageVo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by rwb on 2017/4/15.
 */
@MotanService
public class IntegratCashImpl implements IntegratCashApi {

    @Autowired
    private IntegratCashService integratCashService;

    @Override
    public PageVo findCheckDataInfo(Pageable pageable, Map<String, Object> cashVo) {
        int size = pageable.getPageSize();
        int number = pageable.getPageNumber()+1;
        Map<String, String> map = this.getParams(cashVo);
        String cashStatus = (String) map.get("cashStatus");
        String phoneNumber = (String) map.get("phoneNumber");
        String cardNumber = (String) map.get("cardNumber");
        String batchNumber = (String) map.get("batchNumber");
        String userID = (String) map.get("userID");
        String userName = (String) map.get("userName");
        String createTime = (String) map.get("createTime");
        String endTime = (String) map.get("endTime");
        return integratCashService.findCashInfo(cashStatus,phoneNumber,cardNumber,batchNumber,userID,userName,createTime,endTime,size,number);
    }



    @Override
    public List<Map<String,Object>> findCheckDataInfo1(Map<String, Object> cashVo) {
        Map<String,String> map = this.getParams(cashVo);
        return integratCashService.findCashInfo1(map.get("cashStatus"),map.get("phoneNumber"),map.get("cardNumber"),map.get("batchNumber"),map.get("userID"),map.get("userName"),map.get("createTime"),map.get("endTime"));
    }

    private Map<String,String> getParams(Map<String, Object> cashVo) {
        Map<String,String> map = new HashMap<>();
        String cashStatus = null;
        String phoneNumber = null;
        String cardNumber = null;
        String batchNumber = null;
        String userID = null;
        String userName = null;
        String createTime = null;
        String endTime = null;
        if(!Lang.isEmpty(cashVo.get("cashStatus"))){
            cashStatus = cashVo.get("cashStatus") + "";
        }
        if(!Lang.isEmpty(cashVo.get("phoneNumber"))){
            phoneNumber = cashVo.get("phoneNumber") + "";
        }
        if(!Lang.isEmpty(cashVo.get("cardNumber"))){
            cardNumber = cashVo.get("cardNumber") + "";
        }
        if(!Lang.isEmpty(cashVo.get("batchNumber"))){
            batchNumber = cashVo.get("batchNumber") + "";
        }
        if(!Lang.isEmpty(cashVo.get("userID"))){
            userID = cashVo.get("userID") + "";
        }
        if(!Lang.isEmpty(cashVo.get("userName"))){
            userName = cashVo.get("userName") + "";
        }
        if(!Lang.isEmpty(cashVo.get("createTime"))){
            createTime = cashVo.get("createTime") + "";
        }
        if(!Lang.isEmpty(cashVo.get("endTime"))){
            endTime = cashVo.get("endTime") + "";
        }
        if(!Lang.isEmpty(createTime)){
            createTime = createTime.replaceAll("/","-");
            createTime = createTime + "00:00;00";
        }
        if(!Lang.isEmpty(endTime)){
            endTime = endTime.replaceAll("/","-");
            endTime = endTime + "00:00;00";
        }
        map.put("cashStatus",cashStatus);
        map.put("phoneNumber",phoneNumber);
        map.put("cardNumber",cardNumber);
        map.put("batchNumber",batchNumber);
        map.put("userID",userID);
        map.put("userName",userName);
        map.put("createTime",createTime);
        map.put("endTime",endTime);
        return map;
    }
}
