package ctscore.service.apiImpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import ctscore.api.PresellApi;
import ctscore.api.vo.PresellVo;

import ctscore.model.PresellUserInfo;
import ctscore.model.repository.PresellUserInfoRepos;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import utils.lang.Copys;

/**
 * Created by Dy on 2017-10-24.
 */
@MotanService
public class PresellApiImpl implements PresellApi {

    @Autowired
    PresellUserInfoRepos presellRepos;

    public void saveSingleGoodsPresellInfo(PresellVo presellVo){
        PresellUserInfo userInfo = new PresellUserInfo();
        Copys.create().from(presellVo).to(userInfo);
        presellRepos.save(userInfo);
    }

    public Boolean existsPresellByPhoneNumber(String phoneNumber){
        PresellUserInfo userInfo = new PresellUserInfo();
        userInfo.setPhoneNumber(phoneNumber);
        Example<PresellUserInfo> example=Example.of(userInfo);
        long count = presellRepos.count(example);
        if (count>0){
            return true;
        }else{
            return false;
        }
    }

}
