package ctscore.service.apiImpl.myScore;

import cart.api.OrderMainApi;
import cart.api.dto.order.OrderItemDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import ctscore.api.JdECardConsume;
import ctscore.model.JdCard;
import ctscore.model.repository.JdCardRepo;
import goods.api.GoodsApi;
import goods.dto.goods.GoodsDto;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import outsideapi.utils.FlgAseUtil;
import sysmg.api.SystemConfigApi;
import sysmg.dto.SystemConfigDto;
import sysmg.response.SystemConfigValueDto;
import utils.Lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by oracle on 2017-06-12.
 */
@MotanService
public class JdECardConsumeImpl implements JdECardConsume {
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    GoodsApi goodsApi;
    @Autowired
    JdCardRepo jdCardRepo;
    @Autowired
    MapperFacade mapperFacade;

    @Value("${flgVariables.flgAseKey}")
    private String KMKey;

    Logger log = LoggerFactory.getLogger(getClass());

    @MotanReferer
    SystemConfigApi systemConfigApi;

    @Override
    public Map<String, Object> consume(List<ctscore.api.dto.cart.OrderItemDto> orderItemsParam) {
        List<OrderItemDto> orderItems = Lang.isEmpty(orderItemsParam) ? new ArrayList<OrderItemDto>() : mapperFacade.mapAsList(orderItemsParam, OrderItemDto.class);
        StringBuilder jdECardCode = new StringBuilder();
        List<Map<String,String>> list=new ArrayList<>();
        Map<String, Object> resultMap = new HashMap<>();
        String isJdekForMoney=systemConfigApi.getConfigValue("tpScore", SystemConfigDto.CONFIG_CODE_JDEK_FOR_MONEY, SystemConfigValueDto.CONFIG_VALUE_TYPE_JDEK_FOR_MONEY,true,true);
        if("1".equals(isJdekForMoney)){
        for (OrderItemDto orderItem : orderItems) {
            Integer count = orderItem.getCount();
            Map temp=new HashMap<>();
            temp.put("price",orderItem.getCostPrice());
            temp.put("extraCount",count);
            list.add(temp);
        }
        resultMap.put("isExtra","true");
        resultMap.put("extra",list);
        resultMap.put("resCode", "0000");
        resultMap.put("resMessage", "成功");
        }else{
            try {
                List<Map<String, Object>> cards = new ArrayList<>();
                for (OrderItemDto orderItem : orderItems) {
                    Map<String, Object> cardInfo = new HashMap<>();
                    Integer count = orderItem.getCount();
                    GoodsDto goods = goodsApi.findById(orderItem.getGoodsId());
                    String sku = goods.getSku();
                    List<JdCard> jdCards = jdCardRepo.findByStatusAndProductCd("0", sku);
                    if (jdCards == null || jdCards.size() < count) {
                        /*Integer extraCount=count-jdCards.size();
                        resultMap.put("resCode", "0006");
                        resultMap.put("isExtra","true");
                        resultMap.put("resMessage", "库存不足");
                        cardInfo.put("count", jdCards.size());
                        Map temp=new HashMap<>();
                        temp.put("price",orderItem.getCostPrice());
                        temp.put("extraCount",extraCount);
                        list.add(temp);
                        resultMap.put("extra",list);*/
                        throw new RuntimeException("库存不足");

                    }else{
                        cardInfo.put("count", count);
                    }


                    cardInfo.put("cards", jdCards);
                    cards.add(cardInfo);
                }
                List<JdCard> consumeCards = new ArrayList<>();
                for (Map<String, Object> card : cards) {
                    int consumeCount = 0;
                    Integer count = (Integer) card.get("count");
                    List<JdCard> jdCards = (List<JdCard>) card.get("cards");
                    for (JdCard jdCard : jdCards) {
                        jdCard.setStatus("1");
                        consumeCount++;
                        consumeCards.add(jdCard);
                        jdECardCode.append("面额:"+jdCard.getProductCd().substring(3)+"元,卡号：" + jdCard.getCardNo() + ",密码:" + FlgAseUtil.decrypt(jdCard.getPaswwords()+" ", KMKey));
                        if (consumeCount >= count) {
                            break;
                        }
                    }
                    resultMap.put("jdECardCode", FlgAseUtil.encrypt(jdECardCode.toString(),KMKey));
                }
                jdCardRepo.save(consumeCards);
                resultMap.put("consumeCards",consumeCards);
            } catch (Exception e) {
                resultMap.put("resCode", "0007");
                resultMap.put("resMessage", "系统错误");
                e.printStackTrace();
                log.error("京东E卡消费异常" + e.getMessage());
                return resultMap;

            }
            resultMap.put("resCode", "0000");
            resultMap.put("resMessage", "成功");
        }
        return resultMap;
    }
}
