package ctscore.service.apiImpl.myScore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import ctscore.api.myScore.ScoreApi;
import ctscore.api.vo.*;
import ctscore.service.utils.httpPost.HttpTransmissionService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import utils.security.AesUtil;
import utils.security.MD5Utils;
import utils.string.StringUtils;

import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * Created by oracle on 2017-04-01.
 */
@MotanService
public class ScoreApiImpl implements ScoreApi {

    @Value("${gift.giftDetailsUrl}")
    private String giftDetailsUrl;//积分接口
    @Value("${gift.md5key}")
    private String MD5KEY;//MD5key
    @Value("${gift.asekey}")
    private String ASEKEY;//ASEkey

    @Value("${flgVariables.server.flgMd5Key}")
    private String flgMD5KEY;           //福利高MD5KEY
    @Value("${flgVariables.server.flgAseKey}")
    private String flgASEKEY;           //福利高ASEKEY


    @Autowired
    HttpTransmissionService httpTransmissionService;

    public final static int PAGESAIZE1 = 20;

    //获取积分总表信息
    public JfVipGiftCountVo jfDetail(String memberId) throws Exception {
        System.out.println("=========memberId===========" + memberId);
        Map<String, Object> returnMap = new HashMap<String, Object>();
        String channel = "99";//其他渠道
        String token = AesUtil.Encrypt(MD5Utils.MD5Encode((MD5KEY + "|" + memberId),null), ASEKEY);
        String url = "" + giftDetailsUrl + "/queryGiftTotal/" + URLEncoder.encode(AesUtil.Encrypt(memberId, ASEKEY), "UTF-8") + "/" + URLEncoder.encode(token, "UTF-8") + "/" + URLEncoder.encode(AesUtil.Encrypt(channel, ASEKEY), "UTF-8") + "";
        String responseStr = httpTransmissionService.sentXmlMethod(url, "");
        System.out.println("=========responseStr===========" + responseStr);
        Map map1 = JSON.parseObject(responseStr);
        //接口返回信息
        String resToken = AesUtil.Decrypt((String) map1.get("token"), ASEKEY);
        String resMemberId = (String) map1.get("memberId");     //返回memberId
        String resIncome = (String) map1.get("income");         //返回总收入
        String resCost = (String) map1.get("cost");             //返回总支出
        String resFreeze = (String) map1.get("freeze");         //返回冻结积分
        String resLastday = (String) map1.get("lastday");
        String resOverdue = (String) map1.get("FutureOverdue"); //返回即将失效积分
        String resResult = (String) map1.get("result");         //返回调用状态
        String resMd5Str = MD5Utils.MD5Encode((MD5KEY + "|" + resMemberId + "|" + resIncome + "|" + resCost + "|" + resFreeze + "|" + resLastday + "|" + resOverdue),null);
        System.out.println("===========resMd5Str.equals(resToken)==========" + resMd5Str.equals(resToken) + "====resResult====" + resResult);
        if ((resMd5Str.equals(resToken)) && (resResult.equals("0000"))) {
            Double resIncome2 = 0.00;
            if ((resIncome == null || "".equals(resIncome)||"null".equals(resIncome))) {
                resIncome2 = 0.00;
            } else {
                resIncome2 = Double.valueOf(resIncome);
            }
            Double resCost2 = 0.00; //支出数量
            if ((resCost == null || "".equals(resCost)||"null".equals(resCost))) {
                resCost2 = 0.00;
            } else {
                resCost2 = Double.valueOf(resCost);
            }

            Double resOverdue2 = 0.00;

            if ((resOverdue.equals("null") || "".equals(resOverdue)||"null".equals(resOverdue))) {
                resOverdue2 = 0.00;
            } else {
                resOverdue2 = Double.valueOf(resOverdue);
            }
            String resLastday2 = "";
            if ((resLastday == null || "".equals(resLastday)||"null".equals(resLastday))) {
                resLastday2 = "";
            } else {
                resLastday2 = resLastday.toString().substring(0, 4) + "." + resLastday.toString().substring(5, 7) + "." + resLastday.toString().substring(8, 10) + ".";
            }
            Double resFreeze2 = 0.00;
            if (resFreeze == null || "".equals(resFreeze)||"null".equals(resFreeze)) {
                resFreeze2 = 0.00;
            } else {
                resFreeze2 = Double.valueOf(resFreeze);
            }
            Double usable = resIncome2 - resCost2;
            BigDecimal bd = new BigDecimal(usable);
            Double sentAmount = bd.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
            JfVipGiftCountVo jfVipGiftCountVo = new JfVipGiftCountVo();
            jfVipGiftCountVo.setInnercome(resIncome2);  //总收入
            jfVipGiftCountVo.setCost(resCost2);         //总支出
            jfVipGiftCountVo.setUsable(sentAmount);     //可用
            jfVipGiftCountVo.setFreeze(resFreeze2);     //冻结
            jfVipGiftCountVo.setLastday(resLastday2);
            jfVipGiftCountVo.setFutureoverdue(resOverdue2.toString());
//            returnMap.put("jfVipGiftCount", jfVipGiftCountVo);
//            return JSON.toJSONString(parseJson(JSONObject.toJSONString(returnMap)));
            return jfVipGiftCountVo;
        } else {
            return null;
        }
    }

    //获取失效积分
    public String invalidScore(String memberId) throws Exception {
        return null;
    }

    //获取积分消费详细记录
    public String queryMemberGiftPayment(String memberId, String currentPage) throws Exception {
        System.out.println("=========memberId====" + memberId + "=====currentPage=====" + currentPage);
        String curPage = StringUtils.isEmpty(currentPage) ? "1" : currentPage;
        DecimalFormat df = new DecimalFormat("0.00");
        String channel = "99";
        String tokenDetails = AesUtil.Encrypt(MD5Utils.MD5Encode((MD5KEY + "|" + memberId),null), ASEKEY);
        Map<String, Object> returnMap = new HashMap<String, Object>();
        String url2 = "" + giftDetailsUrl + "/queryGiftPayOut/" + URLEncoder.encode(AesUtil.Encrypt(memberId, ASEKEY), "UTF-8") + "/" + URLEncoder.encode(AesUtil.Encrypt(curPage, ASEKEY), "UTF-8") + "/" + URLEncoder.encode(AesUtil.Encrypt(String.valueOf(PAGESAIZE1), ASEKEY), "UTF-8") + "/" + URLEncoder.encode(AesUtil.Encrypt(String.valueOf(""), ASEKEY), "UTF-8") + "/" + URLEncoder.encode(AesUtil.Encrypt("", ASEKEY), "UTF-8") + "/" + URLEncoder.encode(tokenDetails, "UTF-8") + "/" + URLEncoder.encode(AesUtil.Encrypt(channel, ASEKEY), "UTF-8") + "";

        String responseStrDetails = httpTransmissionService.sentXmlMethod(url2, "");
        Map mapDetails = JSON.parseObject(responseStrDetails);
        //接口返回信息
        String resTokenDetails = AesUtil.Decrypt((String) mapDetails.get("token"), ASEKEY);
        String resResultDetails = (String) mapDetails.get("result");
        String resMemberIdDetails = (String) mapDetails.get("memberId");
        String resMd5StrDetails = MD5Utils.MD5Encode((MD5KEY + "|" + resResultDetails + "|" + resMemberIdDetails),null);
        if ((resMd5StrDetails.equals(resTokenDetails)) && (resResultDetails.equals("0000"))) {
            List<?> objectList = (List<?>) mapDetails.get("list");
            String totalCountDetails = (String) mapDetails.get("totalCount");
            Integer totalCountDetails2 = 0;
            if (totalCountDetails.equals("null") || "".equals(totalCountDetails)) {
                totalCountDetails2 = 0;
            } else {
                totalCountDetails2 = Integer.valueOf(totalCountDetails);
            }
            List<JfVipGiftPaymentVo> resultList = new ArrayList<JfVipGiftPaymentVo>();
            Pager pager = new Pager(Integer.valueOf(curPage), totalCountDetails2, PAGESAIZE1);
            for (int i = 0; i < objectList.size(); i++) {
                Object objArr = (Object) objectList.get(i);
                Map map_ = (Map) JSON.toJSON(objArr);
                String createtime = (String) map_.get("createTime");
                String number = (String) map_.get("number");
                String memo = (String) map_.get("memo");
//                String memo2 = "";
//                if (memo.contains("费")) {
//                    memo2 = memo.substring(0, memo.indexOf("费") + 1);
//                } else {
//                    memo2 = memo;
//                }
                String memo2 = memo;
                String memo3 = "";
                if (memo2.length() > 2400) {//需求:更改:2017-05-31 显示全部消费记录
                    memo3 = memo2.substring(0, 24);
                    memo3 = memo3 + "...";
                } else {
                    memo3 = memo2;
                }

                JfVipGiftPaymentVo jfVipGiftPaymentVo_ = new JfVipGiftPaymentVo();
                jfVipGiftPaymentVo_.setCreateTime(createtime == null ? "" : createtime);
                if (number == null || "".equals(number)||"null".equals(number)) {
                    number = "0.00";
                } else {
                    Double d = Double.valueOf(number);
                    number = df.format(d);
                }
                jfVipGiftPaymentVo_.setDefraysum(number == null ? "" : number);
                jfVipGiftPaymentVo_.setMemo(memo == null ? "" : memo3);
                resultList.add(jfVipGiftPaymentVo_);
            }
            if(resultList.size()>0){
                returnMap.put("memberGiftPayment", resultList);
            }else{
                returnMap.put("memberGiftPayment", "0");
            }

            returnMap.put("pager", pager);
            return JSON.toJSONString(parseJson(JSONObject.toJSONString(returnMap)));
        } else {
            return "500.html";
        }
    }

    //获取积分收入详细记录
    public String queryMemberGiftIncome(String memberId, String currentPage) throws Exception {
        System.out.println("=========memberId====" + memberId + "=====currentPage=====" + currentPage);
        String curPage = StringUtils.isEmpty(currentPage) ? "1" : currentPage;
        DecimalFormat df = new DecimalFormat("0.00");
        String channel = "99";
        Map<String, Object> returnMap = new HashMap<String, Object>();
        String tokenDetails = AesUtil.Encrypt(MD5Utils.MD5Encode((MD5KEY + "|" + memberId),null), ASEKEY);

        String url2 = "" + giftDetailsUrl + "/queryGiftIncome/" + URLEncoder.encode(AesUtil.Encrypt(memberId, ASEKEY), "UTF-8") + "/" + URLEncoder.encode(AesUtil.Encrypt(curPage, ASEKEY), "UTF-8") + "/" + URLEncoder.encode(AesUtil.Encrypt(String.valueOf(PAGESAIZE1), ASEKEY), "UTF-8") + "/" + URLEncoder.encode(AesUtil.Encrypt(String.valueOf(""), ASEKEY), "UTF-8") + "/" + URLEncoder.encode(AesUtil.Encrypt("", ASEKEY), "UTF-8") + "/" + URLEncoder.encode(tokenDetails, "UTF-8") + "/" + URLEncoder.encode(AesUtil.Encrypt(channel, ASEKEY), "UTF-8") + "";

        String responseStrDetails = httpTransmissionService.sentXmlMethod(url2, "");
        Map mapDetails = JSON.parseObject(responseStrDetails);
        //接口返回信息
        String resTokenDetails = AesUtil.Decrypt((String) mapDetails.get("token"), ASEKEY);
        String resResultDetails = (String) mapDetails.get("result");
        String resMemberIdDetails = (String) mapDetails.get("memberId");
        String resMd5StrDetails = MD5Utils.MD5Encode((MD5KEY + "|" + resResultDetails + "|" + resMemberIdDetails),null);
        System.out.println("=====resMd5StrDetails.equals(resTokenDetails)====" + resMd5StrDetails.equals(resTokenDetails) + "===resResultDetails===" + resResultDetails);
        if ((resMd5StrDetails.equals(resTokenDetails)) && (resResultDetails.equals("0000"))) {
            List<?> objectList = (List<?>) mapDetails.get("list");
            String totalCountDetails = (String) mapDetails.get("totalCount");
            Integer totalCountDetails2 = 0;
            if (totalCountDetails.equals("null") || "".equals(totalCountDetails)) {
                totalCountDetails2 = 0;
            } else {
                totalCountDetails2 = Integer.valueOf(totalCountDetails);
            }
            List<JfVipGiftIncomeVo> resultList = new ArrayList<JfVipGiftIncomeVo>();
            Pager pager = new Pager(Integer.valueOf(curPage), totalCountDetails2, PAGESAIZE1);
            for (int i = 0; i < objectList.size(); i++) {
                Object objArr = (Object) objectList.get(i);
                Map map_ = (Map) JSON.toJSON(objArr);
                String createtime = (String) map_.get("createTime");
                String number = (String) map_.get("number");
                String policyNo = (String) map_.get("policyNo");
                String memo = (String) map_.get("memo");
//                String memo2 = "";
//                if (memo.contains("送")) {
//                    memo2 = memo.substring(0, memo.indexOf("送") + 1);
//                } else {
//                    memo2 = memo;
//                }
                String memo2 = memo;
                String memo3 = "";
                if (memo2.length() > 2400) {//需求:更改:2017-05-31 显示全部的消费记录
                    memo3 = memo2.substring(0, 24);
                    memo3 = memo3 + "...";
                } else {
                    memo3 = memo2;
                }
                JfVipGiftIncomeVo jfVipGiftIncomeVo_ = new JfVipGiftIncomeVo();


                jfVipGiftIncomeVo_.setCreateTime(createtime == null ? "" : createtime);
                if (number == null || "".equals(number)||"null".equals(number)) {
                    number = "0.00";
                } else {
                    Double d = Double.valueOf(number);
                    number = df.format(d);
                }
                jfVipGiftIncomeVo_.setNum(number);
                jfVipGiftIncomeVo_.setPolicyNo(policyNo == null ? "" : policyNo);
                jfVipGiftIncomeVo_.setMemo(memo == null ? "" : memo3);
                resultList.add(jfVipGiftIncomeVo_);
            }
            if(resultList.size()>0){
                returnMap.put("memberGiftIncome", resultList);
            }else{
                returnMap.put("memberGiftIncome", "0");
            }
            returnMap.put("pager", pager);
            return JSON.toJSONString(parseJson(JSONObject.toJSONString(returnMap)));
        } else {
            return "500.html";
        }
    }

    //@Autowired
    //String string;



    @Override
    public String reduceGiftsForCash(ReduceGiftsVo reduceGiftsVo)throws Exception {
        return reduceGifts( reduceGiftsVo);
    }

//    @Override
//    public String reduceGiftsForTpScore(String need, String memberId,String requestId,String remark)throws  Exception{
//        return reduceGifts(memberId,"","",need,requestId,remark);
//    }

    //积分返还接口
    @Override
    public String addGifts(AddGiftsVo addGiftsVo) throws  Exception{
        String firmNo   = addGiftsVo.getFirmNo();                     //平台号       不加密
        String orderNo  = addGiftsVo.getOrderNo();                    //订单号       加密
        String reason   = addGiftsVo.getReason();                     //返回原因     可为空
        String token    = MD5Utils.MD5Encode((flgMD5KEY + "|"+ orderNo ),null);

        String url=giftDetailsUrl + "/refundmentGifts/";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost=new HttpPost(url);
        List<NameValuePair> nvps = new ArrayList <NameValuePair>();
        nvps.add(new BasicNameValuePair("firmNo",   firmNo));
        nvps.add(new BasicNameValuePair("orderNo",   AesUtil.Encrypt(orderNo,flgASEKEY)));
        nvps.add(new BasicNameValuePair("reason",   reason));
        nvps.add(new BasicNameValuePair("token",   token));

        HttpEntity entity = new UrlEncodedFormEntity(nvps, "UTF-8");
        httpPost.setEntity(entity);
        HttpResponse response = httpClient.execute(httpPost);
        System.out.println("=======================服务器返回状态码============"+response.getStatusLine().getStatusCode());
        HttpEntity resEntity = response.getEntity();
        Map mapDetails = JSON.parseObject(EntityUtils.toString(resEntity, "UTF-8"));

        String resResult  = AesUtil.Decrypt((String) mapDetails.get("result"), flgASEKEY);
        String resFirmNo  = (String) mapDetails.get("firmNo");
        String resOrderNo = AesUtil.Decrypt((String) mapDetails.get("orderNo"),flgASEKEY);
        String resToken   = (String) mapDetails.get("token");

        String newToken   = MD5Utils.MD5Encode((resFirmNo +"|"+flgMD5KEY + "|"+resResult+"|"+ resOrderNo ),null);
        if(newToken.equals(resToken)&&"0000".equals(resResult)){
            return "TRUE";
        }else{
            return "FALSE";
        }
    }

    //调用积分扣减接口
    public String reduceGifts(ReduceGiftsVo reduceGiftsVo ) throws Exception {
        String loginId  = reduceGiftsVo.getLoginId();                   //扣减的memberId
        String firmNo   = reduceGiftsVo.getFirmNo();                    //平台号       不加密
        String userId   = reduceGiftsVo.getUserId();                    //平台中的ID
        String points   = reduceGiftsVo.getPoints();                    //扣减的积分
        String orderAmt = reduceGiftsVo.getOrderAmt();                  //价格*100单位分
        String orderNo  = reduceGiftsVo.getOrderNo();                   //订单号
        String productNm= reduceGiftsVo.getProductNm();                 //消费类型
        String token    = MD5Utils.MD5Encode((orderAmt+"|"+flgMD5KEY + "|"+ points + "|" + loginId + "|" + userId + "|" + firmNo+"|" + orderNo),null);//token

        String url=giftDetailsUrl + "/reduceGifts/";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost=new HttpPost(url);
        List<NameValuePair> nvps = new ArrayList <NameValuePair>();
        nvps.add(new BasicNameValuePair("loginId",   AesUtil.Encrypt(loginId,flgASEKEY)));
        nvps.add(new BasicNameValuePair("firmNo" ,   firmNo));
        nvps.add(new BasicNameValuePair("userId" ,   AesUtil.Encrypt(userId,flgASEKEY)));
        nvps.add(new BasicNameValuePair("points" ,   AesUtil.Encrypt(points,flgASEKEY)));
        nvps.add(new BasicNameValuePair("orderAmt",  AesUtil.Encrypt(orderAmt,flgASEKEY)));
        nvps.add(new BasicNameValuePair("orderNo",   AesUtil.Encrypt(orderNo,flgASEKEY)));
        nvps.add(new BasicNameValuePair("productNm", AesUtil.Encrypt(productNm,flgASEKEY)));
        nvps.add(new BasicNameValuePair("token", token));

        HttpEntity entity = new UrlEncodedFormEntity(nvps, "UTF-8");
        httpPost.setEntity(entity);
        HttpResponse response = httpClient.execute(httpPost);
        System.out.println("=======================服务器返回状态码============"+response.getStatusLine().getStatusCode());
        HttpEntity resEntity = response.getEntity();
        Map mapDetails = JSON.parseObject(EntityUtils.toString(resEntity, "UTF-8"));

        String resResult         = AesUtil.Decrypt((String) mapDetails.get("result"), flgASEKEY) ;
        String resOrderNoDest    = AesUtil.Decrypt((String) mapDetails.get("orderNoDest"), flgASEKEY) ;
        String resLoginId        = AesUtil.Decrypt((String) mapDetails.get("loginId"), flgASEKEY) ;
        String resOrderNo        = AesUtil.Decrypt((String) mapDetails.get("orderNo"), flgASEKEY) ;
        String resFirmNo         = (String) mapDetails.get("firmNo") ;
        String resToken          = (String) mapDetails.get("token");

        String newToken          = MD5Utils.MD5Encode((resResult+"|"+flgMD5KEY +"|"+resOrderNoDest+ "|"+resLoginId+"|"+ resOrderNo+"|"+resFirmNo ),null);
        if (newToken.equals(resToken) && resResult.equals("0000")) {
            return "TRUE";
        } else if (resResult.equals("1005")){
            return "1005";
        }else{
            return "FALSE";
        }


//        String responseStrDetails = httpTransmissionService.sentXmlMethod(url2, "");
//        Map mapDetails = JSON.parseObject(responseStrDetails);
//        //接口返回信息
//        String resTokenDetails = AesUtil.Decrypt((String) mapDetails.get("token"), ASEKEY);
//        String resResultDetails = (String) mapDetails.get("result");
//        String resRequestIdDetails = (String) mapDetails.get("requestId");
//
//        String resMd5StrDetails = MD5Utils.MD5Encode((resRequestIdDetails + "|" + resResultDetails + "|" + MD5KEY),null);
//        System.out.println("=====resMd5StrDetails.equals(resTokenDetails)====" + resMd5StrDetails.equals(resTokenDetails) + "===resResultDetails===" + resResultDetails);
//        if ((resMd5StrDetails.equals(resTokenDetails)) && (resResultDetails.equals("0000"))) {
//            return "TRUE";
//        } else if (resResultDetails.equals("1005")){
//            return "1005";
//        }else{
//            return "FALSE";
//        }
    }


    private Object parseJson(String jsonString) {
        // TODO Auto-generated method stub
        JSONObject obj = JSONObject.parseObject(jsonString);
        return obj;
    }


}
