package ctscore.service.config;

import com.weibo.api.motan.config.springsupport.BasicServiceConfigBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import utils.Lang;

/**
 * Created by xiaoqian on 2016/9/27.
 */
//@Order(0)
//@Configuration
public class ServiceMotanConfig {

    /**
     * 基础服务端配置
     *
     * @param port
     * @return
     */
    @Bean(name = "motanServerBasicConfig")
    @ConditionalOnMissingBean
    public BasicServiceConfigBean baseServiceConfig(@Value("${motan.export.port}") String port,
                                                    @Value("${motan.service.group:sinomall}") String motanServerGroup,
                                                    @Value("${motan.service.access.log:false}") Boolean motanServerAccessLog) {
        BasicServiceConfigBean config = new BasicServiceConfigBean();
        config.setDefault(true);
        config.setExport("motan:" + port);
        // config.setGroup("sinomall");
        // config.setAccessLog(false);
        if (Lang.isEmpty(motanServerGroup)) {
            config.setGroup("sinomall");
        } else {
            config.setGroup(motanServerGroup);
        }
        if (Lang.isEmpty(motanServerAccessLog)) {
            config.setAccessLog(true);
        } else {
            config.setAccessLog(motanServerAccessLog);
        }
        config.setShareChannel(true);
        config.setRequestTimeout(60 * 1000);
        //config.setModule("motan-demo-rpc");
        //config.setApplication("myMotanDemo");
        //config.setFilter("openjpasession");
        config.setRegistry("registry");
        return config;
    }

}
