package ctscore.service.service;

import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import utils.Lang;
import utils.sql.PageVo;
import utils.sql.QueryByPage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by rwb on 2017/4/15.
 */
@Component
public class IntegratCashService {

    @Autowired
    private QueryByPage queryByPage;

    @Autowired
    private JdbcTemplate jdbcTemplate;

    public PageVo findCashInfo(String cashStatus, String phoneNumbser, String cardNumber, String batchNumber, String userID, String userName, String createTime, String endTime, int size, int number) {
//        String sql = "select u.user_id,a.bank_deposit,a.bank_city,a.sub_branch,c.bank_account,m.real_name,cu.phone,c.amount,c.remark,c.status,c.date_created,c.last_updated,c.batch_number\n" +
//                "from bank_user u,bank_cash_apply c,bank_account_dic a,core_user cu,member m\n" +
//                "where u.user_id=c.user_id and c.bank_account_dic=a.id and c.user_id = cu.id and m.user_id = cu.id ";
        String sql = "select \n" +
                "       c.id           ,      \n" +
                "       a.bank_deposit ,      \n" +
                "       a.bank_city    ,      \n" +
                "       a.sub_branch   ,   \n" +
                "       c.user_id      ,      \n" +
                "       c.user_name    ,      \n" +
                "       c.user_mobile  ,     \n" +
                "       c.bank_account ,      \n" +
                "       c.amount       ,      \n" +
                "       c.remark       ,        \n" +
                "       c.status       ,        \n" +
                "       c.date_created ,    \n" +
                "       c.last_updated ,    \n" +
                "       c.batch_number        \n" +
                "  from bank_cash_apply  c,\n" +
                "       bank_account_dic a\n" +
                " where c.bank_account_dic = a.id";
        Map<String, Object> map = this.getSQL(sql,cashStatus, phoneNumbser, cardNumber, batchNumber, userID, userName, createTime, endTime);
        StringBuffer stringBuffer = (StringBuffer) map.get("StringBuffer");
        List list = (List) map.get("list");
        PageVo pageVo = null;
        try {
            pageVo = queryByPage.query(stringBuffer.toString(),number,size,list.toArray());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return pageVo;
    }

    private Map<String,Object> getSQL(String sql,String cashStatus, String phoneNumbser, String cardNumber, String batchNumber, String userID, String userName, String createTime, String endTime) {
        StringBuffer stringBuffer = null;
        List<Object> list = new ArrayList<Object>();
        stringBuffer = new StringBuffer(sql);
        //提现状态查询
        if(!Lang.isEmpty(cashStatus)){
            stringBuffer.append(" and c.status = ? ");
            list.add(cashStatus);
        }
        //手机号查询
        if(!Lang.isEmpty(phoneNumbser)){
            stringBuffer.append(" and c.user_mobile = ? ");
            list.add(phoneNumbser);
        }
        //卡号查询
        if(!Lang.isEmpty(cardNumber)){
            stringBuffer.append(" and c.bank_account = ? ");
            list.add(cardNumber);
        }
        //批次号查询
        if(!Lang.isEmpty(batchNumber)){
            stringBuffer.append(" and c.business_id = ? ");
            list.add(batchNumber);
        }
        //用户id查询
        if(!Lang.isEmpty(userID)){
            stringBuffer.append(" and c.user_id = ? ");
            list.add(userID);
        }
        //用户名查询
        if(!Lang.isEmpty(userName)){
            stringBuffer.append(" and c.user_name = ? ");
            list.add(userName);
        }
        //创建时间查询
        if(!Lang.isEmpty(createTime) && !Lang.isEmpty(endTime)){
            stringBuffer.append(" and c.date_created >= to_char(?,'yyyy-mm-dd hh24:mi:ss') and c.last_updated <= to_char(?,'yyyy-mm-dd hh24:mi:ss')");
            list.add(createTime);
            list.add(endTime);
        }
        Map<String ,Object> returnMap = new HashedMap();
        returnMap.put("StringBuffer",stringBuffer);
        returnMap.put("list",list);
        return returnMap;
    }




    public List<Map<String,Object>> findCashInfo1(String cashStatus, String phoneNumber, String cardNumber, String batchNumber, String userID, String userName, String createTime, String endTime) {
//        String sql = "select u.user_id,a.bank_deposit,a.bank_city,a.sub_branch,c.bank_account,m.real_name,cu.phone,c.amount,c.remark,c.status,c.date_created,c.last_updated,c.batch_number,c.serial_number\n" +
//                "from bank_user u,bank_cash_apply c,bank_account_dic a,core_user cu,member m\n" +
//                "where u.user_id=c.user_id and c.bank_account_dic=a.id and c.user_id = cu.id and m.user_id = cu.id ";
        String sql = "select \n" +
                "       c.user_id      ,      \n" +
                "       a.bank_deposit ,      \n" +
                "       a.bank_city    ,      \n" +
                "       a.sub_branch   ,   \n" +
                "       c.bank_account ,      \n" +
                "       c.user_name    ,      \n" +
                "       c.user_mobile  ,     \n" +
                "       c.amount       ,      \n" +
                "       c.remark       ,        \n" +
                "       c.status       ,        \n" +
                "       c.date_created ,    \n" +
                "       c.last_updated ,    \n" +
                "       c.batch_number ,       \n" +
                "       c.request_id        \n" +
                "  from bank_cash_apply  c,\n" +
                "       bank_account_dic a\n" +
                " where c.bank_account_dic = a.id";
        Map<String, Object> map = getSQL(sql,cashStatus, phoneNumber, cardNumber, batchNumber, userID, userName, createTime, endTime);
        StringBuffer stringBuffer = (StringBuffer) map.get("StringBuffer");
        List list = (List) map.get("list");
        List<Map<String,Object>> returnList = null;
        returnList = jdbcTemplate.queryForList(stringBuffer.toString(),list.toArray());
//        List<BankCashApplyVo> listVo = jdbcTemplate.query(stringBuffer.toString(),new BeanPropertyRowMapper<BankCashApplyVo>(BankCashApplyVo.class),list.toArray());
        return returnList;
    }
}
