/*
 * Decompiled with CFR 0.152.
 */
package ctscore.service.apiImpl;

import cart.api.OrderMainApi;
import cart.api.PaymentApi;
import cart.api.dto.order.OrderMainDto;
import cart.api.dto.payment.PaymentDto;
import cms.api.OrganizationApi;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import ctscore.api.CtScoreApi;
import java.math.BigDecimal;
import java.util.Date;
import member.api.MemberApi;
import member.api.dto.core.CoreUserDto;
import member.api.vo.MemberVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import score.api.ScoreApi;
import score.api.definition.ScoreBusinessType;
import score.api.dto.entitydto.ScoreAccountDTO;
import score.api.dto.requestdto.ScoreAccountRequestDTO;
import score.api.dto.requestdto.ScoreIncomeDetailRequestDTO;
import score.api.dto.responsedto.TransactionResponseDTO;
import sinomall.config.api.base.BaseResponse;

@MotanService
public class CtScoreApiImpl
implements CtScoreApi {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    PaymentApi paymentApi;
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    OrganizationApi organizationApi;
    @MotanReferer
    ScoreApi scoreApi;

    public BaseResponse refundScore(String orderNo) {
        BaseResponse baseResponse = new BaseResponse("success", "\u79ef\u5206\u8fd4\u8fd8\u6210\u529f");
        OrderMainDto orderMain = this.orderMainApi.findOrderByOrderNo(orderNo);
        PaymentDto payment = this.paymentApi.findPaymentById(orderMain.getPaymentId());
        if (payment.getScore() != null && payment.getScore().compareTo(BigDecimal.ZERO) > 0) {
            try {
                ScoreAccountRequestDTO scoreAccountRequestDTO = new ScoreAccountRequestDTO();
                MemberVo memberVo = this.memberApi.getMemberInfo(orderMain.getMemberId());
                CoreUserDto coreUser = memberVo.getUser();
                scoreAccountRequestDTO.setOrganizationCode(this.organizationApi.findOrganizationById(coreUser.getOrganizationId()).getOrgCode());
                scoreAccountRequestDTO.setUserId(coreUser.getId());
                scoreAccountRequestDTO.setPhone(coreUser.getPhone());
                scoreAccountRequestDTO.setEmail(coreUser.getEmail());
                ScoreAccountDTO scoreAccountDTO = this.scoreApi.queryScoreAccount(scoreAccountRequestDTO);
                ScoreIncomeDetailRequestDTO scoreIncomeDetailRequestDTO = new ScoreIncomeDetailRequestDTO();
                scoreIncomeDetailRequestDTO.setScoreAccountId(scoreAccountDTO.getId());
                scoreIncomeDetailRequestDTO.setTransactionNo(orderMain.getOrderNo());
                scoreIncomeDetailRequestDTO.setScoreVal(payment.getScore());
                scoreIncomeDetailRequestDTO.setTransaTime(new Date());
                scoreIncomeDetailRequestDTO.setBusiCode(ScoreBusinessType.BUSI_INCOME_REFUND.getBusinessCode());
                scoreIncomeDetailRequestDTO.setBusiSource(ScoreBusinessType.BUSI_INCOME_REFUND.getBusinessSource());
                scoreIncomeDetailRequestDTO.setMemo("\u8ba2\u5355" + orderNo + "\u8fd4\u8fd8\u79ef\u5206" + payment.getScore());
                TransactionResponseDTO transactionResponseDTO = this.scoreApi.addScore(scoreIncomeDetailRequestDTO);
                if (!"success".equals(transactionResponseDTO.getStatus())) {
                    this.logger.error("\u79ef\u5206\u8fd4\u8fd8\u9519\u8bef\uff0ctransactionResponseDTO={}\uff0corderNo=" + orderNo, (Object)JSON.toJSONString((Object)transactionResponseDTO), (Object)new RuntimeException("\u79ef\u5206\u8fd4\u8fd8\u9519\u8bef"));
                    baseResponse.setStatus("error");
                    baseResponse.setResponseMsg("\u79ef\u5206\u8fd4\u8fd8\u5931\u8d25");
                    return baseResponse;
                }
            }
            catch (Exception e) {
                baseResponse.setStatus("error");
                baseResponse.setResponseMsg("\u79ef\u5206\u8fd4\u8fd8\u5f02\u5e38");
                this.logger.debug("\u79ef\u5206\u8fd4\u8fd8\u5f02\u5e38", (Throwable)e);
            }
        } else {
            baseResponse.setResponseMsg("\u65e0\u9700\u8fd4\u8fd8\u79ef\u5206");
        }
        return baseResponse;
    }
}

