/*
 * Decompiled with CFR 0.152.
 */
package ctscore.service.apiImpl.myScore;

import cart.api.OrderMainApi;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import ctscore.api.JdECardConsume;
import ctscore.api.dto.cart.OrderItemDto;
import ctscore.model.JdCard;
import ctscore.model.repository.JdCardRepo;
import goods.api.GoodsApi;
import goods.dto.goods.GoodsDto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import outsideapi.utils.FlgAseUtil;
import sysmg.api.SystemConfigApi;
import utils.Lang;

@MotanService
public class JdECardConsumeImpl
implements JdECardConsume {
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    GoodsApi goodsApi;
    @Autowired
    JdCardRepo jdCardRepo;
    @Autowired
    MapperFacade mapperFacade;
    @Value(value="${flgVariables.flgAseKey}")
    private String KMKey;
    Logger log = LoggerFactory.getLogger(this.getClass());
    @MotanReferer
    SystemConfigApi systemConfigApi;

    public Map<String, Object> consume(List<OrderItemDto> orderItemsParam) {
        ArrayList orderItems = Lang.isEmpty(orderItemsParam) ? new ArrayList() : this.mapperFacade.mapAsList(orderItemsParam, cart.api.dto.order.OrderItemDto.class);
        StringBuilder jdECardCode = new StringBuilder();
        ArrayList list = new ArrayList();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String isJdekForMoney = this.systemConfigApi.getConfigValue("tpScore", "jdekForMoney", "jdekForMoney", Boolean.valueOf(true), Boolean.valueOf(true));
        if ("1".equals(isJdekForMoney)) {
            for (cart.api.dto.order.OrderItemDto orderItem : orderItems) {
                Integer count = orderItem.getCount();
                HashMap<String, Number> hashMap = new HashMap<String, Number>();
                hashMap.put("price", orderItem.getCostPrice());
                hashMap.put("extraCount", count);
                list.add(hashMap);
            }
            resultMap.put("isExtra", "true");
            resultMap.put("extra", list);
            resultMap.put("resCode", "0000");
            resultMap.put("resMessage", "\u6210\u529f");
        } else {
            try {
                ArrayList cards = new ArrayList();
                for (cart.api.dto.order.OrderItemDto orderItem : orderItems) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    Integer count = orderItem.getCount();
                    GoodsDto goods = this.goodsApi.findById(orderItem.getGoodsId());
                    String sku = goods.getSku();
                    List jdCards = this.jdCardRepo.findByStatusAndProductCd("0", sku);
                    if (jdCards == null || jdCards.size() < count) {
                        throw new RuntimeException("\u5e93\u5b58\u4e0d\u8db3");
                    }
                    hashMap.put("count", count);
                    hashMap.put("cards", jdCards);
                    cards.add(hashMap);
                }
                ArrayList<JdCard> consumeCards = new ArrayList<JdCard>();
                for (Map map : cards) {
                    int consumeCount = 0;
                    Integer count = (Integer)map.get("count");
                    List jdCards = (List)map.get("cards");
                    for (JdCard jdCard : jdCards) {
                        jdCard.setStatus("1");
                        consumeCards.add(jdCard);
                        jdECardCode.append("\u9762\u989d:" + jdCard.getProductCd().substring(3) + "\u5143,\u5361\u53f7\uff1a" + jdCard.getCardNo() + ",\u5bc6\u7801:" + FlgAseUtil.decrypt((String)(jdCard.getPaswwords() + " "), (String)this.KMKey));
                        if (++consumeCount < count) continue;
                        break;
                    }
                    resultMap.put("jdECardCode", FlgAseUtil.encrypt((String)jdECardCode.toString(), (String)this.KMKey));
                }
                this.jdCardRepo.save(consumeCards);
                resultMap.put("consumeCards", consumeCards);
            }
            catch (Exception e) {
                resultMap.put("resCode", "0007");
                resultMap.put("resMessage", "\u7cfb\u7edf\u9519\u8bef");
                e.printStackTrace();
                this.log.error("\u4eac\u4e1cE\u5361\u6d88\u8d39\u5f02\u5e38" + e.getMessage());
                return resultMap;
            }
            resultMap.put("resCode", "0000");
            resultMap.put("resMessage", "\u6210\u529f");
        }
        return resultMap;
    }
}

