/*
 * Decompiled with CFR 0.152.
 */
package ctscore.service.config;

import com.weibo.api.motan.config.springsupport.BasicServiceConfigBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import utils.Lang;

public class ServiceMotanConfig {
    @Bean(name={"motanServerBasicConfig"})
    @ConditionalOnMissingBean
    public BasicServiceConfigBean baseServiceConfig(@Value(value="${motan.export.port}") String port, @Value(value="${motan.service.group:sinomall}") String motanServerGroup, @Value(value="${motan.service.access.log:false}") Boolean motanServerAccessLog) {
        BasicServiceConfigBean config = new BasicServiceConfigBean();
        config.setDefault(true);
        config.setExport("motan:" + port);
        if (Lang.isEmpty((Object)motanServerGroup)) {
            config.setGroup("sinomall");
        } else {
            config.setGroup(motanServerGroup);
        }
        if (Lang.isEmpty((Object)motanServerAccessLog)) {
            config.setAccessLog(true);
        } else {
            config.setAccessLog(motanServerAccessLog.booleanValue());
        }
        config.setShareChannel(Boolean.valueOf(true));
        config.setRequestTimeout(Integer.valueOf(60000));
        config.setRegistry("registry");
        return config;
    }
}

