
$(function(){


    $("#editCityAddress").click(function () {
        var provinceCode = $("#editProvinceAddress")[0].name;
        //console.log(provinceCode);
        var valueList = $(".cityAddress").parent().find(".valueList");
        //console.log(valueList.has("li").length);
        if (valueList.has("li").length == 0){
            getCity(provinceCode);
        }
    });

    $("#editDistrictAddress").click(function () {
        var cityCode  = $("#editCityAddress")[0].name;
        //console.log(cityCode);
        var valueList = $(".districtAddress").parent().find(".valueList");
        //console.log(valueList.has("li").length);
        if (valueList.has("li").length == 0){
            getArea(cityCode);
        }
    });

});


/**
 * 省
 */
function getProvince() {
    //console.log("查询省份");

    $(".citySelect").hide();
    $(".districtSelect").hide();
    $(".townSelect").hide();

    getAreaFunc(1,'',function (data) {
        //console.log(data);
        //console.log("查询成功");
        if(data.code == "0"){
            var dat = data.data;
            if(dat.status == "success"){
                var valueList = $(".provinceAddress").parent().find(".valueList");
                //console.log(valueList);
                jQuery.each(dat.data,function (n,value) {
                    //console.log(value);
                    valueList.append("<li><a href='javascript:void(0)' name='1' id="+value.id+" data-id=''>"+value.shortName+"</a></li>");
                });
            }
        }
    })
}

/**
 * 获取城市
 * @param parentId
 */
function getCity(parentId) {
    //console.log("查询城市");


    var valueList = $(".cityAddress").parent().find(".valueList");
    valueList.html("");

    //清空城市 和 区
    $("#addCityAddress").val("");
    $("#editCityAddress").val("");
    $("#addDistrictAddress").val("");
    $("#editDistrictAddress").val("");
    $("#addAreaAddress").val("");
    $("#editAreaAddress").val("");

    getAreaFunc(2,parentId,function (data) {
        //console.log(data);
        //console.log("查询成功");
        if(data.code == "0"){
            var dat = data.data;
            if(dat.status == "success"){
                var citys = dat.data;
                if (citys.length == 1 && citys[0].remarks == 'direct'){
                    //console.log("直辖市");
                    var city = citys[0];

                    $("#addCityAddress").val(city.shortName);
                    $("#editCityAddress").val(city.shortName);

                    $("#addCityAddress")[0].name = city.code;
                    $("#editCityAddress")[0].name = city.code;

                    getArea(city.id,city.remarks);

                    $(".citySelect").hide();

                }else{
                    $(".citySelect").show();
                    $(".districtSelect").hide();
                    $(".townSelect").hide();

                    //console.log(valueList);
                    jQuery.each(citys,function (n,value) {
                        //console.log(value);
                        valueList.append("<li><a href='javascript:void(0)' name='2'  id="+value.id+" data-id=''>"+value.name+"</a></li>");
                    });
                }
            }
        }
    });
}

/**
 * 获取区
 * @param parentId
 */
function getArea(parentId,isDirect) {
    //console.log("查询区");


    var valueList = $(".districtAddress").parent().find(".valueList");
    valueList.html("");

    $("#addDistrictAddress").val("");
    $("#editDistrictAddress").val("");
    $("#addAreaAddress").val("");
    $("#editAreaAddress").val("");

    getAreaFunc(3,parentId,function (data) {
        //console.log(data);
        //console.log("查询成功");
        if(data.code == "0"){
            var dat = data.data;
            if(dat.status == "success"){



                if(isDirect != undefined && isDirect == 'direct'){
                    $(".citySelect").hide();
                    $(".districtSelect").show();
                    $(".townSelect").hide();
                    jQuery.each(dat.data,function (n,value) {
                        //console.log(value);
                        valueList.append("<li><a href='javascript:void(0)' name='3' id="+value.id+" data-id='direct' >"+value.name+"</a></li>");
                    });
                }else{
                    $(".citySelect").show();
                    $(".districtSelect").show();
                    $(".townSelect").hide();
                    jQuery.each(dat.data,function (n,value) {
                        //console.log(value);
                        valueList.append("<li><a href='javascript:void(0)' name='3' id="+value.id+" data-id='' >"+value.name+"</a></li>");
                    });
                }
            }
        }
    });
}

/**
 * 第四级别
 * @param parentId
 * @param isDirect
 */
function getSubArea(parentId,isDirect) {
    var valueList = $(".areaAddress").parent().find(".valueList");
    valueList.html("");

    $("#addAreaAddress").val("");
    $("#editAreaAddress").val("");

    getAreaFunc(4,parentId,function (data) {
        //console.log(data);
        //console.log("查询成功");
        if(data.code == "0"){
            var dat = data.data;
            if(dat.status == "success") {
                //console.log(valueList);

                if(dat.data.length > 0){

                    if(isDirect != undefined && isDirect == 'direct'){
                        $(".citySelect").hide();
                        $(".districtSelect").show();
                        $(".townSelect").show();
                    }else{
                        $(".citySelect").show();
                        $(".districtSelect").show();
                        $(".townSelect").show();
                    }

                } else {
                    $(".townSelect").hide();
                    $(".townSelect").find('input').val("");
                }
                jQuery.each(dat.data, function (n, value) {
                    //console.log(value);
                    valueList.append("<li><a href='javascript:void(0)' name='4' id=" + value.id + " data-id='direct' >" + value.name + "</a></li>");
                });

            }
        }
    });
}



//获取区域
function getAreaFunc(level,parentId,func) {

    if (level == undefined || level == null || level == ''){
        func({code:"-1"});
    }
    var url = "/score/areaCommon/findAll";
    if (level == 1){//省
        //获取省级别区域
        $.post(url,{level:level},function (data) {
            if (data.status == "success"){
                func({code:"0",data:data});
            }else {
                func({code:"1"});
            }
        });
    }else if(level == 2 || level ==3 || level ==4){//市 和 区 镇
        if (parentId !=undefined && parentId != null && parentId != ''){
            $.post(url,{level:level,parentId:parentId},function (data) {
                if (data.status == "success"){
                    func({code:"0",data:data});
                }else {
                    func({code:"1"});
                }
            });
        }
    }else {
         func({code:"1"});
    }
}


//新增按钮的点击
function newAdd(){
    $(".citySelect").hide();
    $(".districtSelect").hide();
    $(".townSelect").hide();

        $('.userPopup').show();
        $('.addAddress ').show();
}

function addBtnHide(){
    $('.userPopup').hide();
    $('.addAddress').hide();
}
//新增按钮点击的弹窗的确定按钮的点击

$('.sureAddBtn ').on('click',function(){
    var addressFlag = [false,false,false,false,false,false,false];
    cover($('.addName'));
    //if(chineseInput($('.addName '))==false){
    //    return false;
    //}
    cover($('.addTel'));
    //if(testPhone('.addTel')==false){
    //    return false;
    //}
    cover($('.addDetailsAddr'))
    //if(addDetailsAddr($('.addDetailsAddr'))==false){
    //    return false;
    //}
    addressFlag[0] = chineseInput($('.addName '));
    addressFlag[4] = testPhone('.addTel');
    addressFlag[5] = addDetailsAddr($('.addDetailsAddr'));
    var provinceObj = $("#addProvinceAddress"),
        cityObj = $("#addCityAddress"),
        districtObj = $("#addDistrictAddress"),
        townObj = $("#addAreaAddress");
    var objParent = ".selectSimulate";
    clearErrorAddress(provinceObj,objParent);
    if(provinceObj.val()==""||provinceObj.val()==null||provinceObj.val()==undefined||provinceObj.val()=="请选择省"){
        var errorText = "请选择省";
        showErrorAddress(provinceObj,objParent,errorText);
        addressFlag[1] = false;
    }else{
        addressFlag[1] = true;
    }
    clearErrorAddress(cityObj,objParent);
    if(cityObj.is(":visible")){
        if(cityObj.val()==""||cityObj.val()==null||cityObj.val()==undefined||cityObj.val()=="请选择市"){
            var errorText = "请选择市";
            showErrorAddress(cityObj,objParent,errorText);
            addressFlag[2] = false;
        }else{
            addressFlag[2] = true;
        }
    }else{
        addressFlag[2] = true;
    }
    clearErrorAddress(districtObj,objParent);
    if(districtObj.val()==""||districtObj.val()==null||districtObj.val()==undefined||districtObj.val()=="请选择区"){
        var errorText = "请选择区";
        showErrorAddress(districtObj,objParent,errorText);
        addressFlag[3] = false;
    }else{
        addressFlag[3] = true;
    }
    
    clearErrorAddress(townObj,objParent);
    if(townObj.is(":visible")){
        if(townObj.val()==""||townObj.val()==null||townObj.val()==undefined||townObj.val()=="请选择街道"){
            var errorText = "请选择街道";
            showErrorAddress(townObj,objParent,errorText);
            addressFlag[6] = false;
        }else{
            addressFlag[6] = true;
        }
    }else{
        addressFlag[6] = true;
    }
    var flagTrue = addressFlag[0] && addressFlag[1] && addressFlag[2] && addressFlag[3] && addressFlag[4] && addressFlag[5] && addressFlag[6];

    var postData = {
        username:$("#addName").val(),
        tel:$("#addTel").val(),
        phone:$("#addTel").val(),
        detailaddress:$("#addDetailsAddr").val(),
        addressDetail:$("#addDetailsAddr").val(),
        provinceCode:$("#addProvinceAddress")[0].name,
        provinceName:$("#addProvinceAddress").val(),
        cityCode:$("#addCityAddress")[0].name,
        cityName:$("#addCityAddress").val(),
        areaCode:$("#addDistrictAddress")[0].name,
        areaName:$("#addDistrictAddress").val(),
        townCode: $("#addAreaAddress")[0].name,
        townName:$("#addAreaAddress").val()
    };

    if (postData.provinceCode == undefined || postData.provinceName == undefined){
        return;
    }
    if (postData.cityCode == undefined || postData.cityName == undefined){
        return;
    }
    if (postData.areaCode == undefined || postData.areaName == undefined){
        return;
    }


    //console.log(postData);

    //添加地址
    if(flagTrue){
        $.post("/score/address/add",postData,function (data) {
            if(data.code == "0"){
                //必填项全部校验完之后保存数据并更新收货地址列表；
                addBtnHide();
                window.location.reload();
                //window.location.href = document.location.protocol + "//" + document.domain + "/score";
            }
        });
    }else{
        return false;
    }


})
$('.cancelAddBtn ').on('click',function(){
    addBtnHide();
    $('.red').remove();

    $("#addName").val("");
    $("#addTel").val("");
    $("#addTel").val("");
    $("#addDetailsAddr").val("");
    $("#addDetailsAddr").val("");
    $("#addProvinceAddress")[0].name="";
    $("#addProvinceAddress").val("");
    $("#addCityAddress")[0].name="";
    $("#addCityAddress").val("")
    $("#addDistrictAddress")[0].name="";
    $("#addDistrictAddress").val("");
    $("#addDistrictAddress")[0].name="";
    $("#addDistrictAddress").val("");
    $("#addAreaAddress")[0].name="";
    $("#addAreaAddress").val("");

})

//设为默认按钮点击
$('.myInForDetail').find('.setDefaut').on('click',function(){
   // $(this).hide();
   // $(this).siblings('.i1').hide();
    //将该行置于第一行
});

//编辑按钮点击
//function editSpan(){
//    //$('.addAddressCon h3').html('编辑收货地址'+'<span class="cancelAddBtn">X</span>');
//        $('.popupBg').show();
//        //$('.addAddress ').show();
//        $('.editAddress').show();
//}
$('.editSpan').on('click',function(){
    $('.userPopup').show();
    //$('.addAddress ').show();
    $('.editAddress').show();

});

/*
 * 修改收货地址
 */
function editAddress(address){
    //console.log(address);
    var memberAddress = JSON.parse(address);
   // console.log(memberAddress);

    $("#editId").val(memberAddress.id);

    $("#editName").val(memberAddress.username);
    $("#editTel").val(memberAddress.phone);
    $("#editDetailsAddr").val(memberAddress.addressDetail);

    $("#editProvinceAddress")[0].name = memberAddress.provinceCode;
    $("#editProvinceAddress").val(memberAddress.provinceName);
    $("#editCityAddress")[0].name=memberAddress.cityCode;
    $("#editCityAddress").val(memberAddress.cityName);
    $("#editDistrictAddress")[0].name=memberAddress.areaCode;
    $("#editDistrictAddress").val(memberAddress.areaName);
    $("#editAreaAddress")[0].name=memberAddress.townCode;
    $("#editAreaAddress").val(memberAddress.townName);

    $(".cityAddress").parent().find(".valueList").html("");
    $(".districtAddress").parent().find(".valueList").html("");
    $(".areaAddress").parent().find(".valueList").html("");

    getCity0(memberAddress.provinceCode,memberAddress);
}

function getCity0(parentId,memberAddress) {
    //console.log("查询城市");

    var valueList = $(".cityAddress").parent().find(".valueList");
    valueList.html("");

    $("#editCityAddress").val(memberAddress.cityName);

    getAreaFunc(2,parentId,function (data) {
        //console.log(data);
        //console.log("查询成功");
        if(data.code == "0"){
            var dat = data.data;
            if(dat.status == "success"){
                var citys = dat.data;

                $(".citySelect").show();
                if (citys.length == 1 && citys[0].remarks == 'direct'){
                    var city = citys[0];

                    $(".citySelect").hide();

                    getArea0(city.id,city.remarks,memberAddress);
                }else{
                    //console.log(valueList);
                    jQuery.each(citys,function (n,value) {
                        //console.log(value);
                        valueList.append("<li><a href='javascript:void(0)' name='2'  id="+value.id+" data-id=''>"+value.name+"</a></li>");
                    });
                    getArea0(memberAddress.cityCode,'',memberAddress);
                }
            }
        }
    });
}

function getArea0(parentId,isDirect,memberAddress) {
    //console.log("查询区");
    var valueList = $(".districtAddress").parent().find(".valueList");
    valueList.html("");

    $("#editDistrictAddress").val(memberAddress.areaName);

    $(".districtSelect").show();

    getAreaFunc(3,parentId,function (data) {
        //console.log(data);
        //console.log("查询成功");
        if(data.code == "0"){
            var dat = data.data;
            if(dat.status == "success"){

                if(isDirect != undefined && isDirect == 'direct'){
                    jQuery.each(dat.data,function (n,value) {
                        //console.log(value);
                        valueList.append("<li><a href='javascript:void(0)' name='3' id="+value.id+" data-id='direct' >"+value.name+"</a></li>");
                    });
                    getSubArea0(memberAddress.areaCode,isDirect,memberAddress);
                }else{
                    jQuery.each(dat.data,function (n,value) {
                        //console.log(value);
                        valueList.append("<li><a href='javascript:void(0)' name='3' id="+value.id+" data-id='' >"+value.name+"</a></li>");
                    });
                    getSubArea0(memberAddress.areaCode,'',memberAddress);
                }

            }
        }
    });
}

/**
 * 第四级别
 * @param parentId
 * @param isDirect
 */
function getSubArea0(parentId,isDirect,memberAddress) {
    var valueList = $(".areaAddress").parent().find(".valueList");
    valueList.html("");

    $(".townSelect").show();
    if(memberAddress.townCode == undefined || memberAddress.townCode==''){
        $(".townSelect").hide();
        return;
    }

    $("#editAreaAddress").val(memberAddress.townName);

    getAreaFunc(4,parentId,function (data) {
        //console.log(data);
        //console.log("查询成功");
        if(data.code == "0"){
            var dat = data.data;
            if(dat.status == "success") {
                //console.log(valueList);

                jQuery.each(dat.data, function (n, value) {
                    //console.log(value);
                    valueList.append("<li><a href='javascript:void(0)' name='4' id=" + value.id + " data-id='direct' >" + value.name + "</a></li>");
                });

            }
        }
    });
}



function editBtnHide(){
    $('.userPopup').hide();
    $('.editAddress').hide();
}
//编辑按钮的弹窗的确定按钮的点击
$('.sureEditBtn ').on('click',function(){
    cover($('.editName'));
    //if(chineseInput1($('.editName '))==false){
    //    return false;
    //}
    cover($('.editTel'));
    //if(testPhone1('.editTel')==false){
    //    return false;
    //}
    cover($('.editDetailsAddr'));
    //if(addDetailsAddr1($('.editDetailsAddr'))==false){
    //    return false;
    //}
    var addressFlag = [false,false,false,false,false,false,false];
    addressFlag[0] = chineseInput1($('.editName '));
    addressFlag[4] = testPhone1('.editTel');
    addressFlag[5] = addDetailsAddr1($('.editDetailsAddr'));
    var provinceObj = $("#editProvinceAddress"),
        cityObj = $("#editCityAddress"),
        districtObj = $("#editDistrictAddress"),
        townObj = $("#editAreaAddress");
        var objParent = ".selectSimulate";
        clearErrorAddress(provinceObj,objParent);
        if(provinceObj.val()==""||provinceObj.val()==null||provinceObj.val()==undefined||provinceObj.val()=="请选择省"){
            var errorText = "请选择省";
            showErrorAddress(provinceObj,objParent,errorText);
            addressFlag[1] = false;
        }else{
            addressFlag[1] = true;
        }
        clearErrorAddress(cityObj,objParent);
    if(cityObj.is(":visible")){
        if(cityObj.val()==""||cityObj.val()==null||cityObj.val()==undefined||cityObj.val()=="请选择市"){
            var errorText = "请选择市";
            showErrorAddress(cityObj,objParent,errorText);
            addressFlag[2] = false;
        }else{
            addressFlag[2] = true;
        }
    }else{
        addressFlag[2] = true;
    }
        clearErrorAddress(districtObj,objParent);
        if(districtObj.val()==""||districtObj.val()==null||districtObj.val()==undefined||districtObj.val()=="请选择区"){
            var errorText = "请选择区";
            showErrorAddress(districtObj,objParent,errorText);
            addressFlag[3] = false;
        }else{
            addressFlag[3] = true;
        }
    clearErrorAddress(townObj,objParent);
    if(townObj.is(":visible")){
        if(townObj.val()==""||townObj.val()==null||townObj.val()==undefined||townObj.val()=="请选择街道"){
            var errorText = "请选择街道";
            showErrorAddress(townObj,objParent,errorText);
            addressFlag[6] = false;
        }else{
            addressFlag[6] = true;
        }
    }else{
        addressFlag[6] = true;
    }
    var flagTrue = addressFlag[0] && addressFlag[1] && addressFlag[2] && addressFlag[3] && addressFlag[4] && addressFlag[5] && addressFlag[6];


    var postData = {
        id:$("#editId").val(),
        username:$("#editName").val(),
        tel:$("#editTel").val(),
        phone:$("#editTel").val(),
        detailaddress:$("#editDetailsAddr").val(),
        addressDetail:$("#editDetailsAddr").val(),
        provinceCode:$("#editProvinceAddress")[0].name,
        provinceName:$("#editProvinceAddress").val(),
        cityCode:$("#editCityAddress")[0].name,
        cityName:$("#editCityAddress").val(),
        areaCode:$("#editDistrictAddress")[0].name,
        areaName:$("#editDistrictAddress").val(),
        townCode: $("#editAreaAddress")[0].name,
        townName:$("#editAreaAddress").val()
    };

    //console.log(postData);

    if (postData.provinceCode == undefined || postData.provinceName == undefined){
        return;
    }
    if (postData.cityCode == undefined || postData.cityName == undefined){
        return;
    }
    if (postData.areaCode == undefined || postData.areaName == undefined){
        return;
    }


    //编辑地址
    if(flagTrue){
        loginValidate(editAddress_login);
    }else{
        return false;
    }
    function editAddress_login(){
        $.post("/score/address/add",postData,function (data) {
            if(data.code == "0"){
                //必填项全部校验完之后保存数据并更新收货地址列表；
                editBtnHide();
                //window.location.href = document.location.protocol + "//" + document.domain + "/score";
                window.location.reload();
            }
        });
    }

})

$('.cancelEditBtn').on('click',function(){
    editBtnHide();
    $('.red').remove();
});

//删除按钮点击
$('.myInForDetail').find('.detSpan').on('click',function(){
    $('.userPopup').show();
    $('.delete').show();


})
function delBtnHide(){
    $('.userPopup').hide();
    $('.delete').hide();
}

/**
 * 删除
 * @param id
 */
function deleteAddress(id){
    //console.log(id);
    $("#deleteAddressId").val(id);
}

$('.sureDelBtn').on('click',function(){
    loginValidate(deleteAddress_login);
});
function deleteAddress_login(){
    var postData = {
        addressId:$("#deleteAddressId").val()
    };
    $.post("/score/address/delete",postData,function (data) {
        if(data.code == "0") {
            //window.location.href = document.location.protocol + "//"  + document.domain + "/score";
            window.location.reload();
            $("#deleteAddressId").val("");
            delBtnHide();
        }else {

        }
    });
}

$('.cancelDelBtn').on('click',function(){
    $("#deleteAddressId").val("");
    delBtnHide();
})

// 新增弹窗收货人只输入汉字
function chineseInput(obj){
    obj=$(obj);
    //alert(obj);
    evt = window.event;
    var addNameInput=$('.addName');
    var addName=$('.addName').val();
    var chinese = /^[(\u4e00-\u9fa5)|a-zA-Z]+$/;
    var  chineseFlag=chinese.test(obj.val());
    if(obj.val()==""||obj.val()==null||obj.val()==undefined){
        cover(obj);
        red(obj);
        $("#"+$('.addName').attr("id")+"red").html('请输入收货人');
        return false;
    }else if(!chineseFlag){
        cover(obj);
        red(obj);
        $("#"+$('.addName').attr("id")+"red").html('请核对收货人是否输入正确');
        return false;
    }else{
        cover(obj);
    }
    return true;
}
//新增按钮弹窗手机号码校验
function testPhone(obj){
    obj=$(obj);
    //alert(obj);
    var addTel=$('.addTel').val();
    var addTelInput =$('.addTel');
    //var pattern =  /^(((13[0-9]{1})|(15[0-9]{1})|(18[0-9]{1}))+\d{8})$/;//验证手机号码的格式
    var pattern=/^1(3|4|5|7|8)\d{9}$///验证手机号码的格式
    //obj= obj.replace(/\s+/g,"");//去掉手机号码中的空格
    var phoneFlag=pattern.test(obj.val());
    if(obj.val()==""||obj.val()==null||obj.val()==undefined){
        cover(obj);
        red(obj);
        $("#"+$('.addTel').attr("id")+"red").html('请输入手机号码');
        return false;
    }else if(!phoneFlag||obj.val().length<11){
        cover(obj);
        red(obj);
        $("#"+$('.addTel').attr("id")+"red").html('请核对手机号码是否输入正确');
        return false;
    }else {
        cover(obj);
    }
    return true;
}
//新增按钮弹窗详细地址校验
function addDetailsAddr(obj){
    obj=$(obj);
    var addDetailsAddr=$('.addDetailsAddr').val();
    cover($('.addDetailsAddr'));
    if(obj.val()==''||obj.val()==null||obj.val()==undefined){
        cover(obj);
        red(obj);
        $("#"+$('.addDetailsAddr').attr("id")+"red").html('请输入详细地址');
        return false;
    }else{
        cover(obj);
    }
    return true;
}

// 编辑按钮弹窗收货人只输入汉字
function chineseInput1(obj){
    obj=$(obj);
    //alert(obj);
    evt = window.event;
    var editNameInput=$('.editName');
    var editName=$('.editName').val();
    var chinese = /^[\u4e00-\u9fa5|a-zA-Z]+$/;
    var  chineseFlag=chinese.test(obj.val());
    if(obj.val()==""||obj.val()==null||obj.val()==undefined){
        cover(obj);
        red(obj);
        $("#"+$('.editName').attr("id")+"red").html('请输入收货人');
        return false;
    }else if(!chineseFlag){
        cover(obj);
        red(obj);
        $("#"+$('.editName').attr("id")+"red").html('请核对收货人是否输入正确');
        return false;
    }else{
        cover(obj);
    }
    return true;
}
//编辑按钮弹窗手机号码校验
function testPhone1(obj){
    obj=$(obj);
    //alert(obj);
    var editTel=$('.editTel').val();
    var editTelInput =$('.editTel');
    //var pattern =  /^(((13[0-9]{1})|(15[0-9]{1})|(18[0-9]{1}))+\d{8})$/;//验证手机号码的格式
    var pattern=/^1(3|4|5|7|8)\d{9}$///验证手机号码的格式
    //obj= obj.replace(/\s+/g,"");//去掉手机号码中的空格
    var phoneFlag=pattern.test(obj.val());
    if(obj.val()==""||obj.val()==null||obj.val()==undefined){
        cover(obj);
        red(obj);
        $("#"+$('.editTel').attr("id")+"red").html('请输入手机号码');
        return false;
    }else if(!phoneFlag||obj.val().length<11){
        cover(obj);
        red(obj);
        $("#"+$('.editTel').attr("id")+"red").html('请核对手机号码是否输入正确');
        return false;
    }else {
        cover(obj);
    }
    return true;
}
//编辑按钮弹窗详细地址校验
function addDetailsAddr1(obj){
    obj=$(obj);
    var editDetailsAddr=$('.editDetailsAddr').val();
    cover($('.editDetailsAddr'));
    if(obj.val()==''||obj.val()==null||obj.val()==undefined){
        cover(obj);
        red(obj);
        $("#"+$('.editDetailsAddr').attr("id")+"red").html('请输入详细地址');
        return false;
    }else{
        cover(obj);
    }
    return true;
}

//手机号码只能输入数字
function mobile(obj){
    evt = window.event;
    obj.value = obj.value.replace(/[^\d\s]/g,'');
}
function red(obj){
    obj=$(obj);
    obj.addClass('redInput');
    var id=obj.attr("id");
    //obj.parent().after('<p id="'+id+'red" class="red"></p>');
    obj.parent().after("<p id=\""+id+"red\" class=\"red  \"></p>");
}

function cover(obj){
    obj=$(obj);
    obj.removeClass('redInput');
    var id=obj.attr("id");
    $("#"+id+"red").remove();
}
$(document).on('click','.selectSimulate input',function(){
    var selectDiv = $(this).parent('.selectSimulate'),
        selectList = selectDiv.children('ul');
    document.activeElement.blur();
    //selectList.width(selectDiv.width()-2);
    selectList.slideDown(200);
    selectList.width(selectDiv.width()-3);
});

//选中值
$(document).on('click','.valueList a',function(){

   //console.log($(this));

    var selectValue = $(this).html(),
         selectList = $(this).parents('ul');
    $(this).parents('.selectSimulate').find('input').val(selectValue);
    var inputPlaeholder = $(this).parents('.selectSimulate').find('input').attr('placeholder');
    var obj = $(this).parents('.selectSimulate').find('input'),
        objParent = ".selectSimulate";
    clearErrorAddress(obj,objParent);
    if(obj.val()==""||obj.val()==null||obj.val()==undefined||obj.val()==inputPlaeholder){
        var errorText = inputPlaeholder;
        showErrorAddress(obj,objParent,errorText);
    }

    var selectCode = $(this)[0].id;
    //console.log(selectCode);

    var input = $(this).parents('.selectSimulate').find('input');
    input[0].name=selectCode;
    //console.log(input);

    var level = $(this)[0].name;

    var isDirect = $(this).attr("data-id");

    if (level == '1'){
        getCity(selectCode);//获取城市
    }else if(level == '2'){
        if(isDirect == 'direct'){
            getSubArea(selectCode,isDirect);//获取第四级
        }else{
            getArea(selectCode);//获取区
        }
    }else if(level == '3'){
        if(isDirect == 'direct'){
            getSubArea(selectCode,isDirect);//获取第四级
        }else{
            getSubArea(selectCode);//获取镇
        }
    }else if(level === '4'){

    }


    selectList.slideUp(200);
});

$(document).on('mouseleave','.selectSimulate',function(){
    var selectList = $(this).children('ul');
    selectList.slideUp(200);
});

function showErrorAddress(obj,objParent,error){
    var errorP = "<p class='red'>"+ error +"</p>";
    $(obj).parents(objParent).append(errorP);
}
function clearErrorAddress(obj,objParent){
    $(obj).parents(objParent).find('.red').remove();
}
$('.provinceAddress').on('input',function(){
    var obj = $(this),
        objParent = ".selectSimulate";
    clearErrorAddress(obj,objParent);
    if(obj.val()==""||obj.val()==null||obj.val()==undefined||obj.val()=="请选择省"){
        var errorText = "请选择省";
        showErrorAddress(obj,objParent,errorText);
    }
});
$('.cityAddress').on('input',function(){
    var obj = $(this),
        objParent = ".selectSimulate";
    clearErrorAddress(obj,objParent);
    if(obj.val()==""||obj.val()==null||obj.val()==undefined||obj.val()=="请选择市"){
        var errorText = "请选择市";
        showErrorAddress(obj,objParent,errorText);
    }
});
$('.districtAddress').on('input',function(){
    var obj = $(this),
        objParent = ".selectSimulate";
    clearErrorAddress(obj,objParent);
    if(obj.val()==""||obj.val()==null||obj.val()==undefined||obj.val()=="请选择区"){
        var errorText = "请选择区";
        showErrorAddress(obj,objParent,errorText);
    }
});




