package ctscore.web.config;

import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Properties;

/**
 * Created by xiaoqian on 2016/10/24.
 */
@Configuration
public class KaptchaConfig {


    public static String kaptchaCode = "kaptcha_";

    @Bean(name = "kaptchaProperties")
    Properties config (){
        Properties properties = new Properties();
        properties.put("kaptcha.border","no");
        properties.put("kaptcha.border.color","105,179,90");
        properties.put("kaptcha.textproducer.font.color","blue");
        properties.put("kaptcha.image.widthr",125);
        properties.put("kaptcha.image.height",45);
        properties.put("kaptcha.textproducer.font.size",45);
        properties.put("kaptcha.session.key",kaptchaCode);
        properties.put("kaptcha.image.height",45);
        properties.put("kaptcha.textproducer.char.length",4);
        properties.put("kaptcha.textproducer.font.names","宋体,楷体,微软雅黑");

        return properties;
    }

    @Bean
    DefaultKaptcha defaultKaptcha(){
        DefaultKaptcha defaultKaptcha = new DefaultKaptcha();
        defaultKaptcha.setConfig(new Config(config()));
        return defaultKaptcha;
    }

  /*  @Bean
    @Profile("dev")
    ServletRegistrationBean kaptcha(){
        KaptchaServlet servlet =  new KaptchaServlet();
        servlet.setProps(config());
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean(
                servlet  ,"/kaptcha/kaptcha");
        return servletRegistrationBean;
    }*/
}
