package ctscore.web.config;


import ctscore.web.interceptor.ActivityUserInterceptor;
import ctscore.web.interceptor.CommonInterceptor;
import ctscore.web.interceptor.ContrapositiveInterceptor;
import exception.mapping.GlobalSimpleMappingExceptionResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.resource.VersionResourceResolver;
import utils.kaptcha.CheckUtils;
import utils.springmvc.ContentParaVersionStrategy;
import utils.springmvc.converter.fastjson.HibernateFastJsonConverter;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/**
 * Created by xiaoqian on 2016/10/12.
 */
@Configuration
public class SpringMvcConfig {


    @Bean
    CheckUtils checkUtils(StringRedisTemplate redisTemplate) {
        CheckUtils checkUtils = new CheckUtils();
        checkUtils.setRedisTemplate(redisTemplate);
        return checkUtils;
    }

    @Configuration
    @AutoConfigureOrder()
    protected static class MvcConfigurerAdapter extends WebMvcConfigurerAdapter {

        @Autowired
        CommonInterceptor commonInterceptor;

        @Autowired
        ActivityUserInterceptor activityUserInterceptor;
//        @Autowired
//        ContrapositiveInterceptor contrapositiveInterceptor;

        /*@Bean
        public OpenEntityManagerInViewInterceptor openEntityManagerInViewInterceptor() {
            return new OpenEntityManagerInViewInterceptor();
        }*/


        /**
         * 使用fastjson 替换默认的jackson，以便于序列化Hibernate对象
         */
        @Override
        public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
            super.configureMessageConverters(converters);
            Charset defCharset = Charset.forName("UTF-8");
            HibernateFastJsonConverter fastConverter = new HibernateFastJsonConverter();

            /** 配置FastJson */
            List<MediaType> mediaTypes = new ArrayList();
//            mediaTypes.add(new MediaType("text", "html", defCharset));
            mediaTypes.add(new MediaType("text", "json", defCharset));
            mediaTypes.add(new MediaType("application", "json", defCharset));
            fastConverter.setSupportedMediaTypes(mediaTypes);

//            fastConverter.setFeatures(SerializerFeature.DisableCircularReferenceDetect);


            converters.add(fastConverter);
        }

        @Override
        public void addInterceptors(InterceptorRegistry registry) {
            //registry.addWebRequestInterceptor()
            //registry.addWebRequestInterceptor(openEntityManagerInViewInterceptor()).excludePathPatterns("*.js", "*.css", "*.jpg", "*.png", "*.gif", "*.webp", "*.");
            registry.addInterceptor(commonInterceptor).addPathPatterns("/**").excludePathPatterns("*.js", "*.css", "*.jpg", "*.png", "*.gif", "*.webp", "*.");
            registry.addInterceptor(activityUserInterceptor).addPathPatterns("/**").excludePathPatterns("*.js", "*.css", "*.jpg", "*.png", "*.gif", "*.webp", "*.", "/login", "/dologin", "/dologout");
//            registry.addInterceptor(contrapositiveInterceptor).addPathPatterns("/**").excludePathPatterns("*.js", "*.css", "*.jpg", "*.png", "*.gif", "*.webp", "*.");
        }

        @Override
        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler("/**")
                    .addResourceLocations("classpath:/META-INF/resources/"
                            , "classpath:/resources/", "classpath:/static/"
                            , "classpath:/public/")
                    .setCachePeriod(365 * 24 * 3600 * 1000)
                    // .setCacheControl(new CacheControl())
                    .resourceChain(true).addResolver(new VersionResourceResolver()
                    .addVersionStrategy(new ContentParaVersionStrategy(), "/**"));
        }

    }

    ;

    @Bean(name = "simpleMappingExceptionResolver")
    @ConditionalOnProperty("exception.enable")
    @Profile("test")//test环境才生效
    public GlobalSimpleMappingExceptionResolver
    createSimpleMappingExceptionResolver() {
        GlobalSimpleMappingExceptionResolver r =
                new GlobalSimpleMappingExceptionResolver();

        Properties mappings = new Properties();
        mappings.setProperty("DatabaseException", "defaultErrorPage");
        mappings.setProperty("InvalidCreditCardException", "defaultErrorPage");
        mappings.setProperty("CustomException", "defaultErrorPage");
        mappings.setProperty("MotanServiceException", "defaultErrorPage");
        mappings.setProperty("NullPointerException", "defaultErrorPage");
        mappings.setProperty("SpelEvaluationException", "defaultErrorPage");

        r.setExceptionMappings(mappings);  // None by default
        r.setDefaultErrorView("error");    // No default
        r.setExceptionAttribute("ex");     // Default is "exception"
        r.setWarnLogCategory("error");     // No default
        return r;
    }

}
