package ctscore.web.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import sinomall.config.common.CommonMotanConfig;
import sinomall.config.common.CommonRedisConfig;
import sinomall.config.web.*;
import utils.filter.FrontEndLoginItaipingCheckFilter;

/**
 * Created by xiaoqian on 2016/10/24.
 */
@Configuration
@ComponentScan({"utils.lock"})
@ImportAutoConfiguration({
        CommonMotanConfig.class,
        CommonWebMotanConfig.class,
        CommonRedisConfig.class,
        WebSessionConfig.class,
        WebSpringMvcConfig.class,
        WebFreeMarkerConfig.class,
        CommonWebConfig.class

})
@ConfigurationProperties(prefix = "security")
public class WebConfig {
    @Bean
    public FrontEndLoginItaipingCheckFilter frontEndLoginItaipingCheckFilter(
            @Value("${login.excludeUrls}")String excludeUrls,
            @Value("${login.loginUrl}")String loginUrl,
            @Value("${login.checkUrls}")String checkUrls,
            @Value("${login.defaultSuccessUrl}")String defaultSuccessUrl
    ){
        FrontEndLoginItaipingCheckFilter frontEndLoginItaipingCheckFilter =  new FrontEndLoginItaipingCheckFilter();
        frontEndLoginItaipingCheckFilter.setExcludeUrls(excludeUrls);
        frontEndLoginItaipingCheckFilter.setLoginUrl(loginUrl);
        frontEndLoginItaipingCheckFilter.setCheckUrls(checkUrls);
        frontEndLoginItaipingCheckFilter.setDefaultSuccessUrl(defaultSuccessUrl);

        return frontEndLoginItaipingCheckFilter;
    }




}
