package ctscore.web.controller.activity;

import activities.api.ActivityConfigurationApi;
import activities.api.ActivityGoodsApi;
import activities.vo.ActivityConfigurationVo;
import activities.vo.ActivityVo;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.Lang;

import java.util.*;

import static utils.data.Jsons.map2json;

/**
 * Created by zfb on 2016/10/17.
 */
@Controller
@RequestMapping("activity")
public class activityController {

	final static Logger logger = LoggerFactory.getLogger(activityController.class);

	//秒杀
	@Value("${secKillActivity.activityCode}")
	private String secKillActivityCode;
	@Value("${secKillStore.code}")
	private String secKillStoreCode;

	//团购
	@Value("${tuanGouActivity.activityCode}")
	private String tuanGouActivityCode;
	@Value("${tuanGouStore.code}")
	private String tuanGouStoreCode;

	@Value("${ctscore.organization.code}")
	private String organizationCode;


	@MotanReferer
	ActivityConfigurationApi activityConfigurationApi;

	/**
	 * 跳转秒杀活动页
	 * @param map modelAndView
	 * @param activityIndex 活动下标
	 * @return 活动页面
	 */
	@RequestMapping("/activityPage")
	public String activityPage(Map<String, Object> map, Integer activityIndex, String activitySign) {
		if (activityIndex == null) {
			activityIndex = 0;
		}
		ActivityConfigurationVo activityConfigurationTuanGou = activityConfigurationApi.getActivityByCode(organizationCode, tuanGouActivityCode);
		ActivityConfigurationVo activityConfigurationSecKill = activityConfigurationApi.getActivityByCode(organizationCode, secKillActivityCode);
		//团购场次时间段
		map.put("activityIndex", activityIndex);
		map.put("activitySign", activitySign);
		map.put("activityConfigurationTuanGou",activityConfigurationTuanGou);
		map.put("activityConfigurationSecKill",activityConfigurationSecKill);
        if("seckill".equals(activitySign)){
			return "index/activity/activitySecKillGoods";
		}else {
			return "index/activity/activityTuanGouGoods";
		}
	}

	/**
	 * 根据显示对应商品信息
	 * @param activityDefinitionId 活动id
	 * @param activityCode 活动code
	 * @return List
	 */
	@RequestMapping("/getGoodsListByActivityId")
	@ResponseBody
	public List<ActivityVo> getGoodsListByActivityId(String activityDefinitionId, String activityCode) {
		List<ActivityVo> activityVoList = null;
		String stockPercent = null;
		String storeCode = null;
		if(!Lang.isEmpty(activityDefinitionId)&&!Lang.isEmpty(activityCode)){
			if (secKillActivityCode.equals(activityCode)) {
				storeCode = secKillStoreCode;
			} else if (tuanGouActivityCode.equals(activityCode)) {
				storeCode = tuanGouStoreCode;
			}
			activityVoList = activityConfigurationApi.getGoodsListByActivityId(organizationCode, activityDefinitionId, activityCode, storeCode);
		}

		//判断是否是秒杀商品
		if(!Lang.isEmpty(activityVoList) && activityVoList.size()>0){
			//秒杀商品设置百分比
			//活动商品设置市场价
			if (secKillActivityCode.equals(activityCode)) {
				for (ActivityVo activityVo : activityVoList){
					stockPercent = activityConfigurationApi.getStockPercent(activityDefinitionId,activityVo.getGoodsPicture().getGoods().getId());
					activityVo.setStockPercent(stockPercent);
				}
			}
		}
		return activityVoList;
	}

	//每秒请求一次，获取系统时间，当前秒杀场次结束时间，下一场次的秒杀开始时间
	@RequestMapping("/getSystemTime")
	@ResponseBody
	public Map<String, Object> getSystemTime(Integer activityIndex, String activityCode) {
        Map<String, Object> map = activityConfigurationApi.getSystemTime(activityIndex, organizationCode, activityCode);
        return map;
	}

	//获取当前正在进行的活动的id
	@ResponseBody
	@RequestMapping("/getCurrentActivityId")
	public String getCurrentActivityId(String activityCode) {
		String currentId = null;
		if(!Lang.isEmpty(activityCode)){
			currentId = activityConfigurationApi.getCurrentActivityId(organizationCode, activityCode);
		}
		return currentId;
	}

	/**
	 * 重新加载活动数据
	 * @return
	 */
	@ResponseBody
	@RequestMapping("/reload")
	public String reload(){
		String result;
		List<String> activityCodes = new ArrayList<>();
		activityCodes.add(secKillActivityCode);
		activityCodes.add(tuanGouActivityCode);
		result = activityConfigurationApi.reload(organizationCode, activityCodes);
		return result;
	}

	@RequestMapping(value = "/viewStock", method = RequestMethod.GET)
	public String viewStock(){
		return "goods/viewStock";
	}

	@RequestMapping(value = "/viewStock", method = RequestMethod.POST)
	@ResponseBody
	public String showStock(){
		Map<String, Integer> seckill = activityConfigurationApi.getStockFromRedis(organizationCode, secKillActivityCode);
		Map<String, Integer> tuangou = activityConfigurationApi.getStockFromRedis(organizationCode, tuanGouActivityCode);
		Map<String, Map<String, Integer>> map = new HashMap<>();
		map.put("seckill", seckill);
		map.put("tuangou", tuangou);
		String json = map2json(map);
		logger.info(json);
		return json;
	}


}
