package ctscore.web.controller.cart;

import cart.api.CartApi;
import cart.api.CartItemApi;
import cart.api.dto.cart.CartDto;
import cart.api.dto.cart.CartItemDto;
import cart.api.dto.goods.ProductFashionSpecificationDto;
import cart.api.dto.goods.ProductStandardDto;
import cart.api.vo.CartItemGroupVo;
import cart.api.vo.CartItemVo;
import cart.api.vo.ScorePriceVO;
import com.google.common.collect.Maps;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import ctscore.web.service.area.AreaService;
import ctscore.web.service.cart.service.CartWebService;
import ctscore.web.service.cart.service.OrderWebService;
import ctscore.web.service.login.LoginService;
import ctscore.web.vo.SpecificationsVo;
import goods.api.GoodsConfigApi;
import goods.api.ProductApi;
import goods.api.ProductFashionApi;
import goods.dto.product.ProductFashionDto;
import goods.model.Goods;
import goods.model.ProductFashion;
import goods.model.ProductFashionSpecification;
import goods.model.ProductStandard;
import goods.model.repository.GoodsRepos;
import goods.model.repository.ProductFashionRepos;
import ma.glasnost.orika.MapperFacade;
import member.api.AddressCommonApi;
import member.api.MemberAddressApi;
import member.api.MemberApi;
import member.api.MemberFavoriteApi;
import member.api.dto.common.AddressDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.dto.shop.MemberFavoriteDto;
import member.api.vo.MemberVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import outsideapi.api.OutsideProductApi;
import outsideapi.vo.FashionNumsVo;
import outsideapi.vo.FashionStatusRequetVo;
import outsideapi.vo.FashionStockStateVo;
import outsideapi.vo.HandlerRespVo;
import store.api.StoreApi;
import utils.GlobalContants;
import utils.Lang;
import utils.ip.IPtoLong;
import utils.log.Log;
import utils.log.Logs;
import utils.web.AddressUtils;
import utils.web.Webs;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Liang Wenxu on 2016/10/26.
 */
@Controller
@RequestMapping("/myCart")
public class MyCartController {
    private final static Log log = Logs.getLog(MyCartController.class.getName());

    @MotanReferer
    CartApi cartApi;

    @Autowired
    LoginService loginService;
    @MotanReferer
    CartItemApi cartItemApi;

    @MotanReferer
    MemberApi memberApi;

    @MotanReferer
    MemberAddressApi memberAddressApi;

    @Autowired
    CartWebService cartWebService;

    @Autowired
    OrderWebService orderWebService;

    @MotanReferer
    MemberFavoriteApi memberFavoriteApi;

    @MotanReferer
    ProductFashionApi productFashionApi;

    @Autowired
    ProductFashionRepos productFashionRepos;

    @MotanReferer
    ProductApi productApi;

    @MotanReferer
    AddressCommonApi addressCommonApi;

    @MotanReferer
    OutsideProductApi outsideProductApi;

    @MotanReferer
    StoreApi storeApi;

    @Autowired
    AreaService areaService;

    @Autowired
    MapperFacade mapperFacade;

//    @Value("${ctscore.score.proportion}")
//    private BigDecimal scorePortion;//积分比例

    //ctscore 个人中心 我的商品 url
    @Value("${itaiping.usercenter.goods}")
    private String itaipingUserCenterGoods;

    @Autowired
    GoodsRepos goodsRepos;

    @MotanReferer
    GoodsConfigApi goodsConfigApi;

    @Value("${ctscore.organization.code}")
    private String organizationCode;

    /**
     * 购物车首页
     *
     * @Author Akers
     * @DateCreated 2016/10/28
     */
    @RequestMapping(value = {"", "index", "index.html"})
    public String index(Map model, HttpServletRequest request, HttpServletResponse response) {
        long methodStart = System.currentTimeMillis();
        log.info("### 开始加载购物车数据... ###");

        long memeberVoTime = System.currentTimeMillis();
        MemberVo memberVo = loginService.findMemberVo(request);
        log.info("获取 memberVo 耗时 {} ms", System.currentTimeMillis() - memeberVoTime);

        long defaultAddrTime = System.currentTimeMillis();
        Map defaultAddr = getIpAddressIds(request, response);
        log.info("获取默认地址耗时 {} ms", System.currentTimeMillis() - defaultAddrTime);

        long cartTime = System.currentTimeMillis();
        CartDto cart = cartApi.getUserCart(memberVo.getUser().getId());
        log.info("获取用户购物车数耗时 {} ms", System.currentTimeMillis() - cartTime);

        List<CartItemGroupVo> cartItemGroups;
        Long cartItemGroupsTimer = System.currentTimeMillis();
        if (!Lang.isEmpty(defaultAddr)) {
            String areaCode = (String) defaultAddr.get("townId");
            areaCode = Lang.isEmpty(areaCode) ? (String) defaultAddr.get("areaId") : areaCode;
            areaCode = Lang.isEmpty(areaCode) ? (String) defaultAddr.get("cityId") : areaCode;
            areaCode = Lang.isEmpty(areaCode) ? (String) defaultAddr.get("provoiceId") : areaCode;
            cartItemGroups = cartWebService.findCartItemGroups(request, cart, "1", true, true, areaCode, null);
        } else {
            cartItemGroups = cartWebService.findCartItemGroups(request, cart, "1", false, false, null, null);
        }
        log.info("获取购物车分组数据耗时 {} ms", System.currentTimeMillis() - cartItemGroupsTimer);

        long cartItemGroupsSortTime = System.currentTimeMillis();
        cartItemGroups = cartApi.cartItemGroupsSort(cartItemGroups);
        log.info("购物车排序耗时 {} ms", System.currentTimeMillis() - cartItemGroupsSortTime);

        // 20180131 规格MAP
        Long specificationTime = System.currentTimeMillis();
        Map<String, List<SpecificationsVo>> specificationsMap = new HashMap<>();
        // 遍历店铺
        for (CartItemGroupVo cartItemGroupVo : cartItemGroups) {
            // 遍历商品
            for (CartItemVo cartItemVo : cartItemGroupVo.getCartItems()) {
                Goods goodsPO = goodsRepos.findOne(cartItemVo.getGoodsId());
                if(!Lang.isEmpty(goodsPO.getProductFashion()) && !Lang.isEmpty(goodsPO.getProductFashion().getProductFashionSpecifications())){
                    // 单个商品拥有的规格属性集合
                    List<SpecificationsVo> specificationsVos = new ArrayList<>();
                    if(!Lang.isEmpty(goodsPO.getProduct()) && !Lang.isEmpty(goodsPO.getProduct().getProductStandards())) {
                        // 排序
                        goodsPO.getProduct().getProductStandards().sort((productStandard1, productStandard2)->{
                            if(Lang.isEmpty(productStandard1) || Lang.isEmpty(productStandard1.getShowIndex())) {
                                return -1;
                            }
                            if(Lang.isEmpty(productStandard2) || Lang.isEmpty(productStandard2.getShowIndex())) {
                                return 1;
                            }
                            return productStandard1.getShowIndex() > productStandard2.getShowIndex() ? 1 : -1;
                        });
                        // 以规格 CODE 匹配，找到规格展示名
                        for (ProductStandard productStandard : goodsPO.getProduct().getProductStandards()) {
                            // 遍历商品拥有规格
                            for (ProductFashionSpecification productFashionSpecification : goodsPO.getProductFashion().getProductFashionSpecifications()) {
                                // 找到规格
                                if(!productStandard.getIsDelete() && productFashionSpecification.getStandardCode().equals(productStandard.getStandardCode())) {
                                    SpecificationsVo specificationsVo = new SpecificationsVo(productStandard.getName(), productFashionSpecification.getValue());
                                    specificationsVos.add(specificationsVo);
                                    break;
                                }
                            }
                        }
                    } else {
                        continue;
                    }

                    specificationsMap.put(cartItemVo.getGoodsId(), specificationsVos);
                }
            }
        }
        model.put("specificationsMap", specificationsMap);
        log.info("规格处理耗时：{} ms", System.currentTimeMillis() - specificationTime);

        long generatePriceResMapTime = System.currentTimeMillis();
        model = generatePriceResMap(request, cartItemGroups, null, model);
        log.info("添加各项金额合计到返回数据集合耗时 {} ms", System.currentTimeMillis() - generatePriceResMapTime);

        long addressMapTime = System.currentTimeMillis();
        Map addressMap = getIpAddressIds(request, response);
        log.info("获取地址耗时 {} ms", System.currentTimeMillis() - addressMapTime);

        model.putAll(addressMap);

        /** 禁止浏览器缓存 */
        if (request.getProtocol().compareTo("HTTP/1.0") == 0) {
            response.setHeader("Pragma", "no-cache");
        } else if (request.getProtocol().compareTo("HTTP/1.1") == 0) {
            response.setHeader("Cache-Control", "no-cache");
        }

        model.put("itaipingUserCenterGoods", itaipingUserCenterGoods);

        log.info("### 加载购物车数据总耗时 {} ms ###", System.currentTimeMillis() - methodStart);

        return "cart/myCart/index";
    }

    /**
     * 测试添加购物车
     *
     * @param params
     * @param request
     * @return
     */
    @RequestMapping("testAddCartItemApi")
    public String testAddCartItemApi(@RequestParam Map<String, Object> params, HttpServletRequest request) {

        return "myCart/testCartItemAdd";
    }

    /**
     * 添加产品到购物车
     *
     * @param params
     * @return
     */
    @RequestMapping(value = {"add", "add.json"})
    @ResponseBody
    public Map add(@RequestParam Map<String, Object> params, HttpServletRequest request) {
        HashMap<String, Object> rsMap = new HashMap<>(6);
        rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        rsMap.put(GlobalContants.ResponseString.DATA, null);
        rsMap.put(GlobalContants.ResponseString.ERROR_CODE, 0);
        rsMap.put(GlobalContants.ResponseString.MESSAGE, "suc");


        /** 获取当前用户的购物车信息 */
        MemberVo memberVo = loginService.findMemberVo(request);

        params.put("userId", memberVo.getUser().getId());
        if (Lang.isEmpty(params.get("counts"))) {
            params.put("counts", 1);
        } else {
            String countsStr = params.get("counts").toString();
            if (Lang.isEmpty(countsStr)) {
                params.put("counts", 1);
            } else {
                try {
                    params.put("counts", Integer.parseInt(countsStr));
                } catch (NumberFormatException nfe) {
                    params.put("counts", 1);
                }
            }
        }

        boolean isUp = goodsConfigApi.isUpGoodsId((String) params.get("goodsId"), organizationCode);
        if(!isUp) {
            rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
            rsMap.put(GlobalContants.ResponseString.DATA, null);
            rsMap.put(GlobalContants.ResponseString.ERROR_CODE, "DOWN");
            rsMap.put(GlobalContants.ResponseString.MESSAGE, "商品已下架");
            rsMap.put("carts", cartApi.getCartSize((String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING)));
            return rsMap;
        }

        long addGoodsToCartTimer = System.currentTimeMillis();
        Map addRs = cartApi.addGoods(params);
        log.info("添加商品到购物车耗时 {} 秒", (System.currentTimeMillis() - addGoodsToCartTimer) / 1000.0);

        Integer addGoodsErr = (Integer) addRs.get("error");
        CartItemDto addResData = (CartItemDto) addRs.get("data");
        HashMap<String, Object> rsData = new HashMap<>(2);
        if (addResData != null) {
            rsData.put("carItemId", addResData.getId());
            rsData.put("count", addResData.getCount());
        }
        if (addGoodsErr == null || addGoodsErr != 0) {
            rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
            rsMap.put(GlobalContants.ResponseString.DATA, null);
            rsMap.put(GlobalContants.ResponseString.ERROR_CODE, addGoodsErr);

            switch (addGoodsErr) {
                case 1:
                    rsMap.put(GlobalContants.ResponseString.MESSAGE, "产品规格不存在");
                    break;
                case 2:
                    rsMap.put(GlobalContants.ResponseString.MESSAGE, "产品不存在");
                    break;
                case 3:
                    rsMap.put(GlobalContants.ResponseString.MESSAGE, "超出库存");
                    break;
            }

            rsMap.put(GlobalContants.ResponseString.MESSAGE, "suc");
        }

        rsMap.put("data", rsData);
        rsMap.put("carts", cartApi.getCartSize((String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING)));
        return rsMap;
    }

    /**
     * 刷新购物车
     *
     * @param params
     * @return
     */
    @RequestMapping(value = {"refresh", "refresh.json"})
    @ResponseBody
    public Map refreshCart(
            String cartId, String areaCode, Boolean getShippingFee, String addressId, Boolean refreshStock,
            @RequestParam(value = "cartItemIds[]", required = false) ArrayList<String> cartItemIds,
            @RequestParam Map<String, Object> params, HttpServletRequest request, HttpServletResponse response) {
        long methodStartTime = System.currentTimeMillis();
        log.info("### 开始刷新购物车 ... ###");
        HashMap<String, Object> rsMap = new HashMap<String, Object>();

        String userId = (String) request.getSession().getAttribute(GlobalContants.SESSION_USER_ID_ITAIPING);

        rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        rsMap.put("data", null);
        rsMap.put(GlobalContants.ResponseString.MESSAGE, GlobalContants.ResponseStatus.SUCCESS);
        refreshStock = refreshStock == null ? true : refreshStock;

        long cartTime = System.currentTimeMillis();
        CartDto cart = cartApi.getUserCart(userId);
        log.info("查询购物车对象耗时 {} ms", System.currentTimeMillis() - cartTime);

        if (cart != null) {
            Map<String, Object> resData = new HashMap<String, Object>();

            long cartItemGroupsTime = System.currentTimeMillis();
            List<CartItemGroupVo> cartItemGroups = cartWebService.findCartItemGroups(request, cart, "1", true, refreshStock, areaCode, cartItemIds);
            log.info("查询购物车商品分组数据耗时 {} ms", System.currentTimeMillis() - cartItemGroupsTime);

            /** 获取运费 */
            if (getShippingFee != null && getShippingFee) {
                if (!Lang.isEmpty(addressId)) {
                    Double shippingFee = 0.00;
                    for (CartItemGroupVo group : cartItemGroups) {
                        //获取运费
                        if (!Lang.isEmpty(addressId)) {
                            long feeTime = System.currentTimeMillis();
                            BigDecimal fee = orderWebService.queryCartShippingFee(group.getStoreId(), group.getCartItems(), addressId);
                            log.info("查询运费耗时 {} ms", System.currentTimeMillis() - feeTime);
                            if (fee != null) {
                                shippingFee += fee.doubleValue();
                            }
                            group.setShippingFee(fee);
                        }
                    }

                    resData.put("shippingFee", shippingFee);
                }
            }

            long cartItemGroupsSortTime = System.currentTimeMillis();
            cartItemGroups = cartApi.cartItemGroupsSort(cartItemGroups);
            log.info("购物车商品分组排序耗时 {} ms", System.currentTimeMillis() - cartItemGroupsSortTime);

            long generatePriceTime = System.currentTimeMillis();
            resData = this.generatePriceResMap(request, cartItemGroups, null, resData);
            log.info("购物车生成价格耗时 {} ms", System.currentTimeMillis() - generatePriceTime);


            for (CartItemGroupVo cartItemGroup : cartItemGroups) {
                for (CartItemVo cartItemVo : cartItemGroup.getCartItems()) {
                    ProductFashionDto productFashion = mapperFacade.map(cartItemVo.getProductFashion(),goods.dto.product.ProductFashionDto.class);
                    productFashion.setSalePrice(productFashion.getSalePrice().setScale(2, BigDecimal.ROUND_UP));
                }
            }
            rsMap.put("data", resData);
        }

        log.info("刷新购物车总耗时 {} ms", System.currentTimeMillis() - methodStartTime);
        return rsMap;
    }

    /**
     * 刷新产品型号状态
     *
     * @param params
     * @return
     */
    @RequestMapping(value = {"refreshFashion", "refreshFashion.json"})
    @ResponseBody
    public Map refreshFashionState(String fashionId, String productId, String areaCode, Integer counts,
                                   @RequestParam Map<String, Object> params,
                                   HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> rsMap = new HashMap<>(4);
        rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        rsMap.put("data", null);
        rsMap.put(GlobalContants.ResponseString.MESSAGE, GlobalContants.ResponseStatus.SUCCESS);

        // map ProductFashionDto 耗时 11s 左右
        /*ProductFashionDto fashion = productFashionApi.findById(fashionId);*/

        ProductFashion fashion = productFashionRepos.findOne(fashionId);

        if (fashion != null) {
            Map<Integer, String> areaNodeList = addressCommonApi.areaCodeNodeList(areaCode);
            FashionStatusRequetVo fashionStatusRequetVo = new FashionStatusRequetVo();
            fashionStatusRequetVo.setProvinceCode(areaNodeList.get(1));
            fashionStatusRequetVo.setCityCode(areaNodeList.get(2));
            fashionStatusRequetVo.setCountyCode(areaNodeList.get(3));
            fashionStatusRequetVo.setTownCode(areaNodeList.get(4));
            fashionStatusRequetVo.setFashionNums(new ArrayList<>());
            fashionStatusRequetVo.getFashionNums().add(
                    new FashionNumsVo(
                            fashion.getId(),
                            fashion.getProductCode(),
                            new Long(counts)
                    )
            );
            HandlerRespVo<List<FashionStockStateVo>> stateRes = outsideProductApi.getFashionStockState(storeApi.getStoreInfo(fashion.getProduct().getStoreId()), fashionStatusRequetVo);
            if(!Lang.isEmpty(stateRes.getData())) {
                FashionStockStateVo vo = stateRes.getData().get(0);
                if(!vo.getOnSale()) {
                    log.info("商品已下架");
                    vo.setStockFlag(0);
                }
            }

            rsMap.put("data", stateRes);
        }
        return rsMap;
    }

    /**
     * 删除购物车商品
     *
     * @param params
     * @return
     */
    @RequestMapping(value = {"itemDel", "itemDel.json"})
    @ResponseBody
    public Map deleteFromCart(@RequestParam Map<String, Object> params, HttpServletRequest request) {
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        rsMap.put("data", null);
        rsMap.put(GlobalContants.ResponseString.MESSAGE, "suc");
        String cartItemId = (String) params.get("cartItemId");
        /** 同时删除多条记录 */
        String cartItemIdsStr = (String) params.get("cartItemId");
        String[] cartItemIds = cartItemIdsStr.split(",");

        /** 获取当前用户的购物车信息 */
        MemberVo memberVo = loginService.findMemberVo(request);
        CartDto cart = cartApi.getUserCart(memberVo.getUser().getId());
        CartItemDto cartItem = cartItemApi.findById(cartItemId);

        Map<String, Object> apiRes = cartApi.deleteItem(cart.getId(), cartItemIds);
        cart = cartApi.getUserCart(memberVo.getUser().getId());
        List<CartItemGroupVo> cartItemGroups = cartWebService.findCartItemGroups(request, cart, "1", false, false, null, null);
        cartItemGroups = cartApi.cartItemGroupsSort(cartItemGroups);
        List<String> deletedItemIds = Lang.isEmpty(cartItemIds) ? new ArrayList<String>() : (List<String>) Lang.newList(cartItemIds);

        /** 提取已删除记录 */
        for (CartItemGroupVo group : cartItemGroups) {
            if (group != null) {
                for (CartItemVo item : group.getCartItems()) {
                    if (deletedItemIds.contains(item.getId())) {
                        deletedItemIds.remove(item.getId());
                    }
                }
            }
        }
//
//        /** 提取已删除记录 */
//        for(CartItemGroupVo group : cartItemGroups) {
//            if(group != null) {
//                for(CartItemVo item : group.getCartItems()) {
//
//                    if(item.getIsDelete()) {
//                        deletedItemIds.add(item.getId());
//                    }
//                }
//            }
//        }

        Map<String, Object> rsData = new HashMap<String, Object>();
        Map<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("deletedItemIds", deletedItemIds);
        returnData.putAll(apiRes);
        rsMap.put("data", generatePriceResMap(request, cartItemGroups, cartItemIds.length > 1 ? null : cartItem.getStoreId(), returnData));

//        Map<String, List> stringListMap = queryOrderApi.queryOrder(params);
        return rsMap;
    }

    /**
     * 删除无效商品
     *
     * @param params
     * @return
     */
    @RequestMapping(value = {"invalidDel", "invalidDel.json"})
    @ResponseBody
    public Map<String, Object> deleteInvalidFromCart(@RequestParam Map<String, Object> params, HttpServletRequest request) {
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        rsMap.put("data", null);
        rsMap.put(GlobalContants.ResponseString.MESSAGE, GlobalContants.ResponseStatus.SUCCESS);
        /** 获取当前用户的购物车信息 */
        MemberVo memberVo = loginService.findMemberVo(request);
        CartDto cart = cartApi.getUserCart(memberVo.getUser().getId());
//        Map<String, Object> apiRes = cartApi.deleteInvalidItems(cart.getId());

        Map<String, Object> apiRes = cartWebService.deleteInvalidItems(memberVo.getUser().getId());

        cart = cartApi.getUserCart(memberVo.getUser().getId());
        List<CartItemGroupVo> cartItemGroups = cartWebService.findCartItemGroups(request, cart, "1", false, false, null, null);
        cartItemGroups = cartApi.cartItemGroupsSort(cartItemGroups);
        /** 提取已删除记录 */
        List<String> deletedItemIds = new ArrayList<>();
        if (!Lang.isEmpty(apiRes) && !Lang.isEmpty(apiRes.get("detials"))) {
            List<Map> details = (List<Map>) apiRes.get("detials");
            for (Map m : details) {
                deletedItemIds.add((String) m.get("id"));
            }
        }
//
//        /** 提取已删除记录 */
//        for(CartItemGroupVo group : cartItemGroups) {
//            if(group != null) {
//                for(CartItemVo item : group.getCartItems()) {
//                    if(item.getIsDelete()) {
//                        deletedItemIds.add(item.getId());
//                    }
//                }
//            }
//        }

        Map<String, Object> rsData = new HashMap<String, Object>();
        Map<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("deletedItemIds", deletedItemIds);
        if (!Lang.isEmpty(apiRes)) {
            returnData.putAll(apiRes);
        }
        rsMap.put("data", generatePriceResMap(request, cartItemGroups, null, returnData));

        return rsMap;
    }

    /**
     * 获取当前登录用户的购物车（需授权）
     *
     * @param params
     * @return 返回JSON格式 Response Body：
     * 返回参数：
     * status: 处理状态，0--成功， 1-- 未授权访问（用户未登录或登录授权丢失）, 2-- 购物车获取错误，99-- 其它错误
     * data: 返回数据，JSON格式
     */
    @RequestMapping("/cartList.json")
    @ResponseBody
    public Map userCart(@RequestParam Map<String, Object> params, HttpServletRequest request) {
        Map<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put("status", "0");
        rsMap.put("data", null);
        rsMap.put("msg", "suc");
        MemberVo memberVo = loginService.findMemberVo(request);
        rsMap.put("data", memberVo);
        System.out.println("memberVo" + memberVo);
        /** 判断是否成功获取 member信息*/
        return rsMap;
    }

    /**
     * 更新购物车商品购买数量
     *
     * @param counts
     * @param cartItemId
     * @param debug
     * @param request
     * @return
     */
    @RequestMapping("/carItem/changeCounts.json")
    @ResponseBody
    public Map cartItemCountsChg(Long counts, String cartItemId, String areaCode,
                                 @RequestParam(value = "cartItemIds[]", required = false) ArrayList<String> cartItemIds,
                                 String debug, HttpServletRequest request) {
        long methodStartTime = System.currentTimeMillis();
        log.info("### 开始修改购物车商品数量 ... ###");
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        rsMap.put("data", null);
        rsMap.put(GlobalContants.ResponseString.MESSAGE, "suc");

        /** 获取当前用户的购物车信息 */
        long memberVoTime = System.currentTimeMillis();
        MemberVo memberVo = loginService.findMemberVo(request);
        log.info("获取 memberVo 耗时 ms", System.currentTimeMillis() - memberVoTime);

        long cartTime = System.currentTimeMillis();
        CartDto cart = cartApi.getUserCart(memberVo.getUser().getId());
        log.info("获取购物车对象耗时 {} ms", System.currentTimeMillis() - cartTime);

        long cartItemTime = System.currentTimeMillis();
        CartItemDto cartItem = cartItemApi.findById(cartItemId);
        log.info("获取购物车商品数据耗时 {} ms", System.currentTimeMillis() - cartItemTime);

        if (cart != null && cartItem != null) {
            counts = counts <= 0 ? 1 : counts;

            Long changeCountTimer = System.currentTimeMillis();
            Map<String, Object> apiRes = cartApi.cartItemCountsChg(cartItemId, counts, areaCode);
            log.info("修改购物车商品数量耗时 {} 秒", (System.currentTimeMillis() - changeCountTimer) / 1000.0);

            if (GlobalContants.ResponseStatus.SUCCESS.equals(apiRes.get("status").toString())) {
                cartTime = System.currentTimeMillis();
                cart = cartApi.getUserCart(memberVo.getUser().getId());
                log.info("重新获取购物车对象耗时 {} ms", System.currentTimeMillis() - cartItemTime);

                long cartItemGroupsTime = System.currentTimeMillis();
                List<CartItemGroupVo> cartItemGroups = cartWebService.findCartItemGroups(request, cart, "1", false, true, areaCode, cartItemIds);
                log.info("获取按店铺分组的购物车商品列表耗时 {} ms", System.currentTimeMillis() - cartItemGroupsTime);

                long cartItemGroupsSortTime = System.currentTimeMillis();
                cartItemGroups = cartApi.cartItemGroupsSort(cartItemGroups);
                log.info("购物车商品列表排序耗时 {} ms", System.currentTimeMillis() - cartItemGroupsSortTime);

                CartItemVo cartItemVo = null;
                for (CartItemGroupVo groupVo : cartItemGroups) {
                    for (CartItemVo item : groupVo.getCartItems()) {
                        if (item.getId().equals(cartItemId)) {
                            cartItemVo = item;
                        }
                    }
                }
                Map<String, Object> returnDataMap = new HashMap<String, Object>();
                if (cartItemVo != null) {
                    returnDataMap.put("cartItemSumPrice", cartItemVo.getProductFashion().getSalePrice().setScale(0, BigDecimal.ROUND_CEILING).multiply(new BigDecimal(cartItemVo.getCount())));
                    returnDataMap.put("itemCounts", cartItemVo.getCount());
                }

                rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
                rsMap.put("data", this.generatePriceResMap(request, cartItemGroups, cartItem.getStoreId(), returnDataMap));
                rsMap.put(GlobalContants.ResponseString.MESSAGE, "Success");
            } else {
                rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
                rsMap.put(GlobalContants.ResponseString.ERROR_CODE, apiRes.get(GlobalContants.ResponseString.ERROR_CODE));
                rsMap.put("data", null);
                rsMap.put(GlobalContants.ResponseString.MESSAGE, apiRes.get(GlobalContants.ResponseString.MESSAGE));
            }
        } else {
            rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
            rsMap.put(GlobalContants.ResponseString.ERROR_CODE, 4);
            rsMap.put("data", null);
            rsMap.put(GlobalContants.ResponseString.MESSAGE, "无法获取用户购物车信息！");
        }
        log.info("### 修改购物车商品数量总耗时 {} ms", System.currentTimeMillis() - methodStartTime);
        return rsMap;
    }

    /**
     * 添加收藏
     *
     * @param cartItemId
     * @param debug
     * @param request
     * @return
     */
    @RequestMapping(value = {"/carItem/favAdd", "/carItem/favAdd.json"})
    @ResponseBody
    public Map addCartItemToFav(String cartItemId, String debug, HttpServletRequest request) {
        HashMap<String, Object> rsMap = new HashMap<String, Object>();
        rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        rsMap.put("data", null);
        rsMap.put("msg", "suc");
        String[] cartItemIds;
        cartItemIds = cartItemId.split(",");
        List<String> idsForDel = new ArrayList<>();
        String emptyCheck = makeFeildEmptyMsg(new String[]{"cartItemId"}, new Object[]{cartItemId});
        if (emptyCheck != null) {
            rsMap.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.ERROR);
            rsMap.put(GlobalContants.ResponseString.ERROR_CODE, 1);
            rsMap.put("data", null);
            rsMap.put(GlobalContants.ResponseString.MESSAGE, emptyCheck);
        } else {
            /** 获取当前用户的购物车信息 */
            MemberVo memberVo = loginService.findMemberVo(request);
            CartDto cart = cartApi.getUserCart(memberVo.getUser().getId());
            CartItemDto cartItem;
            for (String cid : cartItemIds) {
                cartItem = cartItemApi.findById(cid);
                if (cartItem != null) {
                    /** 新增收藏记录 */
                    MemberFavoriteDto favorite = memberFavoriteApi.addFavorite(memberVo.getMember().getId(), MemberFavoriteDto.FAVORITE_TYPE_PRODUCT_ID, cartItem.getProductId());
                    if (favorite != null) {
                        idsForDel.add(cid);
                    }
                }
            }
            Map<String, Object> apiRes = cartApi.deleteItem(cart.getId(), idsForDel.toArray(new String[idsForDel.size()]));

            cart = cartApi.getUserCart(memberVo.getUser().getId());
            List<CartItemGroupVo> cartItemGroups = cartWebService.findCartItemGroups(request, cart, "1", false, false, null, null);
            cartItemGroups = cartApi.cartItemGroupsSort(cartItemGroups);
            List<String> deletedItemIds = new ArrayList<>();
            /** 提取已删除记录 */
//            List<String> deletedItemIds = new ArrayList<>();
            if (!Lang.isEmpty(apiRes) && !Lang.isEmpty(apiRes.get("detials"))) {
                List<Map> details = (List<Map>) apiRes.get("detials");
                for (Map m : details) {
                    deletedItemIds.add((String) m.get("id"));
                }
            }
//            /** 提取已删除记录 */
//            for(CartItemGroupVo group : cartItemGroups) {
//                if(group != null) {
//                    for(CartItemVo item : group.getCartItems()) {
//                        if(item.getIsDelete()) {
//                            deletedItemIds.add(item.getId());
//                        }
//                    }
//                }
//            }

            Map<String, Object> rsData = new HashMap<String, Object>();
            Map<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("deletedItemIds", deletedItemIds);
            returnData.putAll(apiRes);
            rsMap.put("data", generatePriceResMap(request, cartItemGroups, null, returnData));
        }

        return rsMap;
    }

    /**
     * 返回字段不能为空的提示信息
     *
     * @param fields
     * @return
     */
    private String makeFeildEmptyMsg(String[] fields, Object[] values) {
        StringBuilder sb = new StringBuilder();
        sb.append("Required fields: ");
        boolean isEmpty = false;
        for (int i = 0; i < values.length; i++) {
            if (values[i] == null) {
                isEmpty = true;
            } else if (values[i] instanceof String) {
                isEmpty = StringUtils.isBlank((String) values[i]);
            }
            if (isEmpty) {
                sb.append(fields[i]);
                if (i < values.length - 1) {
                    sb.append(", ");
                }
            }

        }
        sb.append(" Redjected Empty Value");
        return isEmpty ? sb.toString() : null;
    }


    /**
     * 添加各项金额合计到返回数据集合<br />
     * <b>storeSumPrice: </b> 店铺总金额合计（storeId为null时此项为null）<br />
     * <b>sumCartPrice: </b> 购物车商品金额合计<br />
     * <b>sumMarketCartPrice: </b> 购物车市场价金额合计<br />
     * <b>sumGoodsCount: </b> 购物车商品数量合计<br />
     * <b>sumCartItemCounts: </b> 购物车商品件数合计<br />
     *
     * @param cartItemGroups
     * @param storeId
     * @return
     */
    private Map<String, Object> generatePriceResMap(HttpServletRequest request, List<CartItemGroupVo> cartItemGroups, String storeId) {
        return generatePriceResMap(request, cartItemGroups, storeId, null);
    }

    /**
     * 添加各项金额合计到返回数据集合<br />
     * <b>storeSumPrice: </b> 店铺总金额合计（storeId为null时此项为null）<br />
     * <b>sumCartPrice: </b> 购物车商品金额合计<br />
     * <b>sumMarketCartPrice: </b> 购物车市场价金额合计<br />
     * <b>sumGoodsCount: </b> 购物车商品数量合计<br />
     * <b>sumCartItemCounts: </b> 购物车商品件数合计<br />
     *
     * @param cartItemGroups
     * @param storeId
     * @param resMap         返回集合，如果不会null时，将返回的storeSumPrice、sumCartPrice、sumMarketCartPrice、sumGoodsCount、sumCartItemCounts<br/>
     *                       追加到指定集合中
     * @return
     */
    private Map<String, Object> generatePriceResMap(HttpServletRequest request, List<CartItemGroupVo> cartItemGroups, String storeId, Map<String, Object> resMap) {
        resMap = resMap == null ? new HashMap<String, Object>() : resMap;

        if (StringUtils.isNotBlank(storeId)) {
            resMap.put("storeSumPrice", cartWebService.findStoreSumPrice(cartItemGroups, storeId));
        }

        int validCounts = 0;

        for (CartItemGroupVo g : cartItemGroups) {
            if (!Lang.isEmpty(g)) {
                validCounts += g.getValidCounts();
            }
        }
        Double sumPrice = cartWebService.calSumCartPrice(cartItemGroups);
        resMap.put("validCounts", validCounts);
        resMap.put("sumCartPrice", sumPrice);
        resMap.put("sumMarketCartPrice", cartWebService.calSumMarketCartPrice(cartItemGroups));
        resMap.put("sumGoodsCount", cartWebService.calSumGoodsCount(cartItemGroups));
        resMap.put("sumCartItemCounts", cartWebService.calSumCartItemCounts(cartItemGroups));
        resMap.put("cartItemGroups", cartItemGroups);
//        calSumScore(request, sumPrice,resMap);
        return resMap;
    }

    /**
     * 临时获取当前地区
     */
    public void setAddressId(String provoiceId, HttpServletRequest request, HttpServletResponse response) {
        Map returnAddressIdMap = new HashMap();
        String returnProvoiceId = null;
        String returnCityId = null;
        String returnAreaId = null;
        String sessionProvoiceId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID);
        String cityId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_CITY_ID);
        String areaId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_AREA_ID);
        if (!Lang.isEmpty(sessionProvoiceId)) {
            if (!provoiceId.equals(sessionProvoiceId)) {
                returnProvoiceId = provoiceId;
                /**LWX 2017/1/5修改： 当省份改变时，修改已保存的2级3级4级地区 START */
                request.getSession().setAttribute(GlobalContants.AREA_LEVEL_CITY_ID, null);
                request.getSession().setAttribute(GlobalContants.AREA_LEVEL_AREA_ID, null);
                request.getSession().setAttribute(GlobalContants.AREA_LEVEL_TOWN_ID, null);
                /**LWX 2017/1/5修改： 当省份改变时，修改已保存的2级3级4级地区 END */
            } else {
                returnProvoiceId = sessionProvoiceId;

            }
        } else {
            returnProvoiceId = provoiceId;
            /**LWX 2017/1/5修改： 当省份改变时，修改已保存的2级3级4级地区 START */
            request.getSession().setAttribute(GlobalContants.AREA_LEVEL_CITY_ID, null);
            request.getSession().setAttribute(GlobalContants.AREA_LEVEL_AREA_ID, null);
            request.getSession().setAttribute(GlobalContants.AREA_LEVEL_TOWN_ID, null);
            /**LWX 2017/1/5修改： 当省份改变时，修改已保存的2级3级4级地区 END */
        }

        Map addressMap = areaService.getAddressIdSByParams(request, returnProvoiceId);
        returnCityId = (String) addressMap.get("cityId");
        returnAreaId = (String) addressMap.get("areaId");
        String returnTownId = (String) addressMap.get("townId");

        returnAddressIdMap.put("provoiceId", returnProvoiceId);
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        returnAddressIdMap.put("townId", returnTownId);

        /**
         * 设置缓存信息
         */
        AddressUtils.setAddressIdToSession(request, response, returnAddressIdMap);
    }

    public Map getIpAddressIds(HttpServletRequest request, HttpServletResponse response) {
        String sessionProvoiceId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID);
        Map returnMap = areaService.getAddressIdSByParams(request, sessionProvoiceId);
        return returnMap;
    }


    /*public Map getAddressIdSByParams(HttpServletRequest request, HttpServletResponse response, String proviceId) {
        Map returnAddressIdMap = new HashMap();
        String returnProvoiceId = null;
        String returnCityId = null;
        String returnAreaId = null;
        String sessionProvoiceId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_PROVINCE_ID);
        String cityId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_CITY_ID);
        String areaId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_AREA_ID);
        String townId = (String) request.getSession().getAttribute(GlobalContants.AREA_LEVEL_TOWN_ID);
        if (Lang.isEmpty(proviceId)) {
            if (!Lang.isEmpty(sessionProvoiceId)) {
                returnProvoiceId = sessionProvoiceId;
            } else {
                String remoteIp = Webs.getIp(request);
//                remoteIp = "183.43.167.15";
                if (!Lang.isEmpty(remoteIp)) {
                    Long ipL = IPtoLong.ipToLong(remoteIp);
                    Address currentAaddress = null;
                    currentAaddress = addressCommonApi.findAreaByIp(ipL, GlobalContants.AREA_LEVEL_PROVINCE);
                    if (!Lang.isEmpty(currentAaddress)) {
                        returnProvoiceId = currentAaddress.getId();
                    } else {
                        returnProvoiceId = "110000";
                        *//**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 START *//*
                        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_CITY_ID, null);
                        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_AREA_ID, null);
                        request.getSession().setAttribute(GlobalContants.AREA_LEVEL_TOWN_ID, null);
                        *//**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 END *//*
                    }

                } else {
                    returnProvoiceId = "110000";
                    *//**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 START *//*
                    request.getSession().setAttribute(GlobalContants.AREA_LEVEL_CITY_ID, null);
                    request.getSession().setAttribute(GlobalContants.AREA_LEVEL_AREA_ID, null);
                    request.getSession().setAttribute(GlobalContants.AREA_LEVEL_TOWN_ID, null);
                    *//**LWX 2017/1/10修改： 当省份改变时，修改已保存的2级3级4级地区 END *//*
                }
            }
        } else {
            if (!Lang.isEmpty(sessionProvoiceId)) {
                if (!proviceId.equals(sessionProvoiceId)) {
                    returnProvoiceId = proviceId;

                } else {
                    returnProvoiceId = sessionProvoiceId;

                }
            } else {
                returnProvoiceId = proviceId;

            }
        }

        returnCityId = (String) getAddressId(request, cityId, areaId, returnProvoiceId).get("cityId");
        returnAreaId = (String) getAddressId(request, cityId, areaId, returnProvoiceId).get("areaId");
        String returnTownId = (String) getAddressId(request, cityId, areaId, returnProvoiceId).get("areaId");


        returnAddressIdMap.put("provoiceId", returnProvoiceId);
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
//        returnAddressIdMap.put("townId",returnTownId);
        returnAddressIdMap.put("townId", townId);

        return returnAddressIdMap;
    }*/


    public void setAddressIdSByParams(HttpServletRequest request, HttpServletResponse response, String areaId) {
        if (Lang.isEmpty(areaId)) {
            throw new NullPointerException("areaId not null");
        } else {
            Map addressMap = Maps.newHashMap();
            String returnProvoiceId = null;
            String returnCityId = null;
            String returnAreaId = areaId;
            String returnTownId = null;
            AddressDto address = addressCommonApi.findById(returnAreaId);
            AddressDto parent = null;
            if (!Lang.isEmpty(address)) {
                parent = address.getParent();
                if (address.getLevelType().equals(GlobalContants.AREA_LEVEL_TOWN + "")) {
                    /**Akers 2017/1/5修改： 四级地区 START */
                    returnTownId = address.getId();
                    /**Akers 2017/1/5修改： 四级地区 END */
                    returnAreaId = parent.getId();
                    parent = parent.getParent();
                }
                if (!Lang.isEmpty(parent)) {
                    returnCityId = parent.getId();
                    if (!Lang.isEmpty(parent.getParent())) {
                        returnProvoiceId = parent.getParent().getId();
                    }
                }

            }
            addressMap.put("provoiceId", returnProvoiceId);
            addressMap.put("cityId", returnCityId);
            addressMap.put("areaId", returnAreaId);
            addressMap.put("townId", returnTownId);
            AddressUtils.setAddressIdToSession(request, response, addressMap);
        }
    }

    public Map getCityAndAreaId(String provoiceId) {
        Map returnAddressIdMap = new HashMap();

        String returnCityId = null;
        String returnAreaId = null;
        String returnTownId = null;
        AddressDto a = addressCommonApi.findFirstChild(provoiceId, true);
//        List<Address> areaAddressList=addressCommonApi.addressList(
//                AddressCommonApi.AddressLevel.CITY,provoiceId,true);
//        if(!Lang.isEmpty(areaAddressList)){
//            returnCityId=areaAddressList.get(0).getId();
//            if(!Lang.isEmpty(areaAddressList.get(0).getChild())){
//                returnAreaId=areaAddressList.get(0).getChild().get(0).getId();
//            }
//        }
        if (a != null) {
            returnCityId = a.getId();
            AddressDto addr = addressCommonApi.findFirstChild(returnCityId, false);
            returnAreaId = addr.getId();
            AddressDto c = addressCommonApi.findFirstChild(returnAreaId, true);
            if (c != null) {
                returnTownId = c.getId();
            }
        }
        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        returnAddressIdMap.put("townId", returnTownId);
        return returnAddressIdMap;
    }

    public Map getAddressId(HttpServletRequest request, String cityId, String areaId, String provoiceId) {
        Map returnAddressIdMap = new HashMap();

        String returnCityId = null;
        String returnAreaId = null;
        String returnTownId = null;
        String remoteIp = Webs.getIp(request);
//        remoteIp = "183.43.167.15";
        if (!Lang.isEmpty(remoteIp)) {
            Long ipL = IPtoLong.ipToLong(remoteIp);
            AddressDto currentAaddress = null;
            if (Lang.isEmpty(cityId) && Lang.isEmpty(areaId)) {//直接定位到当前位置所在的第三级
                currentAaddress = addressCommonApi.findAreaByIp(ipL, GlobalContants.AREA_LEVEL_AREA);

                if (Lang.isEmpty(currentAaddress)) {//查询第2级
                    currentAaddress = addressCommonApi.findAreaByIp(ipL, GlobalContants.AREA_LEVEL_CITY);
                    if (Lang.isEmpty(currentAaddress)) {

                        returnCityId = (String) getCityAndAreaId(provoiceId).get("cityId");
                        returnAreaId = (String) getCityAndAreaId(provoiceId).get("areaId");
                    } else {
                        returnCityId = currentAaddress.getId();
//                        List<Address> areaAddressList=addressCommonApi.addressList(AddressCommonApi.AddressLevel.AREA,returnCityId,false);
                        AddressDto a = addressCommonApi.findFirstChild(provoiceId, false);
                        if (a != null) {
                            returnAreaId = a.getId();
                            if (!Lang.isEmpty(returnAreaId)) {
                                AddressDto c = addressCommonApi.findFirstChild(returnAreaId, false);
                                if (c != null) {
                                    returnTownId = c.getId();
                                }
                            }
                        }
                    }
                } else {
                    returnAreaId = currentAaddress.getId();
                    returnCityId = currentAaddress.getParent().getId();
                }
            } else if (!Lang.isEmpty(cityId) && !Lang.isEmpty(areaId)) {
                returnAreaId = areaId;
                returnCityId = cityId;

            } else if (!Lang.isEmpty(cityId) && Lang.isEmpty(areaId)) {
                returnCityId = cityId;
//                List<Address> areaAddressList=addressCommonApi.addressList(AddressCommonApi.AddressLevel.AREA,returnCityId,false);
//                if(!Lang.isEmpty(areaAddressList)){
//                    returnAreaId=areaAddressList.get(0).getId();
//                }
                AddressDto a = addressCommonApi.findFirstChild(provoiceId, false);
                if (a != null) {
                    returnAreaId = a.getId();
                }
            } else if (Lang.isEmpty(cityId) && !Lang.isEmpty(areaId)) {
                returnAreaId = areaId;
                AddressDto address = addressCommonApi.findById(areaId);
                if (!Lang.isEmpty(address)) {
                    returnCityId = address.getParent().getId();
                }
            }
        } else {//无法定位地址，直接根据地址ID查询
            returnCityId = (String) getCityAndAreaId(provoiceId).get("cityId");
            returnAreaId = (String) getCityAndAreaId(provoiceId).get("areaId");
            returnTownId = (String) getCityAndAreaId(provoiceId).get("townId");
        }

        returnAddressIdMap.put("cityId", returnCityId);
        returnAddressIdMap.put("areaId", returnAreaId);
        returnAddressIdMap.put("townId", returnTownId);
        return returnAddressIdMap;
    }
}
